/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.scoring.model.ScoringAssetType;
import io.gravitee.apim.core.scoring.model.ScoringReport;
import io.gravitee.apim.core.scoring.use_case.SaveScoringResponseUseCase;
import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.scoring.response.ScoringResponseCommand;
import io.gravitee.cockpit.api.command.v1.scoring.response.ScoringResponseCommandPayload;
import io.gravitee.cockpit.api.command.v1.scoring.response.ScoringResponseReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.exchange.api.command.CommandStatus;
import io.gravitee.scoring.api.model.asset.AssetType;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ScoringResponseCommandHandler
implements CommandHandler<ScoringResponseCommand, ScoringResponseReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScoringResponseCommandHandler.class);
    private SaveScoringResponseUseCase saveScoringResponseUseCase;

    public ScoringResponseCommandHandler(@Lazy SaveScoringResponseUseCase saveScoringResponseUseCase) {
        this.saveScoringResponseUseCase = saveScoringResponseUseCase;
    }

    public String supportType() {
        return CockpitCommandType.SCORING_RESPONSE.name();
    }

    public Single<ScoringResponseReply> handle(ScoringResponseCommand command) {
        ScoringResponseCommandPayload payload = (ScoringResponseCommandPayload)command.getPayload();
        log.info("received response [{}]", (Object)payload.result());
        List<ScoringReport.Asset> analyzedAssets = payload.result().assetDiagnostics().stream().map(a -> {
            String string = a.asset().assetId();
            return new ScoringReport.Asset(string, switch (a.asset().type()) {
                default -> throw new MatchException(null, null);
                case AssetType.OPEN_API -> ScoringAssetType.SWAGGER;
                case AssetType.ASYNC_API -> ScoringAssetType.ASYNCAPI;
                case AssetType.GRAVITEE_API -> ScoringAssetType.GRAVITEE_DEFINITION;
            }, a.diagnostics().stream().map(d -> new ScoringReport.Diagnostic(ScoringReport.Severity.valueOf(d.severity().name()), new ScoringReport.Range(new ScoringReport.Position(d.range().start().line(), d.range().start().character()), new ScoringReport.Position(d.range().end().line(), d.range().end().character())), d.rule(), d.message(), d.path())).toList(), a.errors().stream().map(e -> new ScoringReport.ScoringError(e.code(), e.path())).toList());
        }).toList();
        return this.saveScoringResponseUseCase.execute(new SaveScoringResponseUseCase.Input(payload.correlationId(), analyzedAssets)).andThen((SingleSource)Single.just((Object)new ScoringResponseReply(command.getId(), CommandStatus.SUCCEEDED)));
    }
}

