/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.utils;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;

public final class DurationUtils {
    private static final Collection<IntervalData> INTERVAL = List.of(new IntervalData(Duration.ofMinutes(1L), Duration.ofSeconds(1L)), new IntervalData(Duration.ofMinutes(5L), Duration.ofSeconds(10L)), new IntervalData(Duration.ofMinutes(30L), Duration.ofSeconds(15L)), new IntervalData(Duration.ofHours(1L), Duration.ofSeconds(30L)), new IntervalData(Duration.ofHours(3L), Duration.ofMinutes(1L)), new IntervalData(Duration.ofHours(6L), Duration.ofMinutes(2L)), new IntervalData(Duration.ofHours(12L), Duration.ofMinutes(5L)), new IntervalData(Duration.ofDays(1L), Duration.ofMinutes(10L)), new IntervalData(Duration.ofDays(3L), Duration.ofMinutes(30L)), new IntervalData(Duration.ofDays(7L), Duration.ofHours(1L)), new IntervalData(Duration.ofDays(14L), Duration.ofHours(3L)), new IntervalData(Duration.ofDays(30L), Duration.ofHours(6L)), new IntervalData(Duration.ofDays(90L), Duration.ofHours(12L)));

    public static Duration buildIntervalFromTimePeriod(Instant from, Instant to) {
        Duration duration = Duration.between(from, to);
        return INTERVAL.stream().filter(id -> id.dataDuration().compareTo(duration) <= 0).max(Comparator.comparing(IntervalData::dataDuration)).map(IntervalData::interval).orElse(Duration.ofDays(1L));
    }

    @Generated
    private DurationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private record IntervalData(Duration dataDuration, Duration interval) {
    }
}

