/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.use_case;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.EnvironmentAuditLogEntity;
import io.gravitee.apim.core.event.crud_service.EventCrudService;
import io.gravitee.apim.core.event.crud_service.EventLatestCrudService;
import io.gravitee.apim.core.event.model.Event;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupCrudService;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupHistoryCrudService;
import io.gravitee.apim.core.shared_policy_group.exception.SharedPolicyGroupNotFoundException;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroupAuditEvent;
import io.gravitee.apim.core.shared_policy_group.query_service.SharedPolicyGroupHistoryQueryService;
import io.gravitee.rest.api.model.EventType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

@DomainService
public class UndeploySharedPolicyGroupUseCase {
    private final EventCrudService eventCrudService;
    private final EventLatestCrudService eventLatestCrudService;
    private final SharedPolicyGroupCrudService sharedPolicyGroupCrudService;
    private final SharedPolicyGroupHistoryCrudService sharedPolicyGroupHistoryCrudService;
    private final SharedPolicyGroupHistoryQueryService sharedPolicyGroupHistoryQueryService;
    private final AuditDomainService auditService;

    public Output execute(Input input) {
        SharedPolicyGroup sharedPolicyGroup = this.getLastDeployedSharedPolicyGroup(input);
        sharedPolicyGroup.undeploy();
        this.publishEvent(input, sharedPolicyGroup.toDefinition(), sharedPolicyGroup);
        this.updateSharedPolicyGroup(input);
        this.sharedPolicyGroupHistoryCrudService.create(sharedPolicyGroup);
        this.createAuditLog(sharedPolicyGroup, sharedPolicyGroup, input.auditInfo);
        return new Output(sharedPolicyGroup);
    }

    private void updateSharedPolicyGroup(Input input) {
        SharedPolicyGroup existingSharedPolicyGroup = this.sharedPolicyGroupCrudService.getByEnvironmentId(input.environmentId(), input.sharedPolicyGroupId());
        existingSharedPolicyGroup.undeploy();
        this.sharedPolicyGroupCrudService.update(existingSharedPolicyGroup);
    }

    private SharedPolicyGroup getLastDeployedSharedPolicyGroup(Input input) {
        Optional<SharedPolicyGroup> optional = this.sharedPolicyGroupHistoryQueryService.getLatestBySharedPolicyGroupId(input.environmentId(), input.sharedPolicyGroupId());
        if (optional.isEmpty()) {
            throw new SharedPolicyGroupNotFoundException(input.sharedPolicyGroupId());
        }
        return optional.get();
    }

    private void publishEvent(Input input, io.gravitee.definition.model.v4.sharedpolicygroup.SharedPolicyGroup definition, SharedPolicyGroup sharedPolicyGroup) {
        Event event = this.eventCrudService.createEvent(input.auditInfo().organizationId(), input.environmentId, Set.of(input.environmentId), EventType.UNDEPLOY_SHARED_POLICY_GROUP, definition, Map.ofEntries(Map.entry(Event.EventProperties.USER, input.auditInfo().actor().userId()), Map.entry(Event.EventProperties.SHARED_POLICY_GROUP_ID, sharedPolicyGroup.getCrossId())));
        this.eventLatestCrudService.createOrPatchLatestEvent(input.auditInfo.organizationId(), sharedPolicyGroup.getId(), event);
    }

    private void createAuditLog(SharedPolicyGroup oldSharedPolicyGroup, SharedPolicyGroup sharedPolicyGroup, AuditInfo auditInfo) {
        this.auditService.createEnvironmentAuditLog(EnvironmentAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).event(SharedPolicyGroupAuditEvent.SHARED_POLICY_GROUP_UNDEPLOYED).actor(auditInfo.actor()).oldValue(oldSharedPolicyGroup).newValue(sharedPolicyGroup).createdAt(sharedPolicyGroup.getUpdatedAt()).properties(Map.of(AuditProperties.SHARED_POLICY_GROUP, sharedPolicyGroup.getId())).build());
    }

    @Generated
    public UndeploySharedPolicyGroupUseCase(EventCrudService eventCrudService, EventLatestCrudService eventLatestCrudService, SharedPolicyGroupCrudService sharedPolicyGroupCrudService, SharedPolicyGroupHistoryCrudService sharedPolicyGroupHistoryCrudService, SharedPolicyGroupHistoryQueryService sharedPolicyGroupHistoryQueryService, AuditDomainService auditService) {
        this.eventCrudService = eventCrudService;
        this.eventLatestCrudService = eventLatestCrudService;
        this.sharedPolicyGroupCrudService = sharedPolicyGroupCrudService;
        this.sharedPolicyGroupHistoryCrudService = sharedPolicyGroupHistoryCrudService;
        this.sharedPolicyGroupHistoryQueryService = sharedPolicyGroupHistoryQueryService;
        this.auditService = auditService;
    }

    public record Input(String sharedPolicyGroupId, String environmentId, AuditInfo auditInfo) {
        public Input {
            Objects.requireNonNull(sharedPolicyGroupId);
            Objects.requireNonNull(environmentId);
            Objects.requireNonNull(auditInfo);
        }
    }

    public record Output(SharedPolicyGroup sharedPolicyGroup) {
    }
}

