/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.async_job.model.AsyncJob;
import io.gravitee.apim.core.async_job.query_service.AsyncJobQueryService;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.exception.IntegrationNotFoundException;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.model.IntegrationView;
import io.gravitee.apim.core.integration.service_provider.IntegrationAgent;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.apim.core.membership.domain_service.IntegrationPrimaryOwnerDomainService;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class GetIntegrationUseCase {
    private final IntegrationCrudService integrationCrudService;
    private final AsyncJobQueryService asyncJobQueryService;
    private final LicenseDomainService licenseDomainService;
    private final IntegrationAgent integrationAgent;
    private final IntegrationPrimaryOwnerDomainService integrationPrimaryOwnerDomainService;

    public Output execute(Input input) {
        String integrationId = input.integrationId();
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.organizationId())) {
            throw NotAllowedDomainException.noLicenseForFederation();
        }
        Integration integration = this.integrationCrudService.findById(integrationId).orElseThrow(() -> new IntegrationNotFoundException(integrationId));
        IntegrationView.AgentStatus agentStatus = (IntegrationView.AgentStatus)((Object)this.integrationAgent.getAgentStatusFor(integrationId).map(status -> IntegrationView.AgentStatus.valueOf(status.name())).blockingGet());
        Optional<AsyncJob> pendingJob = this.asyncJobQueryService.findPendingJobFor(integrationId);
        IntegrationView.PrimaryOwner primaryOwner = (IntegrationView.PrimaryOwner)this.integrationPrimaryOwnerDomainService.getIntegrationPrimaryOwner(input.organizationId(), integration.getId()).map(po -> new IntegrationView.PrimaryOwner(po.id(), po.email(), po.displayName())).onErrorComplete().blockingGet();
        return new Output(new IntegrationView(integration, agentStatus, pendingJob.orElse(null), primaryOwner));
    }

    @Generated
    public GetIntegrationUseCase(IntegrationCrudService integrationCrudService, AsyncJobQueryService asyncJobQueryService, LicenseDomainService licenseDomainService, IntegrationAgent integrationAgent, IntegrationPrimaryOwnerDomainService integrationPrimaryOwnerDomainService) {
        this.integrationCrudService = integrationCrudService;
        this.asyncJobQueryService = asyncJobQueryService;
        this.licenseDomainService = licenseDomainService;
        this.integrationAgent = integrationAgent;
        this.integrationPrimaryOwnerDomainService = integrationPrimaryOwnerDomainService;
    }

    public record Input(String integrationId, String organizationId) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String integrationId;
            @Generated
            private String organizationId;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder integrationId(String integrationId) {
                this.integrationId = integrationId;
                return this;
            }

            @Generated
            public InputBuilder organizationId(String organizationId) {
                this.organizationId = organizationId;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.integrationId, this.organizationId);
            }

            @Generated
            public String toString() {
                return "GetIntegrationUseCase.Input.InputBuilder(integrationId=" + this.integrationId + ", organizationId=" + this.organizationId + ")";
            }
        }
    }

    public record Output(IntegrationView integration) {
    }
}

