/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.subscription;

import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.subscription.domain_service.AcceptSubscriptionDomainService;
import io.gravitee.apim.core.subscription.domain_service.CloseSubscriptionDomainService;
import io.gravitee.apim.core.subscription.domain_service.SubscriptionCRDSpecDomainService;
import io.gravitee.apim.core.subscription.model.crd.SubscriptionCRDSpec;
import io.gravitee.apim.infra.adapter.SubscriptionAdapter;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SubscriptionCRDSpecDomainServiceImpl
implements SubscriptionCRDSpecDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriptionCRDSpecDomainServiceImpl.class);
    private static final String ACCEPT_REASON = "Kubernetes subscriptions are always auto accepted";
    private final SubscriptionService subscriptionService;
    private final SubscriptionAdapter adapter;
    private final AcceptSubscriptionDomainService acceptService;
    private final CloseSubscriptionDomainService closeSubscriptionDomainService;

    @Override
    public io.gravitee.apim.core.subscription.model.SubscriptionEntity createOrUpdate(AuditInfo auditInfo, SubscriptionCRDSpec spec) {
        return this.find(spec.getId()).map(existing -> this.update(auditInfo, (io.gravitee.apim.core.subscription.model.SubscriptionEntity)existing, spec)).orElseGet(() -> this.create(auditInfo, spec));
    }

    @Override
    public void delete(AuditInfo auditInfo, String id) {
        this.closeSubscriptionDomainService.closeSubscription(id, auditInfo);
    }

    private io.gravitee.apim.core.subscription.model.SubscriptionEntity create(AuditInfo auditInfo, SubscriptionCRDSpec spec) {
        io.gravitee.apim.core.subscription.model.SubscriptionEntity entity = this.adapter.fromSpec(spec);
        ZonedDateTime now = ZonedDateTime.now();
        entity.setEnvironmentId(auditInfo.environmentId());
        entity.setSubscribedBy(auditInfo.actor().userId());
        entity.setProcessedBy(auditInfo.actor().userId());
        entity.setCreatedAt(now);
        entity.setProcessedAt(now);
        entity.setStartingAt(now);
        entity.setReasonMessage(ACCEPT_REASON);
        entity.setEndingAt(spec.getEndingAt());
        SubscriptionEntity subscription = this.subscriptionService.create(SubscriptionCRDSpecDomainServiceImpl.toExecutionContext(auditInfo), this.adapter.fromCoreForCreate(entity), null, spec.getId());
        if (entity.getEndingAt() != null) {
            this.subscriptionService.update(SubscriptionCRDSpecDomainServiceImpl.toExecutionContext(auditInfo), this.adapter.fromCoreForUpdate(entity));
        }
        log.debug("Auto accepting subscription [{}]", (Object)spec.getId());
        return this.acceptService.autoAccept(subscription.getId(), ZonedDateTime.now(), spec.getEndingAt(), ACCEPT_REASON, "", auditInfo);
    }

    private io.gravitee.apim.core.subscription.model.SubscriptionEntity update(AuditInfo auditInfo, io.gravitee.apim.core.subscription.model.SubscriptionEntity existing, SubscriptionCRDSpec spec) {
        io.gravitee.apim.core.subscription.model.SubscriptionEntity update = existing.toBuilder().build();
        if (!Objects.equals(spec.getEndingAt(), existing.getEndingAt())) {
            log.debug("Updating expiry date to [{}] for subscription [{}]", (Object)spec.getEndingAt(), (Object)spec.getId());
            update.setEndingAt(spec.getEndingAt());
        }
        this.subscriptionService.update(SubscriptionCRDSpecDomainServiceImpl.toExecutionContext(auditInfo), this.adapter.fromCoreForUpdate(update));
        return update;
    }

    private Optional<io.gravitee.apim.core.subscription.model.SubscriptionEntity> find(String id) {
        try {
            return Optional.ofNullable(this.subscriptionService.findById(id)).map(this.adapter::toCore);
        }
        catch (SubscriptionNotFoundException e) {
            log.debug("Subscription [{}] not found", (Object)id);
            return Optional.empty();
        }
    }

    private static ExecutionContext toExecutionContext(AuditInfo auditInfo) {
        return new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
    }

    @Generated
    public SubscriptionCRDSpecDomainServiceImpl(SubscriptionService subscriptionService, SubscriptionAdapter adapter, AcceptSubscriptionDomainService acceptService, CloseSubscriptionDomainService closeSubscriptionDomainService) {
        this.subscriptionService = subscriptionService;
        this.adapter = adapter;
        this.acceptService = acceptService;
        this.closeSubscriptionDomainService = closeSubscriptionDomainService;
    }
}

