/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.data.domain.Order;
import io.gravitee.common.event.EventManager;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.api.IdentityProviderRepository;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.api.search.GroupCriteria;
import io.gravitee.repository.management.api.search.PageCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Group;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.GroupEventRule;
import io.gravitee.repository.management.model.IdentityProvider;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.PageReferenceType;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.model.AccessControlReferenceType;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.GroupEventRuleEntity;
import io.gravitee.rest.api.model.GroupSimpleEntity;
import io.gravitee.rest.api.model.InvitationReferenceType;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewGroupEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateGroupEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.alert.ApplicationAlertEventType;
import io.gravitee.rest.api.model.alert.ApplicationAlertMembershipEvent;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.model.settings.ApiPrimaryOwnerMode;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.InvitationService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.exceptions.GroupNameAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.GroupNotFoundException;
import io.gravitee.rest.api.service.exceptions.GroupsNotFoundException;
import io.gravitee.rest.api.service.exceptions.StillPrimaryOwnerException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.reactivex.rxjava3.functions.Action;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class GroupServiceImpl
extends AbstractService
implements GroupService {
    private final Logger logger = LoggerFactory.getLogger(GroupServiceImpl.class);
    @Lazy
    @Autowired
    private GroupRepository groupRepository;
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private InvitationService invitationService;
    @Lazy
    @Autowired
    private PageRepository pageRepository;
    @Lazy
    @Autowired
    private PlanRepository planRepository;
    @Lazy
    @Autowired
    private IdentityProviderRepository identityProviderRepository;
    @Autowired
    private EventManager eventManager;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private ApiConverter apiConverter;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ApiSearchService apiSearchService;
    @Lazy
    @Autowired
    private ApiMetadataService apiMetadataService;
    @Lazy
    @Autowired
    private SearchEngineService searchEngineService;

    @Override
    public List<GroupEntity> findAll(ExecutionContext executionContext) {
        try {
            this.logger.debug("Find all groups");
            Set all = this.groupRepository.findAllByEnvironment(executionContext.getEnvironmentId());
            this.logger.debug("Find all groups - DONE");
            List<GroupEntity> groups = all.stream().map(this::map).sorted(Comparator.comparing(GroupEntity::getName)).collect(Collectors.toList());
            this.populateGroupFlags(executionContext, groups);
            if (this.permissionService.hasPermission(executionContext, RolePermission.ENVIRONMENT_GROUP, executionContext.getEnvironmentId(), RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE)) {
                groups.forEach(groupEntity -> groupEntity.setManageable(true));
            } else {
                Optional<RoleEntity> optGroupAdminSystemRole = this.roleService.findByScopeAndName(RoleScope.GROUP, SystemRole.ADMIN.name(), executionContext.getOrganizationId());
                if (optGroupAdminSystemRole.isPresent()) {
                    List<String> groupIds = this.membershipService.getMembershipsByMemberAndReferenceAndRole(MembershipMemberType.USER, this.getAuthenticatedUsername(), MembershipReferenceType.GROUP, optGroupAdminSystemRole.get().getId()).stream().map(MembershipEntity::getReferenceId).toList();
                    groups.forEach(groupEntity -> groupEntity.setManageable(groupIds.contains(groupEntity.getId())));
                }
            }
            return groups;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find all groups", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all groups", ex);
        }
    }

    @Override
    public io.gravitee.common.data.domain.Page<GroupEntity> search(ExecutionContext executionContext, Pageable pageable, Order.Direction orderDirection, String query) {
        Optional<RoleEntity> optGroupAdminSystemRole;
        String environmentId = executionContext.getEnvironmentId();
        GroupCriteria.GroupCriteriaBuilder groupCriteriaBuilder = GroupCriteria.builder().environmentId(environmentId).query(query);
        if (!this.permissionService.hasPermission(executionContext, RolePermission.ENVIRONMENT_GROUP, executionContext.getEnvironmentId(), RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE) && (optGroupAdminSystemRole = this.roleService.findByScopeAndName(RoleScope.GROUP, SystemRole.ADMIN.name(), executionContext.getOrganizationId())).isPresent()) {
            Set groupIds = this.membershipService.getMembershipsByMemberAndReferenceAndRole(MembershipMemberType.USER, this.getAuthenticatedUsername(), MembershipReferenceType.GROUP, optGroupAdminSystemRole.get().getId()).stream().map(MembershipEntity::getReferenceId).collect(Collectors.toSet());
            groupCriteriaBuilder.idIn(groupIds);
        }
        io.gravitee.common.data.domain.Page groups = this.groupRepository.search(groupCriteriaBuilder.build(), GroupServiceImpl.convert(pageable), orderDirection);
        return groups.map(this::map);
    }

    @Override
    public List<GroupSimpleEntity> findAllByOrganization(String organizationId) {
        try {
            this.logger.debug("Find all groups for organization {}", (Object)organizationId);
            Set groups = this.groupRepository.findAllByOrganization(organizationId);
            this.logger.debug("Find all groups for organization {} - DONE", (Object)organizationId);
            return groups.stream().map((? super T group) -> this.mapToSimple((Group)group, organizationId)).sorted(Comparator.comparing(GroupSimpleEntity::getName)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find all groups", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all groups", ex);
        }
    }

    private void populateGroupFlags(ExecutionContext executionContext, List<GroupEntity> groups) {
        RoleEntity apiPORole = this.roleService.findByScopeAndName(RoleScope.API, SystemRole.PRIMARY_OWNER.name(), executionContext.getOrganizationId()).orElseThrow(() -> new TechnicalManagementException("API System Role 'PRIMARY_OWNER' not found."));
        groups.forEach(group -> {
            boolean isApiPO = !this.membershipService.getMembershipsByMemberAndReferenceAndRole(MembershipMemberType.GROUP, group.getId(), MembershipReferenceType.API, apiPORole.getId()).isEmpty();
            group.setPrimaryOwner(isApiPO);
        });
    }

    @Override
    public List<GroupEntity> findByName(String environmentId, String name) {
        try {
            this.logger.debug("findByUsername : {}", (Object)name);
            if (name == null) {
                return Collections.emptyList();
            }
            List<GroupEntity> groupEntities = this.groupRepository.findAllByEnvironment(environmentId).stream().filter(group -> group.getName().equals(name)).map(this::map).sorted(Comparator.comparing(GroupEntity::getName)).collect(Collectors.toList());
            this.logger.debug("findByUsername : {} - DONE", (Object)name);
            return groupEntities;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find groups by name", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find groups by name", ex);
        }
    }

    @Override
    public GroupEntity create(ExecutionContext executionContext, NewGroupEntity group) {
        try {
            this.logger.debug("create {}", (Object)group);
            if (!this.findByName(executionContext.getEnvironmentId(), group.getName()).isEmpty()) {
                throw new GroupNameAlreadyExistsException(group.getName());
            }
            Group newGroup = this.map(group);
            newGroup.setId(UuidString.generateRandom());
            newGroup.setEnvironmentId(executionContext.getEnvironmentId());
            newGroup.setCreatedAt(new Date());
            newGroup.setUpdatedAt(newGroup.getCreatedAt());
            GroupEntity grp = this.map((Group)this.groupRepository.create((Object)newGroup));
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.GROUP, newGroup.getId()), (Audit.AuditEvent)Group.AuditEvent.GROUP_CREATED, newGroup.getCreatedAt(), null, newGroup);
            this.logger.debug("create {} - DONE", (Object)grp);
            return grp;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to create a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to create a group", ex);
        }
    }

    @Override
    public GroupEntity update(ExecutionContext executionContext, String groupId, UpdateGroupEntity group) {
        try {
            this.logger.debug("update {}", (Object)group);
            GroupEntity updatedGroupEntity = this.findById(executionContext, groupId);
            Group previousGroup = this.map(updatedGroupEntity, executionContext.getEnvironmentId());
            updatedGroupEntity.setName(group.getName());
            updatedGroupEntity.setUpdatedAt(new Date());
            updatedGroupEntity.setEventRules(group.getEventRules());
            updatedGroupEntity.setMaxInvitation(group.getMaxInvitation());
            updatedGroupEntity.setLockApiRole(group.isLockApiRole());
            updatedGroupEntity.setLockApplicationRole(group.isLockApplicationRole());
            updatedGroupEntity.setSystemInvitation(group.isSystemInvitation());
            updatedGroupEntity.setEmailInvitation(group.isEmailInvitation());
            updatedGroupEntity.setDisableMembershipNotifications(group.isDisableMembershipNotifications());
            Group updatedGroup = this.map(updatedGroupEntity, executionContext.getEnvironmentId());
            GroupEntity grp = this.map((Group)this.groupRepository.update((Object)updatedGroup));
            this.logger.debug("update {} - DONE", (Object)grp);
            this.updateDefaultRoles(executionContext, groupId, updatedGroupEntity.getRoles(), group.getRoles());
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.GROUP, groupId), (Audit.AuditEvent)Group.AuditEvent.GROUP_UPDATED, updatedGroupEntity.getUpdatedAt(), previousGroup, updatedGroup);
            this.reindexApisIfPrimaryOwnerGroup(executionContext, grp);
            return this.findById(executionContext, groupId);
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to update a group";
            this.logger.error("An error occurs while trying to update a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to update a group", ex);
        }
    }

    private void reindexApisIfPrimaryOwnerGroup(ExecutionContext executionContext, GroupEntity grp) {
        if (grp == null || !grp.isPrimaryOwner()) {
            return;
        }
        String primaryOwnerRoleId = this.roleService.findByScopeAndName(RoleScope.API, SystemRole.PRIMARY_OWNER.name(), executionContext.getOrganizationId()).orElseThrow(() -> new IllegalStateException("Primary Owner role not found")).getId();
        Set<String> apiIds = this.membershipService.getReferenceIdsByMemberAndReferenceAndRoleIn(MembershipMemberType.GROUP, grp.getId(), MembershipReferenceType.API, Set.of(primaryOwnerRoleId));
        if (apiIds.isEmpty()) {
            return;
        }
        for (String apiId : apiIds) {
            GenericApiEntity apiEntity = this.apiSearchService.findGenericById(executionContext, apiId);
            GenericApiEntity genericApiEntity = this.apiMetadataService.fetchMetadataForApi(executionContext, apiEntity);
            this.searchEngineService.index(executionContext, (Indexable)genericApiEntity, false);
        }
    }

    private void updateDefaultRoles(ExecutionContext executionContext, String groupId, Map<RoleScope, String> formerRoles, Map<RoleScope, String> newRoles) throws TechnicalException {
        RoleScope[] groupRoleScopes;
        for (RoleScope roleScope : groupRoleScopes = new RoleScope[]{RoleScope.API, RoleScope.APPLICATION}) {
            if (formerRoles != null && formerRoles.get(roleScope) != null && (newRoles == null || newRoles != null && !formerRoles.get(roleScope).equals(newRoles.get(roleScope)) && !SystemRole.PRIMARY_OWNER.name().equals(newRoles.get(roleScope)))) {
                this.removeOldDefaultRole(executionContext, groupId, MembershipReferenceType.valueOf((String)roleScope.name()));
            }
            if (newRoles == null || newRoles.get(roleScope) == null || SystemRole.PRIMARY_OWNER.name().equals(newRoles.get(roleScope)) || formerRoles != null && (formerRoles == null || newRoles.get(roleScope).equals(formerRoles.get(roleScope)))) continue;
            this.addNewDefaultRole(executionContext, groupId, newRoles.get(roleScope), roleScope);
        }
    }

    private void removeOldDefaultRole(ExecutionContext executionContext, String groupId, MembershipReferenceType referenceType) {
        this.membershipService.deleteReferenceMember(executionContext, referenceType, null, MembershipMemberType.GROUP, groupId);
    }

    private void addNewDefaultRole(ExecutionContext executionContext, String groupId, String newRole, RoleScope roleScope) {
        this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.valueOf((String)roleScope.name()), null), new MembershipService.MembershipMember(groupId, null, MembershipMemberType.GROUP), new MembershipService.MembershipRole(roleScope, newRole));
    }

    @Override
    @NotNull
    public GroupEntity findById(ExecutionContext executionContext, String groupId) {
        try {
            this.logger.debug("findById {}", (Object)groupId);
            Optional<Group> group = this.groupRepository.findById((Object)groupId).filter(g -> !executionContext.hasEnvironmentId() || g.getEnvironmentId().equalsIgnoreCase(executionContext.getEnvironmentId()));
            if (!group.isPresent()) {
                throw new GroupNotFoundException(groupId);
            }
            this.logger.debug("findById {} - DONE", (Object)group.get());
            GroupEntity groupEntity = this.map(executionContext, group.get());
            if (groupEntity == null) {
                this.logger.error("An error occurs while trying to find a group {}", (Object)groupId);
                throw new TechnicalManagementException("An error occurs while trying to find a group " + groupId);
            }
            if (executionContext.hasEnvironmentId() && this.permissionService.hasPermission(executionContext, RolePermission.ENVIRONMENT_GROUP, executionContext.getEnvironmentId(), RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE)) {
                groupEntity.setManageable(true);
            } else {
                Optional<RoleEntity> optGroupAdminSystemRole = this.roleService.findByScopeAndName(RoleScope.GROUP, SystemRole.ADMIN.name(), executionContext.getOrganizationId());
                if (optGroupAdminSystemRole.isPresent()) {
                    List groupIds = this.membershipService.getMembershipsByMemberAndReferenceAndRole(MembershipMemberType.USER, this.getAuthenticatedUsername(), MembershipReferenceType.GROUP, optGroupAdminSystemRole.get().getId()).stream().map(MembershipEntity::getReferenceId).collect(Collectors.toList());
                    groupEntity.setManageable(groupIds.contains(groupEntity.getId()));
                }
            }
            return groupEntity;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find a group", ex);
        }
    }

    @Override
    public void associate(ExecutionContext executionContext, String groupId, String associationType) {
        try {
            switch (associationType.toLowerCase(Locale.ROOT)) {
                case "api": {
                    this.apiRepository.search(new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId()).build(), null, ApiFieldFilter.allFields()).filter(api -> api.addGroup(groupId)).forEach(api -> {
                        this.runAndManageTechnicalException(() -> this.apiRepository.update(api));
                        this.triggerUpdateNotification(executionContext, (Api)api);
                    });
                    break;
                }
                case "application": {
                    this.applicationRepository.findAllByEnvironment(executionContext.getEnvironmentId(), new ApplicationStatus[0]).stream().filter(application -> application.addGroup(groupId)).forEach(application -> this.runAndManageTechnicalException(() -> this.applicationRepository.update(application)));
                    this.eventManager.publishEvent((Enum)ApplicationAlertEventType.APPLICATION_MEMBERSHIP_UPDATE, (Object)new ApplicationAlertMembershipEvent(executionContext.getOrganizationId(), Set.of(), Set.of(groupId)));
                }
            }
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to associate group to all {}", (Object)associationType, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to associate group to all " + associationType, ex);
        }
    }

    private void runAndManageTechnicalException(Action action) {
        try {
            action.run();
        }
        catch (Throwable e) {
            this.logger.error("An error occurs while trying to update group", e);
        }
    }

    @Override
    public Set<GroupEntity> findByIds(Set<String> groupIds) {
        try {
            this.logger.debug("findByIds {}", groupIds);
            Set groups = this.groupRepository.findByIds(groupIds);
            if (groups == null || groups.size() != groupIds.size()) {
                List groupsFound = groups == null ? Collections.emptyList() : groups.stream().map(Group::getId).collect(Collectors.toList());
                HashSet<String> groupIdsNotFound = new HashSet<String>(groupIds);
                groupIdsNotFound.removeAll(groupsFound);
                throw new GroupsNotFoundException(groupIdsNotFound);
            }
            this.logger.debug("findByIds {} - DONE", (Object)groups);
            return groups.stream().map(this::map).sorted(Comparator.comparing(GroupEntity::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find groups", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find groups", ex);
        }
    }

    @Override
    public Set<GroupEntity> findByEvent(String environmentId, GroupEvent event) {
        try {
            this.logger.debug("findByEvent : {}", (Object)event);
            Set set = this.groupRepository.findAllByEnvironment(environmentId).stream().filter(g -> g.getEventRules() != null && g.getEventRules().stream().map(GroupEventRule::getEvent).collect(Collectors.toList()).contains(event)).map(this::map).sorted(Comparator.comparing(GroupEntity::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
            this.logger.debug("findByEvent : {} - DONE", (Object)set);
            return set;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find groups by event", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find groups by event", ex);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String groupId) {
        try {
            this.logger.debug("delete {}", (Object)groupId);
            Optional<Group> group = this.groupRepository.findById((Object)groupId).filter(g -> g.getEnvironmentId().equalsIgnoreCase(executionContext.getEnvironmentId()));
            if (!group.isPresent()) {
                throw new GroupNotFoundException(groupId);
            }
            RoleEntity apiPORole = this.roleService.findByScopeAndName(RoleScope.API, SystemRole.PRIMARY_OWNER.name(), executionContext.getOrganizationId()).orElseThrow(() -> new TechnicalManagementException("API System Role 'PRIMARY_OWNER' not found."));
            long apiCount = this.membershipService.getMembershipsByMemberAndReferenceAndRole(MembershipMemberType.GROUP, groupId, MembershipReferenceType.API, apiPORole.getId()).size();
            if (apiCount > 0L) {
                throw new StillPrimaryOwnerException(apiCount, ApiPrimaryOwnerMode.GROUP);
            }
            this.membershipService.deleteReference(executionContext, MembershipReferenceType.GROUP, groupId);
            this.membershipService.deleteReferenceMember(executionContext, MembershipReferenceType.API, null, MembershipMemberType.GROUP, groupId);
            this.membershipService.deleteReferenceMember(executionContext, MembershipReferenceType.APPLICATION, null, MembershipMemberType.GROUP, groupId);
            Date updatedDate = new Date();
            Stream.generate(() -> this.apiRepository.search(new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId()).groups(new String[]{groupId}).build(), null, new PageableBuilder().pageSize(100).pageNumber(0).build(), ApiFieldFilter.allFields())).takeWhile(page -> page.getPageElements() > 0L).flatMap(page -> page.getContent().stream()).forEach(api -> {
                api.removeGroup(groupId);
                api.setUpdatedAt(updatedDate);
                try {
                    this.apiRepository.update(api);
                    this.triggerUpdateNotification(executionContext, (Api)api);
                }
                catch (TechnicalException ex) {
                    this.logger.error("An error occurs while trying to delete a group", (Throwable)ex);
                    throw new TechnicalManagementException("An error occurs while trying to delete a group", ex);
                }
                this.removeFromAPIPlans(groupId, updatedDate, api.getId());
                PageCriteria apiPageCriteria = new PageCriteria.Builder().referenceId(api.getId()).referenceType(PageReferenceType.API.name()).build();
                this.removeGroupFromPages(groupId, updatedDate, apiPageCriteria);
                this.removeIDPGroupMapping(groupId, updatedDate);
            });
            HashSet applicationIds = new HashSet();
            this.applicationRepository.findByGroups(Collections.singletonList(groupId), new ApplicationStatus[0]).forEach(application -> {
                application.removeGroup(groupId);
                application.setUpdatedAt(updatedDate);
                try {
                    this.applicationRepository.update(application);
                    applicationIds.add(application.getId());
                }
                catch (TechnicalException ex) {
                    this.logger.error("An error occurs while trying to delete a group", (Throwable)ex);
                    throw new TechnicalManagementException("An error occurs while trying to delete a group", ex);
                }
            });
            this.eventManager.publishEvent((Enum)ApplicationAlertEventType.APPLICATION_MEMBERSHIP_UPDATE, (Object)new ApplicationAlertMembershipEvent(executionContext.getOrganizationId(), applicationIds, Collections.emptySet()));
            PageCriteria environmentPageCriteria = new PageCriteria.Builder().referenceId(executionContext.getEnvironmentId()).referenceType(PageReferenceType.ENVIRONMENT.name()).build();
            this.removeGroupFromPages(groupId, updatedDate, environmentPageCriteria);
            this.groupRepository.delete((Object)groupId);
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.GROUP, groupId), (Audit.AuditEvent)Group.AuditEvent.GROUP_DELETED, new Date(), group.get(), null);
            this.logger.debug("delete {} - DONE", (Object)groupId);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a group", ex);
        }
    }

    private void removeIDPGroupMapping(String groupId, Date updatedDate) {
        try {
            Set allIdp = this.identityProviderRepository.findAll();
            for (IdentityProvider idp : allIdp) {
                boolean idpHasBeenModified = false;
                Map groupMappings = idp.getGroupMappings();
                if (groupMappings == null || groupMappings.isEmpty()) continue;
                for (Map.Entry mapping : groupMappings.entrySet()) {
                    ArrayList<String> groups;
                    if (mapping.getValue() == null || ((String[])mapping.getValue()).length <= 0 || !(groups = new ArrayList<String>(Arrays.asList((String[])mapping.getValue()))).contains(groupId)) continue;
                    groups.remove(groupId);
                    if (groups.isEmpty()) {
                        groupMappings.remove(mapping.getKey());
                    } else {
                        groupMappings.put((String)mapping.getKey(), groups.toArray(new String[groups.size()]));
                    }
                    idpHasBeenModified = true;
                }
                if (!idpHasBeenModified) continue;
                idp.setUpdatedAt(updatedDate);
                this.identityProviderRepository.update(idp);
            }
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a group", ex);
        }
    }

    private void removeFromAPIPlans(String groupId, Date updatedDate, String apiId) {
        try {
            Set apiPlans = this.planRepository.findByApi(apiId);
            for (Plan plan : apiPlans) {
                if (plan.getExcludedGroups() == null || !plan.getExcludedGroups().contains(groupId)) continue;
                plan.getExcludedGroups().remove(groupId);
                plan.setUpdatedAt(updatedDate);
                this.planRepository.update((Object)plan);
            }
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a group", ex);
        }
    }

    private void removeGroupFromPages(String groupId, Date updatedDate, PageCriteria pageCriteria) {
        try {
            List pages = this.pageRepository.search(pageCriteria);
            for (Page page : pages) {
                Set accessControlsToRemove;
                if (page.getAccessControls() == null || (accessControlsToRemove = page.getAccessControls().stream().filter(accessControl -> AccessControlReferenceType.GROUP.name().equals(accessControl.getReferenceType()) && accessControl.getReferenceId().equals(groupId)).collect(Collectors.toSet())).isEmpty()) continue;
                page.setUpdatedAt(updatedDate);
                page.getAccessControls().removeAll(accessControlsToRemove);
                this.pageRepository.update(page);
            }
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a group", ex);
        }
    }

    @Override
    public boolean isUserAuthorizedToAccessApiData(GenericApiEntity api, List<String> excludedGroups, String username) {
        if (username == null) {
            return (excludedGroups == null || excludedGroups.isEmpty()) && Visibility.PUBLIC.equals((Object)api.getVisibility());
        }
        if (excludedGroups == null || excludedGroups.isEmpty()) {
            return true;
        }
        if (!this.membershipService.getRoles(MembershipReferenceType.API, api.getId(), MembershipMemberType.USER, username).isEmpty()) {
            return true;
        }
        if (Visibility.PUBLIC.equals((Object)api.getVisibility())) {
            return excludedGroups.stream().allMatch(group -> this.membershipService.getRoles(MembershipReferenceType.GROUP, (String)group, MembershipMemberType.USER, username).stream().noneMatch(role -> role.getScope() == RoleScope.API));
        }
        if (Visibility.PRIVATE.equals((Object)api.getVisibility()) && api.getGroups() != null && !api.getGroups().isEmpty()) {
            HashSet authorizedGroups = new HashSet(api.getGroups());
            authorizedGroups.removeAll(excludedGroups);
            return authorizedGroups.stream().anyMatch(group -> this.membershipService.getRoles(MembershipReferenceType.GROUP, (String)group, MembershipMemberType.USER, username).stream().anyMatch(role -> role.getScope() == RoleScope.API));
        }
        return false;
    }

    @Override
    public Set<GroupEntity> findByUser(String user) {
        Set userGroups = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, user, MembershipReferenceType.GROUP).stream().map(MembershipEntity::getReferenceId).collect(Collectors.toSet());
        try {
            return this.groupRepository.findByIds(userGroups).stream().map(this::map).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find all user groups", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all user groups", ex);
        }
    }

    @Override
    public List<ApiEntity> getApis(String environmentId, String groupId) {
        return this.apiRepository.search(new ApiCriteria.Builder().environmentId(environmentId).groups(new String[]{groupId}).build(), null, ApiFieldFilter.defaultFields()).map((? super T api) -> {
            ApiEntity apiEntity = new ApiEntity();
            apiEntity.setId(api.getId());
            apiEntity.setName(api.getName());
            apiEntity.setVersion(api.getVersion());
            apiEntity.setVisibility(Visibility.valueOf((String)api.getVisibility().name()));
            return apiEntity;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ApplicationEntity> getApplications(String groupId) {
        try {
            return this.applicationRepository.findByGroups(Collections.singletonList(groupId), new ApplicationStatus[]{ApplicationStatus.ACTIVE}).stream().map((? super T application) -> {
                ApplicationEntity applicationEntity = new ApplicationEntity();
                applicationEntity.setId(application.getId());
                applicationEntity.setName(application.getName());
                return applicationEntity;
            }).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find all application of group {}", (Object)groupId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all application of group " + groupId, ex);
        }
    }

    private Group map(GroupEntity entity, String environmentId) {
        if (entity == null) {
            return null;
        }
        Group group = new Group();
        group.setId(entity.getId());
        group.setName(entity.getName());
        if (entity.getEventRules() != null && !entity.getEventRules().isEmpty()) {
            ArrayList<GroupEventRule> groupEventRules = new ArrayList<GroupEventRule>();
            for (GroupEventRuleEntity groupEventRuleEntity : entity.getEventRules()) {
                GroupEventRule eventRule = new GroupEventRule();
                eventRule.setEvent(GroupEvent.valueOf((String)groupEventRuleEntity.getEvent()));
                groupEventRules.add(eventRule);
            }
            group.setEventRules(groupEventRules);
        }
        group.setCreatedAt(entity.getCreatedAt());
        group.setUpdatedAt(entity.getUpdatedAt());
        group.setMaxInvitation(entity.getMaxInvitation());
        group.setLockApiRole(entity.isLockApiRole());
        group.setLockApplicationRole(entity.isLockApplicationRole());
        group.setSystemInvitation(entity.isSystemInvitation());
        group.setEmailInvitation(entity.isEmailInvitation());
        group.setEnvironmentId(environmentId);
        group.setDisableMembershipNotifications(entity.isDisableMembershipNotifications());
        group.setApiPrimaryOwner(entity.getApiPrimaryOwner());
        return group;
    }

    private Group map(NewGroupEntity entity) {
        if (entity == null) {
            return null;
        }
        Group group = new Group();
        group.setName(entity.getName());
        if (entity.getEventRules() != null && !entity.getEventRules().isEmpty()) {
            ArrayList<GroupEventRule> groupEventRules = new ArrayList<GroupEventRule>();
            for (GroupEventRuleEntity groupEventRuleEntity : entity.getEventRules()) {
                GroupEventRule eventRule = new GroupEventRule();
                eventRule.setEvent(GroupEvent.valueOf((String)groupEventRuleEntity.getEvent()));
                groupEventRules.add(eventRule);
            }
            group.setEventRules(groupEventRules);
        }
        group.setMaxInvitation(entity.getMaxInvitation());
        group.setLockApiRole(entity.isLockApiRole());
        group.setLockApplicationRole(entity.isLockApplicationRole());
        group.setSystemInvitation(entity.isSystemInvitation());
        group.setEmailInvitation(entity.isEmailInvitation());
        group.setDisableMembershipNotifications(entity.isDisableMembershipNotifications());
        return group;
    }

    private GroupSimpleEntity mapToSimple(Group group, String organizationId) {
        if (group == null) {
            return null;
        }
        EnvironmentEntity environment = this.environmentService.findByOrgAndIdOrHrid(organizationId, group.getEnvironmentId());
        GroupSimpleEntity entity = new GroupSimpleEntity();
        entity.setId(group.getId());
        entity.setName(group.getName());
        entity.setEnvironmentId(group.getEnvironmentId());
        entity.setEnvironmentName(environment.getName());
        return entity;
    }

    GroupEntity map(Group group) {
        return this.map(null, group);
    }

    private GroupEntity map(ExecutionContext executionContext, Group group) {
        RoleEntity defaultApplicationRole;
        if (group == null) {
            return null;
        }
        GroupEntity entity = new GroupEntity();
        entity.setId(group.getId());
        entity.setName(group.getName());
        if (group.getApiPrimaryOwner() != null && !group.getApiPrimaryOwner().isEmpty()) {
            entity.setApiPrimaryOwner(group.getApiPrimaryOwner());
            entity.setPrimaryOwner(true);
        }
        if (group.getEventRules() != null && !group.getEventRules().isEmpty()) {
            ArrayList<GroupEventRuleEntity> groupEventRules = new ArrayList<GroupEventRuleEntity>();
            for (GroupEventRule groupEventRule : group.getEventRules()) {
                GroupEventRuleEntity eventRuleEntity = new GroupEventRuleEntity();
                eventRuleEntity.setEvent(groupEventRule.getEvent().name());
                groupEventRules.add(eventRuleEntity);
            }
            entity.setEventRules(groupEventRules);
        }
        HashMap<RoleScope, String> roles = new HashMap<RoleScope, String>();
        RoleEntity defaultApiRole = this.getDefaultRole(group.getId(), RoleScope.API);
        if (defaultApiRole != null) {
            roles.put(RoleScope.API, defaultApiRole.getName());
        }
        if ((defaultApplicationRole = this.getDefaultRole(group.getId(), RoleScope.APPLICATION)) != null) {
            roles.put(RoleScope.APPLICATION, defaultApplicationRole.getName());
        }
        entity.setRoles(roles);
        entity.setCreatedAt(group.getCreatedAt());
        entity.setUpdatedAt(group.getUpdatedAt());
        entity.setMaxInvitation(group.getMaxInvitation());
        entity.setLockApiRole(group.isLockApiRole());
        entity.setLockApplicationRole(group.isLockApplicationRole());
        entity.setSystemInvitation(group.isSystemInvitation());
        entity.setEmailInvitation(group.isEmailInvitation());
        entity.setDisableMembershipNotifications(group.isDisableMembershipNotifications());
        entity.setOrigin(group.getOrigin());
        return entity;
    }

    @Override
    public void deleteUserFromGroup(ExecutionContext executionContext, String groupId, String username) {
        this.userService.findById(executionContext, username);
        this.eventManager.publishEvent((Enum)ApplicationAlertEventType.APPLICATION_MEMBERSHIP_UPDATE, (Object)new ApplicationAlertMembershipEvent(executionContext.getOrganizationId(), Collections.emptySet(), Collections.singleton(groupId)));
        this.membershipService.deleteReferenceMember(executionContext, MembershipReferenceType.GROUP, groupId, MembershipMemberType.USER, username);
        GroupEntity existingGroup = this.findById(executionContext, groupId);
        if (existingGroup.getApiPrimaryOwner() != null && existingGroup.getApiPrimaryOwner().equals(username)) {
            this.updateApiPrimaryOwner(groupId, username);
        }
    }

    private RoleEntity getDefaultRole(String groupId, RoleScope scope) {
        Optional optDefaultRole = this.membershipService.getRoles(MembershipReferenceType.valueOf((String)scope.name()), null, MembershipMemberType.GROUP, groupId).stream().findFirst();
        if (optDefaultRole.isPresent()) {
            return (RoleEntity)optDefaultRole.get();
        }
        return null;
    }

    @Override
    public int getNumberOfMembers(ExecutionContext executionContext, String groupId) {
        return this.membershipService.getMembersByReference(executionContext, MembershipReferenceType.GROUP, groupId).size() + this.invitationService.findByReference(InvitationReferenceType.GROUP, groupId).size();
    }

    @Override
    public void updateApiPrimaryOwner(String groupId, String newApiPrimaryOwner) {
        try {
            Group group = (Group)this.groupRepository.findById((Object)groupId).orElseThrow(() -> new GroupNotFoundException(groupId));
            group.setApiPrimaryOwner(newApiPrimaryOwner);
            this.groupRepository.update((Object)group);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find or update a group", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find or update a group", ex);
        }
    }

    private void triggerUpdateNotification(ExecutionContext executionContext, Api api) {
        ApiEntity apiEntity = this.apiConverter.toApiEntity(api, null);
        this.notifierService.trigger(executionContext, ApiHook.API_UPDATED, api.getId(), new NotificationParamsBuilder().api(apiEntity).user(this.userService.findById(executionContext, this.getAuthenticatedUsername())).build());
    }

    @Override
    public Set<Group> findAllByEnvironment(String environmentId) {
        try {
            this.logger.debug("Find all groups by environment ID {}", (Object)environmentId);
            Set groups = this.groupRepository.findAllByEnvironment(environmentId);
            this.logger.debug("Find all groups by environment ID {} - DONE", (Object)environmentId);
            return groups;
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while trying to find all groups", ex);
        }
    }
}

