/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.cockpit;

import com.google.common.base.Strings;
import com.google.common.net.InternetDomainName;
import io.gravitee.apim.core.cockpit.model.AccessPointTemplate;
import io.gravitee.apim.core.cockpit.query_service.CockpitAccessService;
import io.gravitee.apim.core.installation.domain_service.InstallationTypeDomainService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Service;

@Service
public class CockpitAccessServiceImpl
implements CockpitAccessService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CockpitAccessServiceImpl.class);
    private static final String MULTI_TENANT_ACCESS_POINT_PROPERTY = "installation.multi-tenant.accessPoints";
    private final InstallationTypeDomainService installationTypeDomainService;
    private final ConfigurableEnvironment environment;
    private final Map<AccessPointTemplate.Type, List<AccessPointTemplate>> accessPointsTemplate = new EnumMap<AccessPointTemplate.Type, List<AccessPointTemplate>>(AccessPointTemplate.Type.class);

    @PostConstruct
    public void afterPropertiesSet() {
        if (this.installationTypeDomainService.isMultiTenant()) {
            for (AccessPointTemplate.Type type : AccessPointTemplate.Type.values()) {
                ArrayList<AccessPointTemplate> accessPoints = new ArrayList<AccessPointTemplate>();
                for (AccessPointTemplate.Target target : AccessPointTemplate.Target.values()) {
                    String host = this.environment.getProperty("installation.multi-tenant.accessPoints." + type.getLabel() + "." + target.getLabel() + ".host");
                    if (host == null) continue;
                    this.validateHost(host);
                    Boolean secured = (Boolean)this.environment.getProperty("installation.multi-tenant.accessPoints." + type.getLabel() + "." + target.getLabel() + ".secured", Boolean.class, (Object)true);
                    accessPoints.add(AccessPointTemplate.builder().target(target).host(host).secured(secured).build());
                }
                if (accessPoints.isEmpty()) continue;
                this.accessPointsTemplate.put(type, accessPoints);
            }
            if (this.accessPointsTemplate.isEmpty()) {
                throw new InvalidAccessPointException("Installation is multi-tenant but doesn't configure any access points.");
            }
        }
    }

    private void validateHost(String value) {
        String toValidate = value.replaceAll("[{}]", "").replaceAll(":\\d*", "");
        if (!CockpitAccessServiceImpl.isValidDomainName(toValidate)) {
            throw new InvalidAccessPointException("Installation access point '%s' is malformed.".formatted(value));
        }
    }

    public static boolean isValidDomainName(String domain) {
        if (Strings.isNullOrEmpty((String)domain)) {
            return false;
        }
        return InternetDomainName.isValid((String)domain);
    }

    @Override
    public Map<AccessPointTemplate.Type, List<AccessPointTemplate>> getAccessPointsTemplate() {
        return this.accessPointsTemplate;
    }

    @Generated
    public CockpitAccessServiceImpl(InstallationTypeDomainService installationTypeDomainService, ConfigurableEnvironment environment) {
        this.installationTypeDomainService = installationTypeDomainService;
        this.environment = environment;
    }

    static class InvalidAccessPointException
    extends RuntimeException {
        public InvalidAccessPointException(String message) {
            super(message);
        }
    }
}

