/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.documentation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.documentation.domain_service.ValidatePageSourceDomainService;
import io.gravitee.apim.core.documentation.exception.InvalidPageSourceException;
import io.gravitee.apim.core.documentation.model.PageSource;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.apim.core.validation.Validator;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.rxjava3.core.Vertx;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.stereotype.Service;

@Service
public class ValidatePageSourceDomainServiceImpl
implements ValidatePageSourceDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidatePageSourceDomainServiceImpl.class);
    private static final String GITHUB_SOURCE_TYPE = "github-fetcher";
    private static final String HTTP_SOURCE_TYPE = "http-fetcher";
    private static final String GITHUB_URL_PROPERTY = "githubUrl";
    private static final String FETCH_CRON_PROPERTY = "fetchCron";
    private static final String VERSION_HEADER = "application/vnd.github.v3+json";
    private static final String GITHUB_REPOSITORY_BRANCH_OR_TAG = "branchOrTag";
    private static final String GITHUB_REPOSITORY_OWNER = "owner";
    private static final String GITHUB_REPOSITORY = "repository";
    private static final String GITHUB_FILEPATH = "filepath";
    private static final String GITHUB_USERNAME = "username";
    private static final String GITHUB_PERSONAL_ACCESS_TOKEN = "personalAccessToken";
    private static final String DEFAULT_GITHUB_API_URL = "https://api.github.com";
    private static final Set<String> REQUIRED_GITHUB_PROPERTIES = new HashSet<String>(Set.of("owner", "repository", "filepath"));
    private static final Set<String> OPTIONAL_GITHUB_PROPERTIES = Set.of("username", "personalAccessToken", "githubUrl", "fetchCron", "branchOrTag", "autoFetch", "useSystemProxy");
    private static final String HTTP_URL_PROPERTY = "url";
    private static final Set<String> REQUIRED_HTTP_PROPERTIES = Set.of("url");
    private static final Set<String> OPTIONAL_HTTP_PROPERTIES = Set.of("fetchCron", "autoFetch", "useSystemProxy");
    private final ObjectMapper objectMapper;
    private final Vertx vertx;

    public ValidatePageSourceDomainServiceImpl(ObjectMapper objectMapper, Vertx vertx) {
        this.objectMapper = objectMapper;
        this.vertx = vertx;
    }

    @Override
    public Validator.Result<ValidatePageSourceDomainService.Input> validateAndSanitize(ValidatePageSourceDomainService.Input input) {
        if (input.source() == null) {
            log.debug("Returning empty result as there is no source to validate");
            return Validator.Result.empty();
        }
        return switch (input.source().getType()) {
            case HTTP_SOURCE_TYPE -> this.validateAndSanitizeHTTPSource(input);
            case GITHUB_SOURCE_TYPE -> this.validateAndSanitizeGithubSource(input);
            default -> this.bypassValidation(input);
        };
    }

    private Validator.Result<ValidatePageSourceDomainService.Input> validateAndSanitizeGithubSource(ValidatePageSourceDomainService.Input input) {
        try {
            PageSource.PageSourceBuilder sanitizedBuilder = input.source().toBuilder();
            ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
            HashMap<String, Object> config = new HashMap<String, Object>(input.source().getConfigurationMap());
            config.putIfAbsent(GITHUB_URL_PROPERTY, DEFAULT_GITHUB_API_URL);
            this.validatePageSourceURL(input.pageName(), GITHUB_URL_PROPERTY, GITHUB_SOURCE_TYPE, config).errors().ifPresent(errors::addAll);
            this.checkRequiredProperties(input.pageName(), config, GITHUB_SOURCE_TYPE, REQUIRED_GITHUB_PROPERTIES).peek(sanitizedBuilder::configurationMap, errors::addAll);
            if (errors.stream().anyMatch(Validator.Error::isSevere)) {
                return Validator.Result.ofBoth(input.sanitized(sanitizedBuilder.build()), errors);
            }
            if (!this.canAccessResource(config)) {
                errors.add(Validator.Error.severe("Page [%s] cannot be fetched, this can come from either invalid / missing github credentials or an invalid file path", input.pageName()));
            }
            this.checkUnknownProperties(input.pageName(), config, GITHUB_SOURCE_TYPE, REQUIRED_GITHUB_PROPERTIES, OPTIONAL_GITHUB_PROPERTIES).peek(sanitizedBuilder::configurationMap, errors::addAll);
            this.validateFetchCronProperty(input.pageName(), GITHUB_SOURCE_TYPE, config).errors().ifPresent(errors::addAll);
            sanitizedBuilder.configuration(this.objectMapper.writeValueAsString(config));
            sanitizedBuilder.configurationMap(config);
            return Validator.Result.ofBoth(input.sanitized(sanitizedBuilder.build()), errors);
        }
        catch (JsonProcessingException e) {
            log.error("An error occurred while parsing the page source configuration", (Throwable)e);
            throw new InvalidPageSourceException("An error occurred while parsing the page source configuration");
        }
    }

    private boolean canAccessResource(Map<String, Object> config) {
        RequestOptions reqOptions = this.getGithubRequestOptions(config);
        if (config.get(GITHUB_PERSONAL_ACCESS_TOKEN) != null && config.get(GITHUB_USERNAME) != null) {
            String auth = String.valueOf(config.get(GITHUB_USERNAME)) + ":" + String.valueOf(config.get(GITHUB_PERSONAL_ACCESS_TOKEN));
            reqOptions.putHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(auth.getBytes()));
        }
        return (Boolean)this.vertx.createHttpClient().rxRequest(reqOptions).flatMap(req -> req.rxSend().flatMap(resp -> Single.just((Object)(resp.statusCode() == 200 ? 1 : 0)))).blockingGet();
    }

    private RequestOptions getGithubRequestOptions(Map<String, Object> config) {
        Object branchOrTag = config.get(GITHUB_REPOSITORY_BRANCH_OR_TAG);
        String url = String.valueOf(config.get(GITHUB_URL_PROPERTY)) + "/repos/" + String.valueOf(config.get(GITHUB_REPOSITORY_OWNER)) + "/" + String.valueOf(config.get(GITHUB_REPOSITORY)) + "/contents" + String.valueOf(config.get(GITHUB_FILEPATH)) + (String)(branchOrTag != null && StringUtils.isNotEmpty(branchOrTag.toString()) ? "?ref=" + String.valueOf(branchOrTag) : "");
        return new RequestOptions().setMethod(HttpMethod.GET).setAbsoluteURI(url).putHeader("User-Agent", config.get(GITHUB_REPOSITORY_OWNER).toString()).putHeader("Accept", VERSION_HEADER).setFollowRedirects(Boolean.valueOf(true));
    }

    private Validator.Result<ValidatePageSourceDomainService.Input> validateAndSanitizeHTTPSource(ValidatePageSourceDomainService.Input input) {
        PageSource.PageSourceBuilder sanitizedBuilder = input.source().toBuilder();
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        HashMap<String, Object> config = new HashMap<String, Object>(input.source().getConfigurationMap());
        this.checkRequiredProperties(input.pageName(), config, HTTP_SOURCE_TYPE, REQUIRED_HTTP_PROPERTIES).peek(sanitizedBuilder::configurationMap, errors::addAll);
        this.checkUnknownProperties(input.pageName(), config, HTTP_SOURCE_TYPE, REQUIRED_HTTP_PROPERTIES, OPTIONAL_HTTP_PROPERTIES).peek(sanitizedBuilder::configurationMap, errors::addAll);
        this.validatePageSourceURL(input.pageName(), HTTP_URL_PROPERTY, HTTP_SOURCE_TYPE, config).errors().ifPresent(errors::addAll);
        this.validateFetchCronProperty(input.pageName(), HTTP_SOURCE_TYPE, config).errors().ifPresent(errors::addAll);
        return Validator.Result.ofBoth(input.sanitized(sanitizedBuilder.build()), errors);
    }

    private Validator.Result<ValidatePageSourceDomainService.Input> bypassValidation(ValidatePageSourceDomainService.Input input) {
        log.debug("Bypassing validation for source {} as it has not been implemented", (Object)input.source().getType());
        return Validator.Result.ofValue(input);
    }

    private Validator.Result<String> validatePageSourceURL(String pageName, String urlFieldName, String sourceType, Map<String, Object> config) {
        try {
            String property = (String)config.get(urlFieldName);
            return Validator.Result.ofValue(URI.create(property).toURL().toString());
        }
        catch (Exception e) {
            return Validator.Result.withError(Validator.Error.severe("property [%s] of source [%s] must be a valid URL for page [%s]", urlFieldName, sourceType, pageName));
        }
    }

    private Validator.Result<String> validateFetchCronProperty(String pageName, String sourceType, Map<String, Object> config) {
        String cronExpression = (String)config.get(FETCH_CRON_PROPERTY);
        if (StringUtils.isEmpty(cronExpression)) {
            return Validator.Result.empty();
        }
        return CronExpression.isValidExpression((String)cronExpression) ? Validator.Result.ofValue(cronExpression) : Validator.Result.withError(Validator.Error.severe("property [fetchCron] of source [%s] must be a valid cron expression for page [%s]", sourceType, pageName));
    }

    private Validator.Result<Map<String, Object>> checkRequiredProperties(String pageName, Map<String, Object> config, String sourceType, Set<String> required) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        HashSet<String> requiredFields = new HashSet<String>(required);
        requiredFields.removeAll(config.keySet());
        if (CollectionUtils.isNotEmpty(requiredFields)) {
            errors.add(Validator.Error.severe("property [%s] is required in [%s] configuration for page [%s]", requiredFields.iterator().next(), sourceType, pageName));
        }
        return Validator.Result.ofBoth(config, errors);
    }

    private Validator.Result<Map<String, Object>> checkUnknownProperties(String pageName, Map<String, Object> config, String sourceType, Set<String> required, Set<String> optional) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        HashMap<String, Object> givenFields = new HashMap<String, Object>(config);
        givenFields.keySet().removeAll(required);
        givenFields.keySet().removeAll(optional);
        for (String field : givenFields.keySet()) {
            errors.add(Validator.Error.warning("page [%s] contains unknown configuration property [%s] for [%s] source", pageName, field, sourceType));
            config.remove(field);
        }
        return Validator.Result.ofBoth(config, errors);
    }
}

