/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.rest.api.model.NewSubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionConfigurationEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionConfigurationEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.EntrypointConnectorPluginService;
import io.gravitee.rest.api.service.v4.exception.SubscriptionEntrypointIdMissingException;
import io.gravitee.rest.api.service.v4.validation.SubscriptionValidationService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionValidationServiceImpl
extends TransactionalService
implements SubscriptionValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriptionValidationServiceImpl.class);
    private final EntrypointConnectorPluginService entrypointService;

    @Override
    public void validateAndSanitize(GenericPlanEntity genericPlanEntity, NewSubscriptionEntity subscription) {
        subscription.setConfiguration(this.validateAndSanitizeSubscriptionConfiguration(genericPlanEntity, subscription.getConfiguration()));
    }

    @Override
    public void validateAndSanitize(GenericPlanEntity genericPlanEntity, UpdateSubscriptionEntity subscription) {
        subscription.setConfiguration(this.validateAndSanitizeSubscriptionConfiguration(genericPlanEntity, subscription.getConfiguration()));
    }

    @Override
    public void validateAndSanitize(GenericPlanEntity genericPlanEntity, UpdateSubscriptionConfigurationEntity subscriptionConfiguration) {
        subscriptionConfiguration.setConfiguration(this.validateAndSanitizeSubscriptionConfiguration(genericPlanEntity, subscriptionConfiguration.getConfiguration()));
    }

    private SubscriptionConfigurationEntity validateAndSanitizeSubscriptionConfiguration(GenericPlanEntity genericPlanEntity, SubscriptionConfigurationEntity configuration) {
        if (genericPlanEntity.getPlanMode() != null && genericPlanEntity.getPlanMode() == PlanMode.PUSH) {
            if (configuration == null || configuration.getEntrypointId() == null || configuration.getEntrypointId().isEmpty()) {
                throw new SubscriptionEntrypointIdMissingException();
            }
            configuration.setEntrypointConfiguration(this.entrypointService.validateEntrypointSubscriptionConfiguration(configuration.getEntrypointId(), configuration.getEntrypointConfiguration()));
        }
        return configuration;
    }

    @Generated
    public SubscriptionValidationServiceImpl(EntrypointConnectorPluginService entrypointService) {
        this.entrypointService = entrypointService;
    }
}

