/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.DefaultRoleEntityDefinition;
import io.gravitee.rest.api.service.common.ExecutionContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class DefaultRolesUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRolesUpgrader.class);
    private final RoleService roleService;
    private final OrganizationRepository organizationRepository;

    @Autowired
    public DefaultRolesUpgrader(RoleService roleService, @Lazy OrganizationRepository organizationRepository) {
        this.roleService = roleService;
        this.organizationRepository = organizationRepository;
    }

    public boolean upgrade() {
        try {
            this.organizationRepository.findAll().forEach(organization -> {
                ExecutionContext executionContext = new ExecutionContext((Organization)organization);
                this.initializeDefaultRoles(executionContext);
                this.roleService.createOrUpdateSystemRoles(executionContext, executionContext.getOrganizationId());
            });
        }
        catch (Exception e) {
            log.error("Error applying upgrader", (Throwable)e);
            return false;
        }
        return true;
    }

    private void initializeDefaultRoles(ExecutionContext executionContext) {
        if (this.roleService.findAllByOrganization(executionContext.getOrganizationId()).isEmpty()) {
            this.roleService.initialize(executionContext, executionContext.getOrganizationId());
        } else if (this.shouldCreateApiReviewerRole(executionContext)) {
            log.info("     - <API> REVIEWER");
            this.roleService.create(executionContext, DefaultRoleEntityDefinition.ROLE_API_REVIEWER);
        }
    }

    private boolean shouldCreateApiReviewerRole(ExecutionContext executionContext) {
        return this.roleService.findByScopeAndName(RoleScope.API, DefaultRoleEntityDefinition.ROLE_API_REVIEWER.getName(), executionContext.getOrganizationId()).isEmpty();
    }

    public int getOrder() {
        return 120;
    }
}

