/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.builder;

import io.gravitee.common.util.EnvironmentUtils;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class JerseyClientBuilder {
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final Pattern WILCARD_PATTERN = Pattern.compile("\\*\\.");

    public static ClientBuilder newBuilder(Environment environment) {
        ClientBuilder builder = ClientBuilder.newBuilder();
        JerseyClientBuilder.initHttpProxy(builder, environment);
        int timeout = (Integer)environment.getProperty("httpClient.timeout", Integer.class, (Object)10000);
        builder.connectTimeout((long)timeout, TimeUnit.MILLISECONDS);
        builder.readTimeout((long)timeout, TimeUnit.MILLISECONDS);
        return builder;
    }

    private static void initHttpProxy(ClientBuilder builder, Environment environment) {
        Proxy httpProxy = JerseyClientBuilder.buildProxy(environment, HTTP_SCHEME);
        String httpProxyAuth = JerseyClientBuilder.buildProxyAuth(environment, HTTP_SCHEME);
        Proxy httpsProxy = JerseyClientBuilder.buildProxy(environment, HTTPS_SCHEME);
        String httpsProxyAuth = JerseyClientBuilder.buildProxyAuth(environment, HTTPS_SCHEME);
        List proxyExcludeHosts = EnvironmentUtils.getPropertiesStartingWith((ConfigurableEnvironment)((ConfigurableEnvironment)environment), (String)"httpClient.proxy.exclude-hosts").values().stream().map(String::valueOf).collect(Collectors.toList());
        ClientConfig clientConfig = new ClientConfig().connectorProvider((ConnectorProvider)new HttpUrlConnectorProvider().connectionFactory(url -> {
            HttpURLConnection uc;
            String host = url.getHost();
            boolean excluded = proxyExcludeHosts.stream().anyMatch(excludedHost -> {
                if (excludedHost.startsWith("*.")) {
                    return host.endsWith(WILCARD_PATTERN.matcher((CharSequence)excludedHost).replaceFirst(""));
                }
                return host.equals(excludedHost);
            });
            if (excluded || httpProxy == null && httpsProxy == null) {
                return (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            }
            if (url.getProtocol().equals(HTTPS_SCHEME) && httpsProxy != null) {
                uc = (HttpURLConnection)url.openConnection(httpsProxy);
                if (JerseyClientBuilder.useSockProxy(environment, HTTPS_SCHEME)) {
                    JerseyClientBuilder.buildSockProxyAuth(environment, HTTPS_SCHEME);
                } else if (httpsProxyAuth != null) {
                    uc.setRequestProperty("Proxy-Authorization", "Basic " + httpsProxyAuth);
                }
            } else if (url.getProtocol().equals(HTTP_SCHEME) && httpProxy != null) {
                uc = (HttpURLConnection)url.openConnection(httpProxy);
                if (JerseyClientBuilder.useSockProxy(environment, HTTP_SCHEME)) {
                    JerseyClientBuilder.buildSockProxyAuth(environment, HTTP_SCHEME);
                } else if (httpProxyAuth != null) {
                    uc.setRequestProperty("Proxy-Authorization", "Basic " + httpProxyAuth);
                }
            } else {
                uc = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            }
            return uc;
        }));
        builder.withConfig((Configuration)clientConfig);
    }

    private static boolean useSockProxy(Environment environment, String type) {
        return ((String)environment.getProperty("httpClient.proxy.type", String.class, (Object)"HTTP")).startsWith("SOCK");
    }

    private static Proxy buildProxy(Environment environment, String type) {
        String proxyHost = (String)environment.getProperty("httpClient.proxy." + type + ".host", String.class);
        Integer proxyPort = (Integer)environment.getProperty("httpClient.proxy." + type + ".port", Integer.class, (Object)3124);
        if (proxyHost != null) {
            Proxy.Type pType = Proxy.Type.HTTP;
            if (JerseyClientBuilder.useSockProxy(environment, type)) {
                pType = Proxy.Type.SOCKS;
            }
            return new Proxy(pType, new InetSocketAddress(proxyHost, (int)proxyPort));
        }
        return null;
    }

    private static String buildProxyAuth(Environment environment, String type) {
        String proxyHttpUsername = (String)environment.getProperty("httpClient.proxy." + type + ".username", String.class);
        String proxyHttpPassword = (String)environment.getProperty("httpClient.proxy." + type + ".password", String.class);
        return proxyHttpUsername != null ? new String(Base64.getEncoder().encode((proxyHttpUsername + ":" + proxyHttpPassword).getBytes())) : null;
    }

    private static void buildSockProxyAuth(Environment environment, String type) {
        final String proxyHttpUsername = (String)environment.getProperty("httpClient.proxy." + type + ".username", String.class);
        final String proxyHttpPassword = (String)environment.getProperty("httpClient.proxy." + type + ".password", String.class);
        if (proxyHttpUsername != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyHttpUsername, proxyHttpPassword != null ? proxyHttpPassword.toCharArray() : new char[]{});
                }
            });
        }
    }
}

