/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.workflow;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.workflow.model.Workflow;
import io.gravitee.apim.core.workflow.query_service.WorkflowQueryService;
import io.gravitee.apim.infra.adapter.WorkflowAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.WorkflowRepository;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class WorkflowQueryServiceImpl
implements WorkflowQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowQueryServiceImpl.class);
    private final WorkflowRepository workflowRepository;

    public WorkflowQueryServiceImpl(@Lazy WorkflowRepository workflowRepository) {
        this.workflowRepository = workflowRepository;
    }

    @Override
    public List<Workflow> findAllByApiIdAndType(String apiId, Workflow.Type type) {
        try {
            return WorkflowAdapter.INSTANCE.toEntities(this.workflowRepository.findByReferenceAndType("API", apiId, type.name()));
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurred while finding [API] workflows with apiId [%s] and status [%s]", apiId, type.name()), e);
        }
    }
}

