/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.api;

import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiExportDomainService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.NewApiMetadata;
import io.gravitee.apim.core.api.model.import_definition.ApiDescriptor;
import io.gravitee.apim.core.api.model.import_definition.ApiMember;
import io.gravitee.apim.core.api.model.import_definition.GraviteeDefinition;
import io.gravitee.apim.core.api.model.import_definition.PageExport;
import io.gravitee.apim.core.api.model.import_definition.PlanDescriptor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.Excludable;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.media.model.Media;
import io.gravitee.apim.core.media.query_service.MediaQueryService;
import io.gravitee.apim.core.membership.crud_service.MembershipCrudService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.membership.query_service.RoleQueryService;
import io.gravitee.apim.core.metadata.crud_service.MetadataCrudService;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.workflow.crud_service.WorkflowCrudService;
import io.gravitee.apim.core.workflow.model.Workflow;
import io.gravitee.apim.infra.adapter.GraviteeDefinitionAdapter;
import io.gravitee.apim.infra.adapter.MemberAdapter;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ApiDefinitionVersionNotSupportedException;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ApiExportDomainServiceImpl
implements ApiExportDomainService {
    private static final GraviteeDefinitionAdapter DEFINITION_ADAPTER = GraviteeDefinitionAdapter.INSTANCE;
    private final PermissionService permissionService;
    private final MediaQueryService mediaService;
    private final WorkflowCrudService workflowCrudService;
    private final MembershipCrudService membershipCrudService;
    private final UserCrudService userCrudService;
    private final RoleQueryService roleQueryService;
    private final MetadataCrudService metadataCrudService;
    private final PageQueryService pageQueryService;
    private final ApiCrudService apiCrudService;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final PlanCrudService planCrudService;
    private final IntegrationCrudService integrationCrudService;
    private final FlowCrudService flowCrudService;

    @Override
    public GraviteeDefinition export(String apiId, AuditInfo auditInfo, Collection<Excludable> excluded) {
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        PrimaryOwnerEntity apiPrimaryOwner = this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(auditInfo.organizationId(), apiId);
        Api api1 = this.apiCrudService.findById(apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
        Set<ApiMember> members = !excluded.contains((Object)Excludable.MEMBERS) ? this.exportApiMembers(apiId) : null;
        Collection<NewApiMetadata> metadata = !excluded.contains((Object)Excludable.METADATA) ? this.exportApiMetadata(executionContext, apiId, executionContext.getEnvironmentId()) : null;
        List<PageExport> pages = !excluded.contains((Object)Excludable.PAGES_MEDIA) ? this.exportApiPages(apiId) : null;
        List<Media> medias = !excluded.contains((Object)Excludable.PAGES_MEDIA) ? this.exportApiMedia(apiId) : null;
        WorkflowState workflowState = CollectionUtils.stream(this.workflowCrudService.findByApiId(apiId)).map(Workflow::getState).map(Enum::name).map(WorkflowState::valueOf).findFirst().orElse(null);
        Set<String> groups = !excluded.contains((Object)Excludable.GROUPS) ? api1.getGroups() : null;
        return switch (this.apiType(api1).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Function<Plan, PlanDescriptor.V2> mapPlanV2 = DEFINITION_ADAPTER::mapPlanV2;
                Collection<PlanDescriptor.V2> plans = this.mapPlan(apiId, mapPlanV2.andThen(this::planWithFlowV2), excluded);
                List<io.gravitee.definition.model.flow.Flow> flows = this.flowCrudService.getApiV2Flows(apiId);
                ApiDescriptor.ApiDescriptorV2 api = DEFINITION_ADAPTER.mapV2(api1, apiPrimaryOwner, workflowState, groups, metadata, flows);
                yield GraviteeDefinition.from(api, members, metadata, pages, plans, medias, api1.getPicture(), api1.getBackground());
            }
            case 1 -> {
                Function<Plan, PlanDescriptor.V4> mapPlanV4 = DEFINITION_ADAPTER::mapPlanV4;
                Collection<PlanDescriptor.V4> plans = this.mapPlan(apiId, mapPlanV4.andThen(this::planWithFlowV4), excluded);
                List<Flow> flows = this.flowCrudService.getApiV4Flows(apiId);
                ApiDescriptor.ApiDescriptorV4 api = DEFINITION_ADAPTER.mapV4(api1, apiPrimaryOwner, workflowState, groups, metadata, flows);
                yield GraviteeDefinition.from(api, members, metadata, pages, plans, medias, api1.getPicture(), api1.getBackground());
            }
            case 2 -> {
                Function<Plan, PlanDescriptor.Native> mapPlanNative = DEFINITION_ADAPTER::mapPlanNative;
                Collection<PlanDescriptor.Native> plans = this.mapPlan(apiId, mapPlanNative.andThen(this::planWithFlowNative), excluded);
                List<NativeFlow> flows = this.flowCrudService.getNativeApiFlows(apiId);
                ApiDescriptor.Native api = DEFINITION_ADAPTER.mapNative(api1, apiPrimaryOwner, workflowState, groups, metadata, flows);
                yield GraviteeDefinition.from(api, members, metadata, pages, plans, medias, api1.getPicture(), api1.getBackground());
            }
            case 3 -> {
                OriginContext.Integration ori;
                Collection<PlanDescriptor.Federated> plans = this.mapPlan(apiId, DEFINITION_ADAPTER::mapPlanFederated, excluded);
                OriginContext var16_28 = api1.getOriginContext();
                Integration integ = var16_28 instanceof OriginContext.Integration && (ori = (OriginContext.Integration)var16_28).integrationName() == null ? (Integration)this.integrationCrudService.findById(ori.integrationId()).orElse(null) : null;
                ApiDescriptor.Federated api = DEFINITION_ADAPTER.mapFederated(api1, apiPrimaryOwner, workflowState, groups, metadata, integ);
                yield GraviteeDefinition.from(api, members, metadata, pages, plans, medias, api1.getPicture(), api1.getBackground());
            }
        };
    }

    private Set<ApiMember> exportApiMembers(String apiId) {
        if (!this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_MEMBER, apiId, RolePermissionAction.READ)) {
            return null;
        }
        List<Membership> members = CollectionUtils.stream(this.membershipCrudService.findByApiId(apiId)).filter(memberEntity -> memberEntity.getMemberType() == Membership.Type.USER).toList();
        List<String> userIds = members.stream().map(Membership::getMemberId).distinct().toList();
        Map userByIds = CollectionUtils.stream(this.userCrudService.findBaseUsersByIds(userIds)).collect(Collectors.toMap(BaseUserEntity::getId, Function.identity()));
        Map roles = CollectionUtils.stream(this.roleQueryService.findByIds(members.stream().map(Membership::getRoleId).collect(Collectors.toSet()))).collect(Collectors.toMap(Role::getId, Function.identity()));
        return members.stream().map(m -> MemberAdapter.INSTANCE.toApiMember((Membership)m, (BaseUserEntity)userByIds.get(m.getMemberId()), (Role)roles.get(m.getRoleId()))).collect(Collectors.toSet());
    }

    private Collection<NewApiMetadata> exportApiMetadata(ExecutionContext executionContext, String apiId, String envId) {
        if (!this.permissionService.hasPermission(executionContext, RolePermission.API_METADATA, apiId, RolePermissionAction.READ)) {
            return null;
        }
        return Stream.concat(CollectionUtils.stream(this.metadataCrudService.findByEnvId(envId)), CollectionUtils.stream(this.metadataCrudService.findByApiId(apiId))).map(DEFINITION_ADAPTER::mapMetadata).collect(Collectors.toMap(NewApiMetadata::getKey, Function.identity(), (envMetadata, apiMetadata) -> {
            apiMetadata.setDefaultValue(envMetadata.getValue());
            return apiMetadata;
        })).values();
    }

    private List<PageExport> exportApiPages(String apiId) {
        return this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_DOCUMENTATION, apiId, RolePermissionAction.READ) ? DEFINITION_ADAPTER.mapPage(this.pageQueryService.searchByApiId(apiId)) : null;
    }

    private List<Media> exportApiMedia(String apiId) {
        return this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_DOCUMENTATION, apiId, RolePermissionAction.READ) ? this.mediaService.findAllByApiId(apiId) : null;
    }

    private ValidatedType apiType(Api api1) {
        if (api1.getDefinitionVersion() == DefinitionVersion.V4 && api1.getApiDefinitionHttpV4() != null && api1.getType() != ApiType.NATIVE) {
            return ValidatedType.V4;
        }
        if (api1.getDefinitionVersion() == DefinitionVersion.V4 && api1.getApiDefinitionNativeV4() != null && api1.getType() == ApiType.NATIVE) {
            return ValidatedType.V4_NATIVE;
        }
        if (api1.getDefinitionVersion() == DefinitionVersion.FEDERATED && api1.getFederatedApiDefinition() != null) {
            return ValidatedType.FEDERATED;
        }
        if (api1.getDefinitionVersion() == DefinitionVersion.V2 && api1.getApiDefinition() != null) {
            return ValidatedType.V2;
        }
        throw new ApiDefinitionVersionNotSupportedException(api1.getDefinitionVersion() != null ? api1.getDefinitionVersion().getLabel() : null);
    }

    @Nullable
    private <T> Collection<T> mapPlan(String apiId, Function<Plan, T> mapper, Collection<Excludable> excluded) {
        return excluded.contains((Object)Excludable.PLANS) ? null : CollectionUtils.stream(this.planCrudService.findByApiId(apiId)).filter(Predicate.not(Plan::isClosed)).map(mapper).toList();
    }

    private PlanDescriptor.V4 planWithFlowV4(PlanDescriptor.V4 planV4) {
        return planV4.withFlow(this.flowCrudService.getPlanV4Flows(planV4.id()));
    }

    private PlanDescriptor.V2 planWithFlowV2(PlanDescriptor.V2 planV2) {
        return planV2.withFlow(this.flowCrudService.getPlanV2Flows(planV2.id()));
    }

    private PlanDescriptor.Native planWithFlowNative(PlanDescriptor.Native planNative) {
        return planNative.withFlow(this.flowCrudService.getNativePlanFlows(planNative.id()));
    }

    @Generated
    public ApiExportDomainServiceImpl(PermissionService permissionService, MediaQueryService mediaService, WorkflowCrudService workflowCrudService, MembershipCrudService membershipCrudService, UserCrudService userCrudService, RoleQueryService roleQueryService, MetadataCrudService metadataCrudService, PageQueryService pageQueryService, ApiCrudService apiCrudService, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, PlanCrudService planCrudService, IntegrationCrudService integrationCrudService, FlowCrudService flowCrudService) {
        this.permissionService = permissionService;
        this.mediaService = mediaService;
        this.workflowCrudService = workflowCrudService;
        this.membershipCrudService = membershipCrudService;
        this.userCrudService = userCrudService;
        this.roleQueryService = roleQueryService;
        this.metadataCrudService = metadataCrudService;
        this.pageQueryService = pageQueryService;
        this.apiCrudService = apiCrudService;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.planCrudService = planCrudService;
        this.integrationCrudService = integrationCrudService;
        this.flowCrudService = flowCrudService;
    }

    private static enum ValidatedType {
        V2,
        V4,
        V4_NATIVE,
        FEDERATED;

    }
}

