/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.policy.domain_service.PolicyValidationDomainService;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupCrudService;
import io.gravitee.apim.core.shared_policy_group.exception.SharedPolicyGroupDuplicateCrossIdException;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.definition.model.v4.flow.step.Step;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import java.util.ArrayList;
import lombok.Generated;

@DomainService
public class ValidateUpdateSharedPolicyGroupDomainService
implements Validator<Input> {
    private final SharedPolicyGroupCrudService sharedPolicyGroupCrudService;
    private final PolicyValidationDomainService policyValidationDomainService;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        SharedPolicyGroup.SharedPolicyGroupBuilder sanitizedBuilder = input.sharedPolicyGroup().toBuilder();
        try {
            this.validate(input.sharedPolicyGroup, input.auditInfo.environmentId());
        }
        catch (Exception e) {
            errors.add(Validator.Error.severe(e.getMessage(), new Object[0]));
        }
        return Validator.Result.ofBoth(new Input(input.auditInfo(), sanitizedBuilder.build()), errors);
    }

    public void validate(SharedPolicyGroup sharedPolicyGroup, String environmentId) {
        this.validateUpdateSharedPolicyGroup(sharedPolicyGroup, environmentId);
    }

    private void validateUpdateSharedPolicyGroup(SharedPolicyGroup sharedPolicyGroup, String environmentId) {
        if (!sharedPolicyGroup.hasName()) {
            throw new InvalidDataException("Name is required.");
        }
        this.sharedPolicyGroupCrudService.findByEnvironmentIdAndCrossId(environmentId, sharedPolicyGroup.getCrossId()).filter(spg -> !spg.getId().equals(sharedPolicyGroup.getId())).ifPresent(spg -> {
            throw new SharedPolicyGroupDuplicateCrossIdException(sharedPolicyGroup.getCrossId(), environmentId);
        });
        if (sharedPolicyGroup.getSteps() != null) {
            sharedPolicyGroup.getSteps().stream().filter(Step::isEnabled).forEach(step -> step.setConfiguration(this.policyValidationDomainService.validateAndSanitizeConfiguration(step.getPolicy(), step.getConfiguration())));
            this.policyValidationDomainService.validatePoliciesFlowPhase(sharedPolicyGroup.getSteps().stream().map(Step::getPolicy).toList(), sharedPolicyGroup.getApiType(), sharedPolicyGroup.getPhase());
        }
    }

    @Generated
    public ValidateUpdateSharedPolicyGroupDomainService(SharedPolicyGroupCrudService sharedPolicyGroupCrudService, PolicyValidationDomainService policyValidationDomainService) {
        this.sharedPolicyGroupCrudService = sharedPolicyGroupCrudService;
        this.policyValidationDomainService = policyValidationDomainService;
    }

    public record Input(AuditInfo auditInfo, SharedPolicyGroup sharedPolicyGroup) implements Validator.Input
    {
    }
}

