/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.notification.model.config;

import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.HookScope;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class NotificationConfig {
    private Type type;
    private String id;
    private String name;
    private String referenceType;
    private String referenceId;
    private String notifier;
    private String config;
    private List<String> hooks;
    private boolean useSystemProxy;
    private ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;

    public static NotificationConfig defaultMailNotificationConfigFor(String apiId) {
        ZonedDateTime now = TimeProvider.now();
        return NotificationConfig.builder().type(Type.GENERIC).id(UuidString.generateRandom()).name("Default Mail Notifications").referenceType(HookScope.API.name()).referenceId(apiId).notifier("default-email").config("${(api.primaryOwner.email)!''}").hooks(Arrays.stream(ApiHook.values()).map(Enum::name).sorted().toList()).createdAt(now).updatedAt(now).build();
    }

    @Generated
    NotificationConfig(Type type, String id, String name, String referenceType, String referenceId, String notifier, String config, List<String> hooks, boolean useSystemProxy, ZonedDateTime createdAt, ZonedDateTime updatedAt) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.referenceType = referenceType;
        this.referenceId = referenceId;
        this.notifier = notifier;
        this.config = config;
        this.hooks = hooks;
        this.useSystemProxy = useSystemProxy;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @Generated
    public static NotificationConfigBuilder builder() {
        return new NotificationConfigBuilder();
    }

    @Generated
    public NotificationConfigBuilder toBuilder() {
        return new NotificationConfigBuilder().type(this.type).id(this.id).name(this.name).referenceType(this.referenceType).referenceId(this.referenceId).notifier(this.notifier).config(this.config).hooks(this.hooks).useSystemProxy(this.useSystemProxy).createdAt(this.createdAt).updatedAt(this.updatedAt);
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public String getNotifier() {
        return this.notifier;
    }

    @Generated
    public String getConfig() {
        return this.config;
    }

    @Generated
    public List<String> getHooks() {
        return this.hooks;
    }

    @Generated
    public boolean isUseSystemProxy() {
        return this.useSystemProxy;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public void setType(Type type) {
        this.type = type;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setNotifier(String notifier) {
        this.notifier = notifier;
    }

    @Generated
    public void setConfig(String config) {
        this.config = config;
    }

    @Generated
    public void setHooks(List<String> hooks) {
        this.hooks = hooks;
    }

    @Generated
    public void setUseSystemProxy(boolean useSystemProxy) {
        this.useSystemProxy = useSystemProxy;
    }

    @Generated
    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(ZonedDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationConfig)) {
            return false;
        }
        NotificationConfig other = (NotificationConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseSystemProxy() != other.isUseSystemProxy()) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$referenceType = this.getReferenceType();
        String other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !this$referenceType.equals(other$referenceType)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$notifier = this.getNotifier();
        String other$notifier = other.getNotifier();
        if (this$notifier == null ? other$notifier != null : !this$notifier.equals(other$notifier)) {
            return false;
        }
        String this$config = this.getConfig();
        String other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        List<String> this$hooks = this.getHooks();
        List<String> other$hooks = other.getHooks();
        if (this$hooks == null ? other$hooks != null : !((Object)this$hooks).equals(other$hooks)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NotificationConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseSystemProxy() ? 79 : 97);
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : $referenceType.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $notifier = this.getNotifier();
        result = result * 59 + ($notifier == null ? 43 : $notifier.hashCode());
        String $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        List<String> $hooks = this.getHooks();
        result = result * 59 + ($hooks == null ? 43 : ((Object)$hooks).hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NotificationConfig(type=" + String.valueOf((Object)this.getType()) + ", id=" + this.getId() + ", name=" + this.getName() + ", referenceType=" + this.getReferenceType() + ", referenceId=" + this.getReferenceId() + ", notifier=" + this.getNotifier() + ", config=" + this.getConfig() + ", hooks=" + String.valueOf(this.getHooks()) + ", useSystemProxy=" + this.isUseSystemProxy() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    @Generated
    public static class NotificationConfigBuilder {
        @Generated
        private Type type;
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String referenceType;
        @Generated
        private String referenceId;
        @Generated
        private String notifier;
        @Generated
        private String config;
        @Generated
        private List<String> hooks;
        @Generated
        private boolean useSystemProxy;
        @Generated
        private ZonedDateTime createdAt;
        @Generated
        private ZonedDateTime updatedAt;

        @Generated
        NotificationConfigBuilder() {
        }

        @Generated
        public NotificationConfigBuilder type(Type type) {
            this.type = type;
            return this;
        }

        @Generated
        public NotificationConfigBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public NotificationConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public NotificationConfigBuilder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Generated
        public NotificationConfigBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Generated
        public NotificationConfigBuilder notifier(String notifier) {
            this.notifier = notifier;
            return this;
        }

        @Generated
        public NotificationConfigBuilder config(String config) {
            this.config = config;
            return this;
        }

        @Generated
        public NotificationConfigBuilder hooks(List<String> hooks) {
            this.hooks = hooks;
            return this;
        }

        @Generated
        public NotificationConfigBuilder useSystemProxy(boolean useSystemProxy) {
            this.useSystemProxy = useSystemProxy;
            return this;
        }

        @Generated
        public NotificationConfigBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public NotificationConfigBuilder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public NotificationConfig build() {
            return new NotificationConfig(this.type, this.id, this.name, this.referenceType, this.referenceId, this.notifier, this.config, this.hooks, this.useSystemProxy, this.createdAt, this.updatedAt);
        }

        @Generated
        public String toString() {
            return "NotificationConfig.NotificationConfigBuilder(type=" + String.valueOf((Object)this.type) + ", id=" + this.id + ", name=" + this.name + ", referenceType=" + this.referenceType + ", referenceId=" + this.referenceId + ", notifier=" + this.notifier + ", config=" + this.config + ", hooks=" + String.valueOf(this.hooks) + ", useSystemProxy=" + this.useSystemProxy + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ")";
        }
    }

    public static enum Type {
        PORTAL,
        GENERIC;

    }
}

