/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model;

import io.gravitee.apim.core.api.model.property.DynamicApiProperties;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.federation.FederatedApi;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.listener.AbstractListener;
import io.gravitee.definition.model.v4.listener.entrypoint.AbstractEntrypoint;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.rest.api.model.context.OriginContext;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class Api {
    private String id;
    private String environmentId;
    private String crossId;
    private String name;
    private String description;
    private String version;
    private OriginContext originContext;
    private DefinitionVersion definitionVersion;
    private io.gravitee.definition.model.v4.Api apiDefinitionHttpV4;
    private NativeApi apiDefinitionNativeV4;
    private io.gravitee.definition.model.Api apiDefinition;
    private FederatedApi federatedApiDefinition;
    private ApiType type;
    private ZonedDateTime deployedAt;
    private ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;
    private Visibility visibility;
    private LifecycleState lifecycleState;
    private String picture;
    private Set<String> groups;
    private Set<String> categories;
    private List<String> labels;
    private boolean disableMembershipNotifications;
    private ApiLifecycleState apiLifecycleState;
    private String background;

    public boolean isDeprecated() {
        return this.apiLifecycleState == ApiLifecycleState.DEPRECATED;
    }

    public Set<String> getTags() {
        return switch (this.definitionVersion) {
            default -> throw new MatchException(null, null);
            case DefinitionVersion.V4 -> {
                if (this.type == ApiType.NATIVE) {
                    yield this.apiDefinitionNativeV4.getTags();
                }
                yield this.apiDefinitionHttpV4.getTags();
            }
            case DefinitionVersion.V1, DefinitionVersion.V2 -> this.apiDefinition.getTags();
            case DefinitionVersion.FEDERATED -> Collections.emptySet();
        };
    }

    public Api setTags(Set<String> tags) {
        if (this.apiDefinitionHttpV4 != null) {
            this.apiDefinitionHttpV4.setTags(tags);
        }
        if (this.apiDefinition != null) {
            this.apiDefinition.setTags(tags);
        }
        if (this.apiDefinitionNativeV4 != null) {
            this.apiDefinitionNativeV4.setTags(tags);
        }
        return this;
    }

    public Api setId(String id) {
        this.id = id;
        if (this.apiDefinitionHttpV4 != null) {
            this.apiDefinitionHttpV4.setId(id);
        }
        if (this.apiDefinition != null) {
            this.apiDefinition.setId(id);
        }
        if (this.federatedApiDefinition != null) {
            this.federatedApiDefinition.setId(id);
        }
        return this;
    }

    public Api setApiDefinitionHttpV4(io.gravitee.definition.model.v4.Api apiDefinitionHttpV4) {
        this.apiDefinitionHttpV4 = apiDefinitionHttpV4;
        this.definitionVersion = apiDefinitionHttpV4.getDefinitionVersion();
        return this;
    }

    public Api setApiDefinition(io.gravitee.definition.model.Api apiDefinition) {
        this.apiDefinition = apiDefinition;
        this.definitionVersion = apiDefinition.getDefinitionVersion();
        return this;
    }

    public Api setFederatedApiDefinition(FederatedApi federatedApiDefinition) {
        this.federatedApiDefinition = federatedApiDefinition;
        this.definitionVersion = federatedApiDefinition.getDefinitionVersion();
        return this;
    }

    public Api setPlans(List<Plan> plans) {
        switch (this.definitionVersion) {
            case V4: {
                if (this.type == ApiType.NATIVE) {
                    this.apiDefinitionNativeV4.setPlans(plans.stream().map(Plan::getPlanDefinitionNativeV4).toList());
                    break;
                }
                this.apiDefinitionHttpV4.setPlans(plans.stream().map(Plan::getPlanDefinitionHttpV4).toList());
                break;
            }
            case V1: 
            case V2: {
                this.apiDefinition.setPlans(plans.stream().map(Plan::getPlanDefinitionV2).collect(Collectors.toList()));
                break;
            }
        }
        return this;
    }

    public List<? extends AbstractListener<? extends AbstractEntrypoint>> getApiListeners() {
        if (this.definitionVersion != DefinitionVersion.V4) {
            return Collections.emptyList();
        }
        if (this.type == ApiType.NATIVE) {
            return Optional.ofNullable(this.apiDefinitionNativeV4.getListeners()).orElse(Collections.emptyList());
        }
        return Optional.ofNullable(this.apiDefinitionHttpV4.getListeners()).orElse(Collections.emptyList());
    }

    public boolean isNative() {
        return this.type == ApiType.NATIVE;
    }

    public boolean updateDynamicProperties(List<Property> dynamicProperties) {
        if (this.definitionVersion != DefinitionVersion.V4) {
            return false;
        }
        DynamicApiProperties apiProperties = new DynamicApiProperties(this.apiDefinitionHttpV4.getProperties());
        DynamicApiProperties.DynamicPropertiesResult properties = apiProperties.updateDynamicProperties(dynamicProperties);
        this.getApiDefinitionHttpV4().setProperties(properties.orderedProperties());
        this.setUpdatedAt(TimeProvider.now());
        return properties.needToUpdate();
    }

    public boolean belongsToEnvironment(String envId) {
        return this.environmentId != null && this.environmentId.equals(envId);
    }

    public Api rollbackTo(io.gravitee.definition.model.v4.Api source) {
        io.gravitee.definition.model.v4.Api currentDefinition = this.getApiDefinitionHttpV4();
        return ((Api)((ApiBuilder)((ApiBuilder)((ApiBuilder)this.toBuilder().name(source.getName())).version(source.getApiVersion())).apiDefinitionHttpV4(((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)currentDefinition.toBuilder().tags(source.getTags())).listeners(source.getListeners()).endpointGroups(source.getEndpointGroups()).analytics(source.getAnalytics()).properties(source.getProperties())).resources(source.getResources())).failover(source.getFailover()).flowExecution(source.getFlowExecution()).flows(source.getFlows()).responseTemplates(source.getResponseTemplates()).services(source.getServices()).plans(null).build())).build()).setTags(source.getTags());
    }

    @Generated
    private static OriginContext $default$originContext() {
        return new OriginContext.Management();
    }

    @Generated
    private static Visibility $default$visibility() {
        return Visibility.PRIVATE;
    }

    @Generated
    private static ApiLifecycleState $default$apiLifecycleState() {
        return ApiLifecycleState.CREATED;
    }

    @Generated
    protected Api(ApiBuilder<?, ?> b) {
        this.id = b.id;
        this.environmentId = b.environmentId;
        this.crossId = b.crossId;
        this.name = b.name;
        this.description = b.description;
        this.version = b.version;
        this.originContext = b.originContext$set ? b.originContext$value : Api.$default$originContext();
        this.definitionVersion = b.definitionVersion;
        this.apiDefinitionHttpV4 = b.apiDefinitionHttpV4;
        this.apiDefinitionNativeV4 = b.apiDefinitionNativeV4;
        this.apiDefinition = b.apiDefinition;
        this.federatedApiDefinition = b.federatedApiDefinition;
        this.type = b.type;
        this.deployedAt = b.deployedAt;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.visibility = b.visibility$set ? b.visibility$value : Api.$default$visibility();
        this.lifecycleState = b.lifecycleState;
        this.picture = b.picture;
        this.groups = b.groups;
        this.categories = b.categories;
        this.labels = b.labels;
        this.disableMembershipNotifications = b.disableMembershipNotifications;
        this.apiLifecycleState = b.apiLifecycleState$set ? b.apiLifecycleState$value : Api.$default$apiLifecycleState();
        this.background = b.background;
    }

    @Generated
    public static ApiBuilder<?, ?> builder() {
        return new ApiBuilderImpl();
    }

    @Generated
    public ApiBuilder<?, ?> toBuilder() {
        return new ApiBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public OriginContext getOriginContext() {
        return this.originContext;
    }

    @Generated
    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    @Generated
    public io.gravitee.definition.model.v4.Api getApiDefinitionHttpV4() {
        return this.apiDefinitionHttpV4;
    }

    @Generated
    public NativeApi getApiDefinitionNativeV4() {
        return this.apiDefinitionNativeV4;
    }

    @Generated
    public io.gravitee.definition.model.Api getApiDefinition() {
        return this.apiDefinition;
    }

    @Generated
    public FederatedApi getFederatedApiDefinition() {
        return this.federatedApiDefinition;
    }

    @Generated
    public ApiType getType() {
        return this.type;
    }

    @Generated
    public ZonedDateTime getDeployedAt() {
        return this.deployedAt;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Generated
    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public Set<String> getGroups() {
        return this.groups;
    }

    @Generated
    public Set<String> getCategories() {
        return this.categories;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    @Generated
    public ApiLifecycleState getApiLifecycleState() {
        return this.apiLifecycleState;
    }

    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setOriginContext(OriginContext originContext) {
        this.originContext = originContext;
    }

    @Generated
    public void setDefinitionVersion(DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    @Generated
    public void setApiDefinitionNativeV4(NativeApi apiDefinitionNativeV4) {
        this.apiDefinitionNativeV4 = apiDefinitionNativeV4;
    }

    @Generated
    public void setType(ApiType type) {
        this.type = type;
    }

    @Generated
    public void setDeployedAt(ZonedDateTime deployedAt) {
        this.deployedAt = deployedAt;
    }

    @Generated
    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(ZonedDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setLifecycleState(LifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Generated
    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @Generated
    public void setApiLifecycleState(ApiLifecycleState apiLifecycleState) {
        this.apiLifecycleState = apiLifecycleState;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Api)) {
            return false;
        }
        Api other = (Api)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisableMembershipNotifications() != other.isDisableMembershipNotifications()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId)) {
            return false;
        }
        String this$crossId = this.getCrossId();
        String other$crossId = other.getCrossId();
        if (this$crossId == null ? other$crossId != null : !this$crossId.equals(other$crossId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        OriginContext this$originContext = this.getOriginContext();
        OriginContext other$originContext = other.getOriginContext();
        if (this$originContext == null ? other$originContext != null : !this$originContext.equals(other$originContext)) {
            return false;
        }
        DefinitionVersion this$definitionVersion = this.getDefinitionVersion();
        DefinitionVersion other$definitionVersion = other.getDefinitionVersion();
        if (this$definitionVersion == null ? other$definitionVersion != null : !this$definitionVersion.equals(other$definitionVersion)) {
            return false;
        }
        io.gravitee.definition.model.v4.Api this$apiDefinitionHttpV4 = this.getApiDefinitionHttpV4();
        io.gravitee.definition.model.v4.Api other$apiDefinitionHttpV4 = other.getApiDefinitionHttpV4();
        if (this$apiDefinitionHttpV4 == null ? other$apiDefinitionHttpV4 != null : !this$apiDefinitionHttpV4.equals(other$apiDefinitionHttpV4)) {
            return false;
        }
        NativeApi this$apiDefinitionNativeV4 = this.getApiDefinitionNativeV4();
        NativeApi other$apiDefinitionNativeV4 = other.getApiDefinitionNativeV4();
        if (this$apiDefinitionNativeV4 == null ? other$apiDefinitionNativeV4 != null : !this$apiDefinitionNativeV4.equals(other$apiDefinitionNativeV4)) {
            return false;
        }
        io.gravitee.definition.model.Api this$apiDefinition = this.getApiDefinition();
        io.gravitee.definition.model.Api other$apiDefinition = other.getApiDefinition();
        if (this$apiDefinition == null ? other$apiDefinition != null : !this$apiDefinition.equals(other$apiDefinition)) {
            return false;
        }
        FederatedApi this$federatedApiDefinition = this.getFederatedApiDefinition();
        FederatedApi other$federatedApiDefinition = other.getFederatedApiDefinition();
        if (this$federatedApiDefinition == null ? other$federatedApiDefinition != null : !this$federatedApiDefinition.equals(other$federatedApiDefinition)) {
            return false;
        }
        ApiType this$type = this.getType();
        ApiType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ZonedDateTime this$deployedAt = this.getDeployedAt();
        ZonedDateTime other$deployedAt = other.getDeployedAt();
        if (this$deployedAt == null ? other$deployedAt != null : !((Object)this$deployedAt).equals(other$deployedAt)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Visibility this$visibility = this.getVisibility();
        Visibility other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !((Object)((Object)this$visibility)).equals((Object)other$visibility)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$picture = this.getPicture();
        String other$picture = other.getPicture();
        if (this$picture == null ? other$picture != null : !this$picture.equals(other$picture)) {
            return false;
        }
        Set<String> this$groups = this.getGroups();
        Set<String> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        Set<String> this$categories = this.getCategories();
        Set<String> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        ApiLifecycleState this$apiLifecycleState = this.getApiLifecycleState();
        ApiLifecycleState other$apiLifecycleState = other.getApiLifecycleState();
        if (this$apiLifecycleState == null ? other$apiLifecycleState != null : !((Object)((Object)this$apiLifecycleState)).equals((Object)other$apiLifecycleState)) {
            return false;
        }
        String this$background = this.getBackground();
        String other$background = other.getBackground();
        return !(this$background == null ? other$background != null : !this$background.equals(other$background));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Api;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisableMembershipNotifications() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        String $crossId = this.getCrossId();
        result = result * 59 + ($crossId == null ? 43 : $crossId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        OriginContext $originContext = this.getOriginContext();
        result = result * 59 + ($originContext == null ? 43 : $originContext.hashCode());
        DefinitionVersion $definitionVersion = this.getDefinitionVersion();
        result = result * 59 + ($definitionVersion == null ? 43 : $definitionVersion.hashCode());
        io.gravitee.definition.model.v4.Api $apiDefinitionHttpV4 = this.getApiDefinitionHttpV4();
        result = result * 59 + ($apiDefinitionHttpV4 == null ? 43 : $apiDefinitionHttpV4.hashCode());
        NativeApi $apiDefinitionNativeV4 = this.getApiDefinitionNativeV4();
        result = result * 59 + ($apiDefinitionNativeV4 == null ? 43 : $apiDefinitionNativeV4.hashCode());
        io.gravitee.definition.model.Api $apiDefinition = this.getApiDefinition();
        result = result * 59 + ($apiDefinition == null ? 43 : $apiDefinition.hashCode());
        FederatedApi $federatedApiDefinition = this.getFederatedApiDefinition();
        result = result * 59 + ($federatedApiDefinition == null ? 43 : $federatedApiDefinition.hashCode());
        ApiType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ZonedDateTime $deployedAt = this.getDeployedAt();
        result = result * 59 + ($deployedAt == null ? 43 : ((Object)$deployedAt).hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Visibility $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : ((Object)((Object)$visibility)).hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $picture = this.getPicture();
        result = result * 59 + ($picture == null ? 43 : $picture.hashCode());
        Set<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        Set<String> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        ApiLifecycleState $apiLifecycleState = this.getApiLifecycleState();
        result = result * 59 + ($apiLifecycleState == null ? 43 : ((Object)((Object)$apiLifecycleState)).hashCode());
        String $background = this.getBackground();
        result = result * 59 + ($background == null ? 43 : $background.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Api(id=" + this.getId() + ", environmentId=" + this.getEnvironmentId() + ", crossId=" + this.getCrossId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", originContext=" + String.valueOf(this.getOriginContext()) + ", definitionVersion=" + String.valueOf(this.getDefinitionVersion()) + ", apiDefinitionHttpV4=" + String.valueOf(this.getApiDefinitionHttpV4()) + ", apiDefinitionNativeV4=" + String.valueOf(this.getApiDefinitionNativeV4()) + ", apiDefinition=" + String.valueOf(this.getApiDefinition()) + ", federatedApiDefinition=" + String.valueOf(this.getFederatedApiDefinition()) + ", type=" + String.valueOf(this.getType()) + ", deployedAt=" + String.valueOf(this.getDeployedAt()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", visibility=" + String.valueOf((Object)this.getVisibility()) + ", lifecycleState=" + String.valueOf((Object)this.getLifecycleState()) + ", picture=" + this.getPicture() + ", groups=" + String.valueOf(this.getGroups()) + ", categories=" + String.valueOf(this.getCategories()) + ", labels=" + String.valueOf(this.getLabels()) + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ", apiLifecycleState=" + String.valueOf((Object)this.getApiLifecycleState()) + ", background=" + this.getBackground() + ")";
    }

    @Generated
    public Api() {
        this.originContext = Api.$default$originContext();
        this.visibility = Api.$default$visibility();
        this.apiLifecycleState = Api.$default$apiLifecycleState();
    }

    @Generated
    public Api(String id, String environmentId, String crossId, String name, String description, String version, OriginContext originContext, DefinitionVersion definitionVersion, io.gravitee.definition.model.v4.Api apiDefinitionHttpV4, NativeApi apiDefinitionNativeV4, io.gravitee.definition.model.Api apiDefinition, FederatedApi federatedApiDefinition, ApiType type, ZonedDateTime deployedAt, ZonedDateTime createdAt, ZonedDateTime updatedAt, Visibility visibility, LifecycleState lifecycleState, String picture, Set<String> groups, Set<String> categories, List<String> labels, boolean disableMembershipNotifications, ApiLifecycleState apiLifecycleState, String background) {
        this.id = id;
        this.environmentId = environmentId;
        this.crossId = crossId;
        this.name = name;
        this.description = description;
        this.version = version;
        this.originContext = originContext;
        this.definitionVersion = definitionVersion;
        this.apiDefinitionHttpV4 = apiDefinitionHttpV4;
        this.apiDefinitionNativeV4 = apiDefinitionNativeV4;
        this.apiDefinition = apiDefinition;
        this.federatedApiDefinition = federatedApiDefinition;
        this.type = type;
        this.deployedAt = deployedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.visibility = visibility;
        this.lifecycleState = lifecycleState;
        this.picture = picture;
        this.groups = groups;
        this.categories = categories;
        this.labels = labels;
        this.disableMembershipNotifications = disableMembershipNotifications;
        this.apiLifecycleState = apiLifecycleState;
        this.background = background;
    }

    public static enum ApiLifecycleState {
        CREATED,
        PUBLISHED,
        UNPUBLISHED,
        DEPRECATED,
        ARCHIVED;

    }

    public static abstract class ApiBuilder<C extends Api, B extends ApiBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String environmentId;
        @Generated
        private String crossId;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String version;
        @Generated
        private boolean originContext$set;
        @Generated
        private OriginContext originContext$value;
        @Generated
        private DefinitionVersion definitionVersion;
        @Generated
        private io.gravitee.definition.model.v4.Api apiDefinitionHttpV4;
        @Generated
        private NativeApi apiDefinitionNativeV4;
        @Generated
        private io.gravitee.definition.model.Api apiDefinition;
        @Generated
        private FederatedApi federatedApiDefinition;
        @Generated
        private ApiType type;
        @Generated
        private ZonedDateTime deployedAt;
        @Generated
        private ZonedDateTime createdAt;
        @Generated
        private ZonedDateTime updatedAt;
        @Generated
        private boolean visibility$set;
        @Generated
        private Visibility visibility$value;
        @Generated
        private LifecycleState lifecycleState;
        @Generated
        private String picture;
        @Generated
        private Set<String> groups;
        @Generated
        private Set<String> categories;
        @Generated
        private List<String> labels;
        @Generated
        private boolean disableMembershipNotifications;
        @Generated
        private boolean apiLifecycleState$set;
        @Generated
        private ApiLifecycleState apiLifecycleState$value;
        @Generated
        private String background;

        public B apiDefinition(io.gravitee.definition.model.Api apiDefinition) {
            this.apiDefinition = apiDefinition;
            if (apiDefinition != null) {
                this.definitionVersion = apiDefinition.getDefinitionVersion();
            }
            return this.self();
        }

        public B apiDefinitionHttpV4(io.gravitee.definition.model.v4.Api apiDefinitionV4) {
            this.apiDefinitionHttpV4 = apiDefinitionV4;
            if (apiDefinitionV4 != null) {
                this.definitionVersion = apiDefinitionV4.getDefinitionVersion();
            }
            return this.self();
        }

        public B federatedApiDefinition(FederatedApi federatedApiDefinition) {
            this.federatedApiDefinition = federatedApiDefinition;
            if (federatedApiDefinition != null) {
                this.definitionVersion = federatedApiDefinition.getDefinitionVersion();
            }
            return this.self();
        }

        public B apiDefinitionNativeV4(NativeApi nativeApiDefinition) {
            this.apiDefinitionNativeV4 = nativeApiDefinition;
            if (nativeApiDefinition != null) {
                this.definitionVersion = nativeApiDefinition.getDefinitionVersion();
            }
            return this.self();
        }

        @Generated
        protected B $fillValuesFrom(C instance) {
            ApiBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Api instance, ApiBuilder<?, ?> b) {
            b.id(instance.id);
            b.environmentId(instance.environmentId);
            b.crossId(instance.crossId);
            b.name(instance.name);
            b.description(instance.description);
            b.version(instance.version);
            b.originContext(instance.originContext);
            b.definitionVersion(instance.definitionVersion);
            b.apiDefinitionHttpV4(instance.apiDefinitionHttpV4);
            b.apiDefinitionNativeV4(instance.apiDefinitionNativeV4);
            b.apiDefinition(instance.apiDefinition);
            b.federatedApiDefinition(instance.federatedApiDefinition);
            b.type(instance.type);
            b.deployedAt(instance.deployedAt);
            b.createdAt(instance.createdAt);
            b.updatedAt(instance.updatedAt);
            b.visibility(instance.visibility);
            b.lifecycleState(instance.lifecycleState);
            b.picture(instance.picture);
            b.groups(instance.groups);
            b.categories(instance.categories);
            b.labels(instance.labels);
            b.disableMembershipNotifications(instance.disableMembershipNotifications);
            b.apiLifecycleState(instance.apiLifecycleState);
            b.background(instance.background);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this.self();
        }

        @Generated
        public B crossId(String crossId) {
            this.crossId = crossId;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B version(String version) {
            this.version = version;
            return this.self();
        }

        @Generated
        public B originContext(OriginContext originContext) {
            this.originContext$value = originContext;
            this.originContext$set = true;
            return this.self();
        }

        @Generated
        public B definitionVersion(DefinitionVersion definitionVersion) {
            this.definitionVersion = definitionVersion;
            return this.self();
        }

        @Generated
        public B type(ApiType type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B deployedAt(ZonedDateTime deployedAt) {
            this.deployedAt = deployedAt;
            return this.self();
        }

        @Generated
        public B createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public B updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        @Generated
        public B visibility(Visibility visibility) {
            this.visibility$value = visibility;
            this.visibility$set = true;
            return this.self();
        }

        @Generated
        public B lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this.self();
        }

        @Generated
        public B picture(String picture) {
            this.picture = picture;
            return this.self();
        }

        @Generated
        public B groups(Set<String> groups) {
            this.groups = groups;
            return this.self();
        }

        @Generated
        public B categories(Set<String> categories) {
            this.categories = categories;
            return this.self();
        }

        @Generated
        public B labels(List<String> labels) {
            this.labels = labels;
            return this.self();
        }

        @Generated
        public B disableMembershipNotifications(boolean disableMembershipNotifications) {
            this.disableMembershipNotifications = disableMembershipNotifications;
            return this.self();
        }

        @Generated
        public B apiLifecycleState(ApiLifecycleState apiLifecycleState) {
            this.apiLifecycleState$value = apiLifecycleState;
            this.apiLifecycleState$set = true;
            return this.self();
        }

        @Generated
        public B background(String background) {
            this.background = background;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Api.ApiBuilder(id=" + this.id + ", environmentId=" + this.environmentId + ", crossId=" + this.crossId + ", name=" + this.name + ", description=" + this.description + ", version=" + this.version + ", originContext$value=" + String.valueOf(this.originContext$value) + ", definitionVersion=" + String.valueOf(this.definitionVersion) + ", apiDefinitionHttpV4=" + String.valueOf(this.apiDefinitionHttpV4) + ", apiDefinitionNativeV4=" + String.valueOf(this.apiDefinitionNativeV4) + ", apiDefinition=" + String.valueOf(this.apiDefinition) + ", federatedApiDefinition=" + String.valueOf(this.federatedApiDefinition) + ", type=" + String.valueOf(this.type) + ", deployedAt=" + String.valueOf(this.deployedAt) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", visibility$value=" + String.valueOf((Object)this.visibility$value) + ", lifecycleState=" + String.valueOf((Object)this.lifecycleState) + ", picture=" + this.picture + ", groups=" + String.valueOf(this.groups) + ", categories=" + String.valueOf(this.categories) + ", labels=" + String.valueOf(this.labels) + ", disableMembershipNotifications=" + this.disableMembershipNotifications + ", apiLifecycleState$value=" + String.valueOf((Object)this.apiLifecycleState$value) + ", background=" + this.background + ")";
        }
    }

    public static enum Visibility {
        PUBLIC,
        PRIVATE;

    }

    public static enum LifecycleState {
        STARTED,
        STOPPED;

    }

    @Generated
    private static final class ApiBuilderImpl
    extends ApiBuilder<Api, ApiBuilderImpl> {
        @Generated
        private ApiBuilderImpl() {
        }

        @Override
        @Generated
        protected ApiBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Api build() {
            return new Api(this);
        }
    }
}

