/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api_key.model.ApiKeyEntity;
import io.gravitee.apim.infra.adapter.ApiKeyAdapter;
import io.gravitee.repository.management.model.ApiKey;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ApiKeyAdapterImpl
implements ApiKeyAdapter {
    @Override
    public ApiKeyEntity toEntity(ApiKey apiKey) {
        if (apiKey == null) {
            return null;
        }
        ApiKeyEntity.ApiKeyEntityBuilder apiKeyEntity = ApiKeyEntity.builder();
        apiKeyEntity.applicationId(apiKey.getApplication());
        apiKeyEntity.id(apiKey.getId());
        apiKeyEntity.key(apiKey.getKey());
        List list = apiKey.getSubscriptions();
        if (list != null) {
            apiKeyEntity.subscriptions(new ArrayList<String>(list));
        }
        apiKeyEntity.environmentId(apiKey.getEnvironmentId());
        if (apiKey.getExpireAt() != null) {
            apiKeyEntity.expireAt(ZonedDateTime.ofInstant(apiKey.getExpireAt().toInstant(), ZoneId.systemDefault()));
        }
        if (apiKey.getCreatedAt() != null) {
            apiKeyEntity.createdAt(ZonedDateTime.ofInstant(apiKey.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (apiKey.getUpdatedAt() != null) {
            apiKeyEntity.updatedAt(ZonedDateTime.ofInstant(apiKey.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        apiKeyEntity.revoked(apiKey.isRevoked());
        if (apiKey.getRevokedAt() != null) {
            apiKeyEntity.revokedAt(ZonedDateTime.ofInstant(apiKey.getRevokedAt().toInstant(), ZoneId.systemDefault()));
        }
        apiKeyEntity.paused(apiKey.isPaused());
        apiKeyEntity.federated(apiKey.isFederated());
        apiKeyEntity.daysToExpirationOnLastNotification(apiKey.getDaysToExpirationOnLastNotification());
        return apiKeyEntity.build();
    }

    @Override
    public ApiKey fromEntity(ApiKeyEntity apiKeyEntity) {
        if (apiKeyEntity == null) {
            return null;
        }
        ApiKey.ApiKeyBuilder apiKey = ApiKey.builder();
        apiKey.application(apiKeyEntity.getApplicationId());
        apiKey.id(apiKeyEntity.getId());
        apiKey.key(apiKeyEntity.getKey());
        List<String> list = apiKeyEntity.getSubscriptions();
        if (list != null) {
            apiKey.subscriptions(new ArrayList<String>(list));
        }
        apiKey.environmentId(apiKeyEntity.getEnvironmentId());
        if (apiKeyEntity.getExpireAt() != null) {
            apiKey.expireAt(Date.from(apiKeyEntity.getExpireAt().toInstant()));
        }
        if (apiKeyEntity.getCreatedAt() != null) {
            apiKey.createdAt(Date.from(apiKeyEntity.getCreatedAt().toInstant()));
        }
        if (apiKeyEntity.getUpdatedAt() != null) {
            apiKey.updatedAt(Date.from(apiKeyEntity.getUpdatedAt().toInstant()));
        }
        apiKey.revoked(apiKeyEntity.isRevoked());
        apiKey.paused(apiKeyEntity.isPaused());
        if (apiKeyEntity.getRevokedAt() != null) {
            apiKey.revokedAt(Date.from(apiKeyEntity.getRevokedAt().toInstant()));
        }
        apiKey.federated(apiKeyEntity.isFederated());
        apiKey.daysToExpirationOnLastNotification(apiKeyEntity.getDaysToExpirationOnLastNotification());
        return apiKey.build();
    }
}

