/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.v4.api.ExportApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativeApiEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ApiDefinitionVersionNotSupportedException;
import io.gravitee.rest.api.service.v4.ApiImportExportService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.PlanService;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiImportExportServiceImpl
implements ApiImportExportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiImportExportServiceImpl.class);
    private final ApiMetadataService apiMetadataService;
    private final ApiSearchService apiSearchService;
    private final MediaService mediaService;
    private final MembershipService membershipService;
    private final PageService pageService;
    private final PermissionService permissionService;
    private final PlanService planService;
    private final RoleService roleService;

    public ApiImportExportServiceImpl(ApiMetadataService apiMetadataService, ApiSearchService apiSearchService, MediaService mediaService, MembershipService membershipService, PageService pageService, PermissionService permissionService, PlanService planService, RoleService roleService) {
        this.apiMetadataService = apiMetadataService;
        this.apiSearchService = apiSearchService;
        this.mediaService = mediaService;
        this.membershipService = membershipService;
        this.pageService = pageService;
        this.permissionService = permissionService;
        this.planService = planService;
        this.roleService = roleService;
    }

    @Override
    public ExportApiEntity exportApi(ExecutionContext executionContext, String apiId, String userId, Set<String> excludeAdditionalData) {
        GenericApiEntity apiEntity = this.apiSearchService.findGenericById(executionContext, apiId);
        if (apiEntity.getDefinitionVersion() != DefinitionVersion.V4) {
            throw new ApiDefinitionVersionNotSupportedException(apiEntity.getDefinitionVersion().getLabel());
        }
        boolean isNativeApi = apiEntity instanceof NativeApiEntity;
        ExportApiEntity exportApi = new ExportApiEntity();
        exportApi.setApiEntity(apiEntity);
        if (!excludeAdditionalData.contains("members")) {
            Set<MemberEntity> members = this.exportApiMembers(apiId);
            exportApi.setMembers(members);
        }
        if (!excludeAdditionalData.contains("metadata")) {
            Set<ApiMetadataEntity> metadata = this.exportApiMetadata(executionContext, apiId);
            exportApi.setMetadata(metadata);
        }
        if (!excludeAdditionalData.contains("plans")) {
            Set<? extends GenericPlanEntity> plans = this.exportApiPlans(apiId, isNativeApi);
            exportApi.setPlans(plans);
        }
        if (!excludeAdditionalData.contains("pages")) {
            this.exportApiPagesAndMedia(apiId, exportApi);
        }
        if (excludeAdditionalData.contains("groups")) {
            exportApi.excludeGroups();
        }
        return exportApi;
    }

    private void exportApiPagesAndMedia(String apiId, ExportApiEntity exportApi) {
        if (this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_DOCUMENTATION, apiId, RolePermissionAction.READ)) {
            List<PageEntity> pageList = this.pageService.findByApi(GraviteeContext.getCurrentEnvironment(), apiId);
            exportApi.setPages(pageList);
            List<MediaEntity> apiMediaList = this.mediaService.findAllByApiId(apiId);
            exportApi.setApiMedia(apiMediaList);
        }
    }

    private Set<? extends GenericPlanEntity> exportApiPlans(String apiId, boolean isNativeApi) {
        if (this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_PLAN, apiId, RolePermissionAction.READ)) {
            if (isNativeApi) {
                return this.planService.findNativePlansByApi(GraviteeContext.getExecutionContext(), apiId);
            }
            return this.planService.findByApi(GraviteeContext.getExecutionContext(), apiId);
        }
        return null;
    }

    private Set<ApiMetadataEntity> exportApiMetadata(ExecutionContext executionContext, String apiId) {
        if (this.permissionService.hasPermission(executionContext, RolePermission.API_METADATA, apiId, RolePermissionAction.READ)) {
            return new HashSet<ApiMetadataEntity>(this.apiMetadataService.findAllByApi(executionContext, apiId));
        }
        return null;
    }

    private Set<MemberEntity> exportApiMembers(String apiId) {
        if (this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_MEMBER, apiId, RolePermissionAction.READ)) {
            return this.membershipService.getMembersByReference(GraviteeContext.getExecutionContext(), MembershipReferenceType.API, apiId).stream().filter(memberEntity -> memberEntity.getType() == MembershipMemberType.USER).collect(Collectors.toSet());
        }
        return null;
    }

    @Override
    public void createMembers(ExecutionContext executionContext, String apiId, Set<MemberEntity> members) {
        if (members.isEmpty()) {
            return;
        }
        RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(executionContext.getOrganizationId(), RoleScope.API);
        assert (poRole != null);
        String poRoleName = poRole.getName();
        List<RoleEntity> defaultApiRole = this.roleService.findDefaultRoleByScopes(executionContext.getOrganizationId(), RoleScope.API);
        assert (!CollectionUtils.isEmpty(defaultApiRole));
        for (MemberEntity member : members) {
            if (CollectionUtils.isEmpty(member.getRoles())) {
                log.warn("There is no role associated with this member. Default role will be applied");
                member.setRoles(defaultApiRole);
            }
            List<RoleEntity> rolesToImport = member.getRoles().stream().filter(role -> !role.getName().equals(poRoleName)).map(role -> {
                block3: {
                    try {
                        UUID id = UUID.fromString(role.getName());
                        RoleEntity roleEntity = this.roleService.findById(id.toString());
                        if (roleEntity != null) {
                            return roleEntity;
                        }
                    }
                    catch (IllegalArgumentException exception) {
                        Optional<RoleEntity> roleEntity = this.roleService.findByScopeAndName(RoleScope.API, role.getName(), executionContext.getOrganizationId());
                        if (!roleEntity.isPresent()) break block3;
                        return roleEntity.get();
                    }
                }
                log.warn("Unable to find role '{}' to import", (Object)role.getName());
                return (RoleEntity)defaultApiRole.iterator().next();
            }).filter(Objects::nonNull).toList();
            rolesToImport.forEach(role -> {
                try {
                    this.membershipService.deleteReferenceMember(executionContext, MembershipReferenceType.API, apiId, MembershipMemberType.USER, member.getId());
                    this.membershipService.addRoleToMemberOnReference(executionContext, MembershipReferenceType.API, apiId, MembershipMemberType.USER, member.getId(), role.getId());
                }
                catch (Exception e) {
                    log.warn("Unable to add role '{}[{}]' to member '{}[{}]' on API '[{}]' due to : {}", new Object[]{role.getName(), role.getId(), member.getDisplayName(), member.getId(), apiId, e.getMessage()});
                }
            });
        }
        log.debug("Members successfully created for imported api {}", (Object)apiId);
    }

    @Override
    public void createPageAndMedia(ExecutionContext executionContext, String apiId, List<MediaEntity> mediaEntities) {
        mediaEntities.forEach(mediaEntity -> {
            try {
                this.mediaService.saveApiMedia(executionContext, apiId, (MediaEntity)mediaEntity);
            }
            catch (Exception e) {
                log.warn("Unable to create api media {} for imported API {}' due to : {}", new Object[]{mediaEntity.getFileName(), apiId, e.getMessage()});
            }
        });
        List<PageEntity> search = this.pageService.search(executionContext.getEnvironmentId(), new PageQuery.Builder().api(apiId).name(SystemFolderType.ASIDE.folderName()).type(PageType.SYSTEM_FOLDER).build());
        if (search.isEmpty()) {
            this.pageService.createAsideFolder(executionContext, apiId);
        }
        log.debug("Media successfully created for imported api {}", (Object)apiId);
    }
}

