/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Plan;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PlanApiTypeUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanApiTypeUpgrader.class);
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private PlanRepository planRepository;

    public boolean upgrade() {
        try {
            this.updatePlanApiType();
        }
        catch (Exception e) {
            log.error("Unable to apply upgrader {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }

    private void updatePlanApiType() throws TechnicalException {
        log.info("Starting migration of plan api_type...");
        this.apiRepository.search(new ApiCriteria.Builder().definitionVersion(List.of(DefinitionVersion.V4)).build(), null, ApiFieldFilter.defaultFields()).forEach(this::populatePlansWithApiTypeForApi);
        log.info("Migration of plan api_type completed.");
    }

    private void populatePlansWithApiTypeForApi(Api api) {
        try {
            this.planRepository.findByApi(api.getId()).stream().forEach(plan -> {
                try {
                    this.populateApiType((Plan)plan, api.getType());
                }
                catch (TechnicalException e) {
                    log.error("Unable to update api_type for plan {}", (Object)plan.getId(), (Object)e);
                }
            });
        }
        catch (Exception e) {
            log.error("Unable to migrate api_type for API {} and its plans", (Object)api.getId(), (Object)e);
        }
    }

    private void populateApiType(Plan plan, ApiType apiType) throws TechnicalException {
        plan.setApiType(apiType);
        this.planRepository.update((Object)plan);
        log.info("Updated plan {} with api_type {}", (Object)plan.getId(), (Object)apiType);
    }

    public int getOrder() {
        return 705;
    }
}

