/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.installation;

import com.google.common.base.Strings;
import com.google.common.net.InternetDomainName;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.apim.core.access_point.query_service.AccessPointQueryService;
import io.gravitee.apim.core.installation.domain_service.InstallationTypeDomainService;
import io.gravitee.apim.core.installation.model.RestrictedDomain;
import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import jakarta.annotation.PostConstruct;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Service;

@Service
public class InstallationAccessQueryServiceImpl
implements InstallationAccessQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallationAccessQueryServiceImpl.class);
    private static final String INSTALLATION_STANDALONE_PROPERTY = "installation.standalone.";
    private static final String DEFAULT_ID = GraviteeContext.getDefaultOrganization();
    private final ConfigurableEnvironment environment;
    private final InstallationTypeDomainService installationTypeDomainService;
    private final AccessPointQueryService accessPointQueryService;
    private final ParameterService parameterService;
    private final OrganizationService organizationService;
    private final EnvironmentService environmentService;
    @Value(value="${installation.api.console.url:${installation.api.url:#{null}}}")
    private String consoleApiUrl;
    @Value(value="${installation.api.portal.url:${installation.api.url:#{null}}}")
    private String portalApiUrl;
    @Value(value="${installation.api.proxyPath.management:${http.api.management.entrypoint:${http.api.entrypoint:/}management}}")
    private String managementProxyPath;
    @Value(value="${installation.api.proxyPath.portal:${http.api.portal.entrypoint:${http.api.entrypoint:/}portal}}")
    private String portalProxyPath;
    private final Map<String, String> consoleUrls = new HashMap<String, String>();
    private final Map<String, String> portalUrls = new HashMap<String, String>();

    public InstallationAccessQueryServiceImpl(ConfigurableEnvironment environment, InstallationTypeDomainService installationTypeDomainService, AccessPointQueryService accessPointQueryService, ParameterService parameterService, @Lazy OrganizationService organizationService, @Lazy EnvironmentService environmentService) {
        this.environment = environment;
        this.installationTypeDomainService = installationTypeDomainService;
        this.accessPointQueryService = accessPointQueryService;
        this.parameterService = parameterService;
        this.organizationService = organizationService;
        this.environmentService = environmentService;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        if (!this.installationTypeDomainService.isMultiTenant()) {
            this.consoleUrls.putAll(this.loadUrls("console", "orgId"));
            this.portalUrls.putAll(this.loadUrls("portal", "envId"));
            this.handleEnvironmentUrls();
            this.validateApiUrl(this.consoleApiUrl);
            this.validateApiUrl(this.portalApiUrl);
        }
    }

    private void validateApiUrl(String apiURL) {
        if (apiURL != null) {
            try {
                URL url = URI.create(apiURL).toURL();
                if (!InstallationAccessQueryServiceImpl.isValidDomainName(url.getHost())) {
                    throw new InvalidInstallationUrlException("API url '%s' is malformed.".formatted(apiURL));
                }
            }
            catch (Exception e) {
                throw new InvalidInstallationUrlException("API url '%s' must be a valid URL.".formatted(apiURL));
            }
        }
    }

    private void handleEnvironmentUrls() {
        String legacyPortalUrl;
        if (this.consoleUrls.isEmpty()) {
            legacyPortalUrl = this.environment.getProperty("management.url");
            if (legacyPortalUrl != null) {
                this.consoleUrls.put(DEFAULT_ID, legacyPortalUrl);
            } else {
                String legacyUIUrl = this.environment.getProperty("console.ui.url");
                if (legacyUIUrl != null) {
                    this.consoleUrls.put(DEFAULT_ID, legacyUIUrl);
                }
            }
        }
        if (this.portalUrls.isEmpty()) {
            legacyPortalUrl = this.environment.getProperty("portal.url");
            if (legacyPortalUrl != null) {
                this.portalUrls.put(DEFAULT_ID, legacyPortalUrl);
            } else {
                legacyPortalUrl = this.environment.getProperty("console.portal.url");
                if (legacyPortalUrl != null) {
                    this.portalUrls.put(DEFAULT_ID, legacyPortalUrl);
                }
            }
        }
        if (this.consoleApiUrl == null) {
            try {
                String legacyApiUrl = this.environment.getProperty("console.api.url");
                if (legacyApiUrl != null) {
                    String url;
                    URI legacyApiURI = URI.create(legacyApiUrl);
                    this.managementProxyPath = legacyApiURI.getPath();
                    this.consoleApiUrl = url = legacyApiURI.resolve("/").toString();
                    this.portalApiUrl = url;
                }
            }
            catch (Exception e) {
                log.warn("Unable to parse legacy url configuration [console.api.url]", (Throwable)e);
            }
        }
    }

    private Map<String, String> loadUrls(String keyUI, String keyId) {
        HashMap<String, String> urls = new HashMap<String, String>();
        int idx = 0;
        boolean hasMany = this.environment.containsProperty(INSTALLATION_STANDALONE_PROPERTY + keyUI + ".urls[" + idx + "]." + keyId);
        if (hasMany) {
            boolean hasNext = true;
            while (hasNext) {
                String id = this.environment.getProperty(INSTALLATION_STANDALONE_PROPERTY + keyUI + ".urls[" + idx + "]." + keyId);
                boolean bl = hasNext = id != null;
                if (hasNext) {
                    String url = this.environment.getProperty(INSTALLATION_STANDALONE_PROPERTY + keyUI + ".urls[" + idx + "].url");
                    this.validateUrl(keyUI, url);
                    urls.put(id, url);
                }
                ++idx;
            }
        } else {
            String uiUrl = this.environment.getProperty(INSTALLATION_STANDALONE_PROPERTY + keyUI + ".url");
            if (uiUrl != null) {
                this.validateUrl(keyUI, uiUrl);
                urls.put(DEFAULT_ID, uiUrl);
            }
        }
        return urls;
    }

    private void validateUrl(String keyUI, String urlAsString) {
        URL url;
        if (urlAsString == null) {
            throw new InvalidInstallationUrlException("Installation '%s' url  cannot be null or empty.".formatted(keyUI));
        }
        try {
            url = URI.create(urlAsString).toURL();
        }
        catch (Exception e) {
            throw new InvalidInstallationUrlException("Installation '%s' url '%s' must be a valid URL.".formatted(keyUI, urlAsString));
        }
        this.validateHost(keyUI, url.getHost());
    }

    private void validateHost(String keyUI, String hostAsString) {
        if (!InstallationAccessQueryServiceImpl.isValidDomainName(hostAsString)) {
            throw new InvalidInstallationUrlException("Installation '%s' url '%s' is malformed.".formatted(keyUI, hostAsString));
        }
    }

    public static boolean isValidDomainName(String domain) {
        if (Strings.isNullOrEmpty((String)domain)) {
            return false;
        }
        return InternetDomainName.isValid((String)domain);
    }

    @Override
    public String getConsoleApiPath() {
        return this.managementProxyPath;
    }

    @Override
    public String getPortalApiPath() {
        return this.portalProxyPath;
    }

    @Override
    public List<String> getConsoleUrls() {
        if (this.installationTypeDomainService.isMultiTenant()) {
            List<AccessPoint> accessPoints = this.accessPointQueryService.getConsoleAccessPoints();
            return accessPoints.stream().map(this::buildHttpUrl).toList();
        }
        Collection<OrganizationEntity> organizations = this.organizationService.findAll();
        if (organizations == null || organizations.isEmpty()) {
            OrganizationEntity organization = this.organizationService.getDefaultOrInitialize();
            return List.of(this.getConsoleUrlFromEnv(organization.getId()));
        }
        return organizations.stream().map(OrganizationEntity::getId).map(this::getConsoleUrlFromEnv).toList();
    }

    @Override
    public List<String> getConsoleUrls(String organizationId) {
        if (this.installationTypeDomainService.isMultiTenant()) {
            List<AccessPoint> accessPoints = this.accessPointQueryService.getConsoleAccessPoints(organizationId);
            return accessPoints.stream().map(this::buildHttpUrl).toList();
        }
        String consoleUrl = this.getConsoleUrlFromEnv(organizationId);
        return List.of(consoleUrl);
    }

    @Override
    public String getConsoleUrl(String organizationId) {
        if (this.installationTypeDomainService.isMultiTenant()) {
            AccessPoint accessPoint = this.accessPointQueryService.getConsoleAccessPoint(organizationId);
            return this.buildHttpUrl(accessPoint);
        }
        return this.getConsoleUrlFromEnv(organizationId);
    }

    @NonNull
    private String getConsoleUrlFromEnv(String organizationId) {
        String consoleUrl = this.consoleUrls.get(organizationId);
        if ((consoleUrl == null || consoleUrl.equals("http://localhost:4000")) && (consoleUrl = this.parameterService.find(GraviteeContext.getExecutionContext(), Key.MANAGEMENT_URL, organizationId, ParameterReferenceType.ORGANIZATION)) == null) {
            consoleUrl = Key.MANAGEMENT_URL.defaultValue();
        }
        if (consoleUrl == null) {
            consoleUrl = "http://localhost:4000";
        }
        return consoleUrl;
    }

    @Override
    public String getConsoleAPIUrl(String organizationId) {
        String consoleAPIBaseUrl;
        if (this.installationTypeDomainService.isMultiTenant()) {
            AccessPoint consoleAccessPoint = this.accessPointQueryService.getConsoleApiAccessPoint(organizationId);
            consoleAPIBaseUrl = this.buildHttpUrl(consoleAccessPoint);
        } else {
            consoleAPIBaseUrl = this.consoleApiUrl;
        }
        if (consoleAPIBaseUrl != null) {
            URI fullUrl = URI.create(consoleAPIBaseUrl).resolve(this.managementProxyPath);
            return fullUrl.toString();
        }
        return null;
    }

    @Override
    public List<String> getPortalUrls() {
        if (this.installationTypeDomainService.isMultiTenant()) {
            List<AccessPoint> accessPoints = this.accessPointQueryService.getPortalAccessPoints();
            return accessPoints.stream().map(this::buildHttpUrl).toList();
        }
        return this.environmentService.findAllOrInitialize().stream().map(EnvironmentEntity::getId).map(this::getPortalUrlFromEnv).toList();
    }

    @Override
    public List<String> getPortalUrls(String environmentId) {
        if (this.installationTypeDomainService.isMultiTenant()) {
            List<AccessPoint> accessPoints = this.accessPointQueryService.getPortalAccessPoints(environmentId);
            return accessPoints.stream().map(this::buildHttpUrl).toList();
        }
        String portalUrl = this.getPortalUrlFromEnv(environmentId);
        return List.of(portalUrl);
    }

    @Override
    public String getPortalUrl(String environmentId) {
        if (this.installationTypeDomainService.isMultiTenant()) {
            AccessPoint consoleAccessPoint = this.accessPointQueryService.getPortalAccessPoint(environmentId);
            return this.buildHttpUrl(consoleAccessPoint);
        }
        return this.getPortalUrlFromEnv(environmentId);
    }

    @NonNull
    private String getPortalUrlFromEnv(String environmentId) {
        String portalUrl = this.portalUrls.get(environmentId);
        if ((portalUrl == null || portalUrl.equals("http://localhost:4100")) && (portalUrl = this.parameterService.find(GraviteeContext.getExecutionContext(), Key.PORTAL_URL, environmentId, ParameterReferenceType.ENVIRONMENT)) == null) {
            portalUrl = Key.PORTAL_URL.defaultValue();
        }
        if (portalUrl == null) {
            portalUrl = "http://localhost:4100";
        }
        return portalUrl;
    }

    @Override
    public String getPortalAPIUrl(String environmentId) {
        String portalAPIBaseUrl;
        if (this.installationTypeDomainService.isMultiTenant()) {
            AccessPoint consoleAccessPoint = this.accessPointQueryService.getPortalApiAccessPoint(environmentId);
            portalAPIBaseUrl = this.buildHttpUrl(consoleAccessPoint);
        } else {
            portalAPIBaseUrl = this.portalApiUrl;
        }
        if (portalAPIBaseUrl != null) {
            URI fullUrl = URI.create(portalAPIBaseUrl).resolve(this.portalProxyPath);
            return fullUrl.toString();
        }
        return null;
    }

    @Override
    public List<RestrictedDomain> getGatewayRestrictedDomains(String environmentId) {
        if (this.installationTypeDomainService.isMultiTenant()) {
            return this.accessPointQueryService.getGatewayAccessPoints(environmentId).stream().map(accessPoint -> RestrictedDomain.builder().domain(accessPoint.getHost()).secured(accessPoint.isSecured()).build()).toList();
        }
        return List.of();
    }

    private String buildHttpUrl(AccessPoint accessPoint) {
        if (accessPoint != null) {
            return accessPoint.buildInstallationAccess();
        }
        return null;
    }

    static class InvalidInstallationUrlException
    extends RuntimeException {
        public InvalidInstallationUrlException(String message) {
            super(message);
        }
    }
}

