/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.api_key;

import io.gravitee.apim.core.api_key.model.ApiKeyEntity;
import io.gravitee.apim.core.api_key.query_service.ApiKeyQueryService;
import io.gravitee.apim.infra.adapter.ApiKeyAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiKeyQueryServiceImpl
implements ApiKeyQueryService {
    private final ApiKeyRepository apiKeyRepository;

    public ApiKeyQueryServiceImpl(@Lazy ApiKeyRepository apiKeyRepository) {
        this.apiKeyRepository = apiKeyRepository;
    }

    @Override
    public Optional<ApiKeyEntity> findById(String id) {
        try {
            return this.apiKeyRepository.findById(id).map(ApiKeyAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to find API key by id: " + id, e);
        }
    }

    @Override
    public Stream<ApiKeyEntity> findByApplication(String applicationId) {
        try {
            return this.apiKeyRepository.findByApplication(applicationId).stream().map(ApiKeyAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to find API keys by application id: " + applicationId, e);
        }
    }

    @Override
    public Optional<ApiKeyEntity> findByKeyAndApiId(String key, String apiId) {
        try {
            return this.apiKeyRepository.findByKeyAndApi(key, apiId).map(ApiKeyAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to find API key by [key=%s] and [apiId=%s]", key, apiId), e);
        }
    }

    @Override
    public Stream<ApiKeyEntity> findBySubscription(String subscriptionId) {
        try {
            return this.apiKeyRepository.findBySubscription(subscriptionId).stream().map(ApiKeyAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to find API keys by subscription id: " + subscriptionId, e);
        }
    }
}

