/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.transformer;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.search.model.IndexableApi;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.definition.model.v4.nativeapi.kafka.KafkaListener;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.impl.search.lucene.DocumentTransformer;
import io.gravitee.rest.api.service.impl.search.lucene.transformer.ApiDocumentTransformer;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.springframework.stereotype.Component;

@Component
public class IndexableApiDocumentTransformer
implements DocumentTransformer<IndexableApi> {
    private final Collator collator = Collator.getInstance(Locale.ENGLISH);

    @Override
    public Document transform(IndexableApi indexableApi) {
        io.gravitee.apim.core.api.model.Api api = indexableApi.getApi();
        PrimaryOwnerEntity primaryOwner = indexableApi.getPrimaryOwner();
        Map<String, String> metadata = indexableApi.getDecodedMetadata();
        Collection<String> categories = indexableApi.getCategoryKeys();
        if (!this.accept(indexableApi)) {
            throw new TechnicalDomainException("Unsupported definition version: " + api.getDefinitionVersion());
        }
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", api.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField("type", "api", Field.Store.YES));
        if (api.getDefinitionVersion() == null && api.getName() == null) {
            return doc;
        }
        if (api.getDefinitionVersion() != null) {
            doc.add((IndexableField)new StringField("definition_version", api.getDefinitionVersion().getLabel(), Field.Store.NO));
        }
        if (indexableApi.getReferenceId() != null) {
            doc.add((IndexableField)new StringField("reference_type", indexableApi.getReferenceType(), Field.Store.NO));
            doc.add((IndexableField)new StringField("reference_id", indexableApi.getReferenceId(), Field.Store.NO));
        }
        if (api.getName() != null) {
            doc.add((IndexableField)new StringField("name", api.getName(), Field.Store.NO));
            doc.add((IndexableField)new SortedDocValuesField("name_sorted", this.toSortedValue(api.getName())));
            doc.add((IndexableField)new StringField("name_lowercase", api.getName().toLowerCase(), Field.Store.NO));
            doc.add((IndexableField)new TextField("name_split", api.getName(), Field.Store.NO));
        }
        if (api.getDescription() != null) {
            doc.add((IndexableField)new StringField("description", api.getDescription(), Field.Store.NO));
            doc.add((IndexableField)new StringField("description_lowercase", api.getDescription().toLowerCase(), Field.Store.NO));
            doc.add((IndexableField)new TextField("description_split", api.getDescription(), Field.Store.NO));
        }
        if (primaryOwner != null) {
            doc.add((IndexableField)new StringField("ownerName", primaryOwner.displayName(), Field.Store.NO));
            doc.add((IndexableField)new StringField("ownerName_lowercase", primaryOwner.displayName().toLowerCase(), Field.Store.NO));
            if (primaryOwner.email() != null) {
                doc.add((IndexableField)new TextField("ownerMail", primaryOwner.email(), Field.Store.NO));
            }
        }
        if (api.getLabels() != null) {
            for (String label : api.getLabels()) {
                doc.add((IndexableField)new StringField("labels", label, Field.Store.YES));
                doc.add((IndexableField)new StringField("labels_lowercase", label.toLowerCase(), Field.Store.NO));
                doc.add((IndexableField)new TextField("labels_split", label, Field.Store.NO));
            }
        }
        if (categories != null) {
            for (String category : categories) {
                doc.add((IndexableField)new StringField("categories", category, Field.Store.NO));
                doc.add((IndexableField)new TextField("categories_split", category, Field.Store.NO));
            }
        }
        if (api.getCreatedAt() != null) {
            doc.add((IndexableField)new LongPoint("createdAt", new long[]{api.getCreatedAt().toInstant().toEpochMilli()}));
        }
        if (api.getUpdatedAt() != null) {
            doc.add((IndexableField)new LongPoint("updatedAt", new long[]{api.getUpdatedAt().toInstant().toEpochMilli()}));
        }
        if (metadata != null) {
            metadata.values().forEach(metadataValue -> {
                doc.add((IndexableField)new StringField("metadata", metadataValue, Field.Store.NO));
                doc.add((IndexableField)new TextField("metadata_split", metadataValue, Field.Store.NO));
            });
        }
        if (api.getOriginContext() != null && api.getOriginContext().name() != null) {
            doc.add((IndexableField)new StringField("origin", api.getOriginContext().name(), Field.Store.NO));
        }
        if (api.getDefinitionVersion() == DefinitionVersion.V4) {
            this.transformV4Api(doc, indexableApi);
        }
        return doc;
    }

    private boolean accept(IndexableApi indexableApi) {
        io.gravitee.apim.core.api.model.Api api = indexableApi.getApi();
        if (api.getDefinitionVersion() != null) {
            return switch (api.getDefinitionVersion()) {
                case DefinitionVersion.V4, DefinitionVersion.FEDERATED -> true;
                default -> false;
            };
        }
        return true;
    }

    private void transformV4Api(Document doc, IndexableApi api) {
        NativeApi apiDefinitionV4;
        Object object = apiDefinitionV4 = api.getApi().getType() == ApiType.NATIVE ? api.getApi().getApiDefinitionNativeV4() : api.getApi().getApiDefinitionHttpV4();
        if (api.getApi().getType() == ApiType.NATIVE) {
            this.transformV4ApiNativeListeners(doc, api.getApi().getApiDefinitionNativeV4());
        } else {
            this.transformV4ApiHttpListeners(doc, api.getApi().getApiDefinitionHttpV4());
        }
        if (apiDefinitionV4.getTags() != null) {
            for (String tag : apiDefinitionV4.getTags()) {
                doc.add((IndexableField)new StringField("tags", tag, Field.Store.NO));
                doc.add((IndexableField)new TextField("tags_split", tag, Field.Store.NO));
            }
        }
    }

    private void transformV4ApiHttpListeners(Document doc, Api apiDefinitionV4) {
        if (apiDefinitionV4 != null && apiDefinitionV4.getListeners() != null) {
            int[] pathIndex = new int[]{0};
            apiDefinitionV4.getListeners().stream().filter(listener -> listener.getType() == ListenerType.HTTP).flatMap(listener -> {
                HttpListener httpListener = (HttpListener)listener;
                return httpListener.getPaths().stream();
            }).forEach(path -> {
                this.appendPath(doc, pathIndex, path.getPath());
                this.appendHost(doc, path.getHost());
            });
        }
    }

    private void transformV4ApiNativeListeners(Document doc, NativeApi apiDefinitionV4) {
        if (apiDefinitionV4 != null && apiDefinitionV4.getListeners() != null) {
            apiDefinitionV4.getListeners().stream().filter(listener -> listener.getType() == ListenerType.KAFKA).forEach(listener -> {
                if (listener instanceof KafkaListener) {
                    KafkaListener kafkaListener = (KafkaListener)listener;
                    this.appendHost(doc, kafkaListener.getHost());
                }
            });
        }
    }

    private void appendPath(Document doc, int[] pathIndex, String path) {
        doc.add((IndexableField)new StringField("paths", path, Field.Store.NO));
        doc.add((IndexableField)new TextField("paths_split", path, Field.Store.NO));
        int n = pathIndex[0];
        pathIndex[0] = n + 1;
        if (n == 0) {
            doc.add((IndexableField)new SortedDocValuesField("paths_sorted", this.toSortedValue(path)));
        }
    }

    private void appendHost(Document doc, String host) {
        if (host != null && !host.isEmpty()) {
            doc.add((IndexableField)new StringField("hosts", host, Field.Store.NO));
            doc.add((IndexableField)new TextField("hosts_split", host, Field.Store.NO));
        }
    }

    private BytesRef toSortedValue(String value) {
        if (value == null) {
            return new BytesRef((CharSequence)"");
        }
        String cleaned = ApiDocumentTransformer.SPECIAL_CHARS.matcher(value).replaceAll("");
        this.collator.setStrength(1);
        CollationKey key = this.collator.getCollationKey(cleaned);
        return new BytesRef(key.toByteArray());
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return IndexableApi.class.isAssignableFrom(source);
    }
}

