/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ExecutionModeUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutionModeUpgrader.class);
    private static final int BULK_SIZE = 100;
    private final ApiRepository apiRepository;
    private int modelCounter;
    private final ObjectMapper objectMapper;

    @Autowired
    public ExecutionModeUpgrader(@Lazy ApiRepository apiRepository, @Lazy ObjectMapper objectMapper) {
        this.apiRepository = apiRepository;
        this.objectMapper = objectMapper;
    }

    public int getOrder() {
        return 610;
    }

    public boolean upgrade() {
        try {
            this.migrateApiEvents();
        }
        catch (Exception e) {
            log.error("Error applying upgrader", (Throwable)e);
            return false;
        }
        return true;
    }

    private void migrateApiEvents() {
        log.info("Starting migrating execution mode for APIs");
        this.modelCounter = 0;
        ApiCriteria onlyV2ApiCriteria = new ApiCriteria.Builder().definitionVersion(List.of(DefinitionVersion.V2)).build();
        this.apiRepository.search(onlyV2ApiCriteria, null, new ApiFieldFilter.Builder().excludePicture().build()).forEach(api -> {
            try {
                ObjectNode objectNode;
                JsonNode executionMode;
                JsonNode apiDefinitionNode;
                if (api.getDefinition() != null && (apiDefinitionNode = this.objectMapper.readTree(api.getDefinition())).isObject() && (executionMode = (objectNode = (ObjectNode)apiDefinitionNode).get("execution_mode")) != null && executionMode.asText().equals("jupiter")) {
                    ++this.modelCounter;
                    objectNode.put("execution_mode", ExecutionMode.V4_EMULATION_ENGINE.getLabel());
                    api.setDefinition(this.objectMapper.writeValueAsString((Object)apiDefinitionNode));
                    this.apiRepository.update(api);
                }
            }
            catch (Exception e) {
                log.error("Unable to migrate execution_mode for api {}", (Object)api.getId(), (Object)e);
            }
        });
        log.info("{} jupiter APIs have been migrated to use v4-emulation-engine execution mode", (Object)this.modelCounter);
    }
}

