/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.GroupMemberEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.ApiGroupService;
import io.gravitee.rest.api.service.v4.ApiNotificationService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiGroupServiceImpl
implements ApiGroupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiGroupServiceImpl.class);
    private final ApiRepository apiRepository;
    private final ApiNotificationService apiNotificationService;
    private final GroupService groupService;
    private final MembershipService membershipService;
    private final PrimaryOwnerService primaryOwnerService;
    private final RoleService roleService;

    public ApiGroupServiceImpl(@Lazy ApiRepository apiRepository, ApiNotificationService apiNotificationService, GroupService groupService, MembershipService membershipService, PrimaryOwnerService primaryOwnerService, RoleService roleService) {
        this.apiRepository = apiRepository;
        this.apiNotificationService = apiNotificationService;
        this.groupService = groupService;
        this.membershipService = membershipService;
        this.primaryOwnerService = primaryOwnerService;
        this.roleService = roleService;
    }

    @Override
    public void addGroup(ExecutionContext executionContext, String apiId, String group) {
        try {
            Api api;
            HashSet<String> groups;
            log.debug("Add group {} to API {}", (Object)group, (Object)apiId);
            Optional<Api> optApi = this.apiRepository.findById((Object)apiId);
            if (executionContext.hasEnvironmentId()) {
                optApi = optApi.filter(result -> result.getEnvironmentId().equals(executionContext.getEnvironmentId()));
            }
            if ((groups = (api = (Api)optApi.orElseThrow(() -> new ApiNotFoundException(apiId))).getGroups()) == null) {
                groups = new HashSet<String>();
                api.setGroups(groups);
            }
            groups.add(group);
            this.apiRepository.update((Object)api);
            this.apiNotificationService.triggerUpdateNotification(executionContext, api);
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to add group {} to API {}: {}", new Object[]{group, apiId, ex});
            throw new TechnicalManagementException("An error occurs while trying to add group " + group + " to API " + apiId, ex);
        }
    }

    @Override
    public void removeGroup(ExecutionContext executionContext, String apiId, String group) {
        try {
            Api api;
            log.debug("Remove group {} to API {}", (Object)group, (Object)apiId);
            Optional<Api> optApi = this.apiRepository.findById((Object)apiId);
            if (executionContext.hasEnvironmentId()) {
                optApi = optApi.filter(result -> result.getEnvironmentId().equals(executionContext.getEnvironmentId()));
            }
            if ((api = (Api)optApi.orElseThrow(() -> new ApiNotFoundException(apiId))).getGroups() != null && api.getGroups().remove(group)) {
                this.apiRepository.update((Object)api);
                this.apiNotificationService.triggerUpdateNotification(executionContext, api);
            }
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to remove group {} from API {}: {}", new Object[]{group, apiId, ex});
            throw new TechnicalManagementException("An error occurs while trying to remove group " + group + " from API " + apiId, ex);
        }
    }

    @Override
    public Map<String, List<GroupMemberEntity>> getGroupsWithMembers(ExecutionContext executionContext, String apiId) throws TechnicalManagementException {
        try {
            Api api = (Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            ArrayList<String> apiGroups = api.getGroups() == null ? new ArrayList<String>() : new ArrayList(api.getGroups());
            Set<MemberEntity> members = this.membershipService.getMembersByReferencesAndRole(executionContext, MembershipReferenceType.GROUP, apiGroups, null);
            return members.stream().peek(member -> member.setRoles(this.computeMemberRoles(executionContext, api, (MemberEntity)member))).collect(Collectors.groupingBy(MemberEntity::getReferenceId, Collectors.mapping(GroupMemberEntity::new, Collectors.toList())));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred while trying to retrieve groups for API " + apiId);
        }
    }

    private List<RoleEntity> computeMemberRoles(ExecutionContext executionContext, Api api, MemberEntity member) {
        return member.getRoles().stream().map(role -> role.isApiPrimaryOwner() ? this.mapApiPrimaryOwnerRole(executionContext, api, member.getReferenceId()) : role).collect(Collectors.toList());
    }

    private RoleEntity mapApiPrimaryOwnerRole(ExecutionContext executionContext, Api api, String groupId) {
        GroupEntity memberGroup = this.groupService.findById(executionContext, groupId);
        String groupDefaultApiRoleName = memberGroup.getRoles() == null ? null : (String)memberGroup.getRoles().get(RoleScope.API);
        PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext.getOrganizationId(), api.getId());
        RoleEntity role = new RoleEntity();
        role.setScope(RoleScope.API);
        if (memberGroup.getId().equals(primaryOwner.getId())) {
            role.setName(SystemRole.PRIMARY_OWNER.name());
        } else if (groupDefaultApiRoleName != null) {
            this.roleService.findByScopeAndName(RoleScope.API, groupDefaultApiRoleName, executionContext.getOrganizationId()).ifPresent(groupRole -> role.setName(groupRole.getName()));
        }
        return role;
    }
}

