/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.management.api.InstallationRepository;
import io.gravitee.repository.management.model.Installation;
import io.gravitee.rest.api.model.InstallationEntity;
import io.gravitee.rest.api.model.InstallationStatus;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.InstallationNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class InstallationServiceImpl
implements InstallationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallationServiceImpl.class);
    @Value(value="${cockpit.url:${cloud.url:https://cockpit.gravitee.io}}")
    private String cockpitURL;
    @Lazy
    @Autowired
    private InstallationRepository installationRepository;

    @Override
    public InstallationEntity get() {
        try {
            Optional optInstallation = this.installationRepository.find();
            if (optInstallation.isPresent()) {
                return this.convert((Installation)optInstallation.get());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while getting installation : {}", (Object)ex.getMessage());
            throw new TechnicalManagementException("Error while getting installation", ex);
        }
        throw new InstallationNotFoundException("");
    }

    @Override
    public synchronized InstallationEntity getOrInitialize() {
        try {
            Optional optInstallation = this.installationRepository.find();
            if (optInstallation.isPresent()) {
                return this.convert((Installation)optInstallation.get());
            }
            return this.createInstallation();
        }
        catch (Exception ex) {
            LOGGER.error("Error while getting installation : {}", (Object)ex.getMessage());
            throw new TechnicalManagementException("Error while getting installation", ex);
        }
    }

    @Override
    public InstallationEntity setAdditionalInformation(Map<String, String> additionalInformation) {
        try {
            Optional optInstallation = this.installationRepository.find();
            if (optInstallation.isPresent()) {
                Installation installation = (Installation)optInstallation.get();
                installation.setAdditionalInformation(additionalInformation);
                installation.setUpdatedAt(new Date());
                return this.convert((Installation)this.installationRepository.update((Object)installation));
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while updating installation : {}", (Object)ex.getMessage());
            throw new TechnicalManagementException("Error while updating installation", ex);
        }
        throw new InstallationNotFoundException("");
    }

    @Override
    public InstallationStatus getInstallationStatus() {
        String statusStr = (String)this.getOrInitialize().getAdditionalInformation().get("COCKPIT_INSTALLATION_STATUS");
        if (statusStr != null) {
            return InstallationStatus.valueOf((String)statusStr);
        }
        return InstallationStatus.NOT_LINKED;
    }

    private InstallationEntity createInstallation() {
        Date now = Date.from(Instant.now());
        Installation installation = new Installation();
        installation.setId(UuidString.generateRandom());
        installation.setCreatedAt(now);
        installation.setUpdatedAt(now);
        installation.setAdditionalInformation(new HashMap());
        try {
            return this.convert((Installation)this.installationRepository.create((Object)installation));
        }
        catch (Exception ex) {
            LOGGER.error("Error while creating installation : {}", (Object)ex.getMessage());
            throw new TechnicalManagementException("Error while creating installation", ex);
        }
    }

    InstallationEntity convert(Installation installation) {
        InstallationEntity result = new InstallationEntity();
        result.setId(installation.getId());
        result.setCockpitURL(this.cockpitURL);
        result.setCreatedAt(installation.getCreatedAt());
        result.setUpdatedAt(installation.getUpdatedAt());
        result.setAdditionalInformation(installation.getAdditionalInformation());
        return result;
    }
}

