/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.use_case;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.EnvironmentAuditLogEntity;
import io.gravitee.apim.core.policy.domain_service.PolicyValidationDomainService;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupCrudService;
import io.gravitee.apim.core.shared_policy_group.exception.SharedPolicyGroupDuplicateCrossIdException;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroupAuditEvent;
import io.gravitee.apim.core.shared_policy_group.model.UpdateSharedPolicyGroup;
import io.gravitee.definition.model.v4.flow.step.Step;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import java.util.Map;
import lombok.Generated;

@DomainService
public class UpdateSharedPolicyGroupUseCase {
    private final SharedPolicyGroupCrudService sharedPolicyGroupCrudService;
    private final PolicyValidationDomainService policyValidationDomainService;
    private final AuditDomainService auditService;

    public Output execute(Input input) {
        SharedPolicyGroup existingSharedPolicyGroup = this.sharedPolicyGroupCrudService.getByEnvironmentId(input.auditInfo().environmentId(), input.sharedPolicyGroupId());
        SharedPolicyGroup sharedPolicyGroupToUpdate = existingSharedPolicyGroup.update(input.sharedPolicyGroupToUpdate());
        this.validateUpdateSharedPolicyGroup(sharedPolicyGroupToUpdate, input.auditInfo().environmentId());
        SharedPolicyGroup updatedSharedPolicyGroup = this.sharedPolicyGroupCrudService.update(sharedPolicyGroupToUpdate);
        this.createAuditLog(existingSharedPolicyGroup, updatedSharedPolicyGroup, input.auditInfo());
        return new Output(updatedSharedPolicyGroup);
    }

    private void validateUpdateSharedPolicyGroup(SharedPolicyGroup sharedPolicyGroup, String environmentId) {
        if (!sharedPolicyGroup.hasName()) {
            throw new InvalidDataException("Name is required.");
        }
        this.sharedPolicyGroupCrudService.findByEnvironmentIdAndCrossId(environmentId, sharedPolicyGroup.getCrossId()).filter(spg -> !spg.getId().equals(sharedPolicyGroup.getId())).ifPresent(spg -> {
            throw new SharedPolicyGroupDuplicateCrossIdException(sharedPolicyGroup.getCrossId(), environmentId);
        });
        if (sharedPolicyGroup.getSteps() != null) {
            sharedPolicyGroup.getSteps().stream().filter(Step::isEnabled).forEach(step -> step.setConfiguration(this.policyValidationDomainService.validateAndSanitizeConfiguration(step.getPolicy(), step.getConfiguration())));
            this.policyValidationDomainService.validatePoliciesFlowPhase(sharedPolicyGroup.getSteps().stream().map(Step::getPolicy).toList(), sharedPolicyGroup.getApiType(), sharedPolicyGroup.getPhase());
        }
    }

    private void createAuditLog(SharedPolicyGroup oldSharedPolicyGroup, SharedPolicyGroup sharedPolicyGroup, AuditInfo auditInfo) {
        this.auditService.createEnvironmentAuditLog(EnvironmentAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).event(SharedPolicyGroupAuditEvent.SHARED_POLICY_GROUP_UPDATED).actor(auditInfo.actor()).oldValue(oldSharedPolicyGroup).newValue(sharedPolicyGroup).createdAt(sharedPolicyGroup.getUpdatedAt()).properties(Map.of(AuditProperties.SHARED_POLICY_GROUP, sharedPolicyGroup.getId())).build());
    }

    @Generated
    public UpdateSharedPolicyGroupUseCase(SharedPolicyGroupCrudService sharedPolicyGroupCrudService, PolicyValidationDomainService policyValidationDomainService, AuditDomainService auditService) {
        this.sharedPolicyGroupCrudService = sharedPolicyGroupCrudService;
        this.policyValidationDomainService = policyValidationDomainService;
        this.auditService = auditService;
    }

    public record Input(String sharedPolicyGroupId, UpdateSharedPolicyGroup sharedPolicyGroupToUpdate, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String sharedPolicyGroupId;
            @Generated
            private UpdateSharedPolicyGroup sharedPolicyGroupToUpdate;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder sharedPolicyGroupId(String sharedPolicyGroupId) {
                this.sharedPolicyGroupId = sharedPolicyGroupId;
                return this;
            }

            @Generated
            public InputBuilder sharedPolicyGroupToUpdate(UpdateSharedPolicyGroup sharedPolicyGroupToUpdate) {
                this.sharedPolicyGroupToUpdate = sharedPolicyGroupToUpdate;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.sharedPolicyGroupId, this.sharedPolicyGroupToUpdate, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "UpdateSharedPolicyGroupUseCase.Input.InputBuilder(sharedPolicyGroupId=" + this.sharedPolicyGroupId + ", sharedPolicyGroupToUpdate=" + this.sharedPolicyGroupToUpdate + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(SharedPolicyGroup sharedPolicyGroup) {
    }
}

