/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.group.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.definition.model.DefinitionVersion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class ValidateGroupsDomainService
implements Validator<Input> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateGroupsDomainService.class);
    private final GroupQueryService groupQueryService;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        if (CollectionUtils.isEmpty(input.groups())) {
            log.debug("no group to resolve");
            return Validator.Result.ofValue(input);
        }
        log.debug("resolving groups");
        HashSet<String> givenGroups = new HashSet<String>(input.groups());
        HashSet<String> sanitizedGroups = new HashSet<String>();
        List<Group> groupsFromIds = this.groupQueryService.findByIds(givenGroups).stream().toList();
        List<Group> groupsFromNames = this.groupQueryService.findByNames(input.environmentId(), givenGroups).stream().toList();
        Set groupIds = groupsFromIds.stream().map(Group::getId).collect(Collectors.toSet());
        Set groupNames = groupsFromNames.stream().map(Group::getName).collect(Collectors.toSet());
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        Validator.Result<List<Group>> noPrimaryOwnerResultFromIds = this.validateAndSanitizeNoPrimaryOwners(groupsFromIds, Group::getId);
        Validator.Result<List<Group>> noPrimaryOwnerResultFromNames = this.validateAndSanitizeNoPrimaryOwners(groupsFromNames, Group::getName);
        noPrimaryOwnerResultFromIds.errors().ifPresent(errors::addAll);
        noPrimaryOwnerResultFromNames.errors().ifPresent(errors::addAll);
        List sanitizedFromIds = noPrimaryOwnerResultFromIds.value().orElse(List.of());
        List sanitizedFromNames = noPrimaryOwnerResultFromNames.value().orElse(List.of());
        if (DefinitionVersion.V2.getLabel().equals(input.definitionVersion)) {
            sanitizedGroups.addAll(sanitizedFromIds.stream().map(Group::getName).toList());
            sanitizedGroups.addAll(sanitizedFromNames.stream().map(Group::getName).toList());
        } else {
            sanitizedGroups.addAll(sanitizedFromIds.stream().map(Group::getId).toList());
            sanitizedGroups.addAll(sanitizedFromNames.stream().map(Group::getId).toList());
        }
        givenGroups.removeAll(groupIds);
        givenGroups.removeAll(groupNames);
        for (String unknownGroup : givenGroups) {
            errors.add(Validator.Error.warning("Group [%s] could not be found in environment [%s]", unknownGroup, input.environmentId()));
        }
        return Validator.Result.ofBoth(input.sanitized(sanitizedGroups), errors);
    }

    private Validator.Result<List<Group>> validateAndSanitizeNoPrimaryOwners(List<Group> groups, Function<Group, String> idMapper) {
        ArrayList<Group> sanitized = new ArrayList<Group>(groups);
        List<Group> groupsWithPrimaryOwner = sanitized.stream().filter(group -> StringUtils.isNotEmpty(group.getApiPrimaryOwner())).toList();
        sanitized.removeAll(groupsWithPrimaryOwner);
        List<Validator.Error> errors = this.buildPrimaryOwnerErrors(groupsWithPrimaryOwner, idMapper);
        return Validator.Result.ofBoth(sanitized, errors);
    }

    private List<Validator.Error> buildPrimaryOwnerErrors(List<Group> groupsWithPrimaryOwner, Function<Group, String> idMapper) {
        return groupsWithPrimaryOwner.stream().map(idMapper).map(id -> Validator.Error.warning("Group [%s] will be discarded because it contains an API Primary Owner member, which is not supported with by the operator.", id)).toList();
    }

    @Generated
    public ValidateGroupsDomainService(GroupQueryService groupQueryService) {
        this.groupQueryService = groupQueryService;
    }

    public record Input(String environmentId, Set<String> groups, String definitionVersion) implements Validator.Input
    {
        Input sanitized(Set<String> sanitizedGroups) {
            return new Input(this.environmentId, sanitizedGroups, this.definitionVersion);
        }
    }
}

