/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.api;

import io.gravitee.apim.core.api.domain_service.ApiLifecycleStateDomainService;
import io.gravitee.apim.core.api.domain_service.CategoryDomainService;
import io.gravitee.apim.core.api.domain_service.GroupValidationService;
import io.gravitee.apim.core.api.domain_service.ValidateApiDomainService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.flow.domain_service.FlowValidationDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.apim.infra.adapter.PrimaryOwnerAdapter;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.v4.validation.ApiValidationService;
import io.gravitee.rest.api.service.v4.validation.EndpointGroupsValidationService;
import io.gravitee.rest.api.service.v4.validation.ListenerValidationService;
import io.gravitee.rest.api.service.v4.validation.ResourcesValidationService;
import io.gravitee.rest.api.service.v4.validation.TagsValidationService;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ValidateApiDomainServiceLegacyWrapper
implements ValidateApiDomainService {
    private final ApiValidationService apiValidationService;
    private final CategoryDomainService categoryDomainService;
    private final FlowValidationDomainService flowValidationDomainService;
    private final TagsValidationService tagsValidationService;
    private final GroupValidationService groupValidationService;
    private final ListenerValidationService listenerValidationService;
    private final EndpointGroupsValidationService endpointGroupsValidationService;
    private final ResourcesValidationService resourcesValidationService;
    private final ApiLifecycleStateDomainService apiLifecycleStateDomainService;

    @Override
    public Api validateAndSanitizeForCreation(Api api, PrimaryOwnerEntity primaryOwner, String environmentId, String organizationId) {
        if (api.getDefinitionVersion() != DefinitionVersion.V4) {
            throw new ValidationDomainException("Definition not supported, should be V4");
        }
        if (api.getType() == ApiType.NATIVE) {
            this.validateAndSanitizeNativeV4ForCreation(api, primaryOwner, environmentId, organizationId);
        } else {
            this.validateAndSanitizeHttpV4ForCreation(api, primaryOwner, environmentId, organizationId);
        }
        api.setCategories(this.categoryDomainService.toCategoryId(api, environmentId));
        return api;
    }

    @Override
    public Api validateAndSanitizeForUpdate(Api existingApi, Api apiToBeUpdated, PrimaryOwnerEntity primaryOwner, String environmentId, String organizationId) {
        if (!Objects.equals(existingApi.getEnvironmentId(), environmentId)) {
            throw new ApiNotFoundException(existingApi.getId());
        }
        if (existingApi.getDefinitionVersion() != DefinitionVersion.V4) {
            throw new ValidationDomainException("Definition not supported, should be V4");
        }
        if (existingApi.getType() != ApiType.NATIVE) {
            throw new ValidationDomainException("Only Native V4 APIs are currently supported");
        }
        return this.validateAndSanitizeNativeV4ForUpdate(existingApi, apiToBeUpdated, primaryOwner, environmentId, organizationId);
    }

    private void validateAndSanitizeHttpV4ForCreation(Api api, PrimaryOwnerEntity primaryOwner, String environmentId, String organizationId) {
        NewApiEntity newApiEntity = ApiAdapter.INSTANCE.toNewApiEntity(api);
        this.apiValidationService.validateAndSanitizeNewApi(new ExecutionContext(organizationId, environmentId), newApiEntity, PrimaryOwnerAdapter.INSTANCE.toRestEntity(primaryOwner));
        api.setName(newApiEntity.getName());
        api.setVersion(newApiEntity.getApiVersion());
        api.setType(newApiEntity.getType());
        api.setDescription(newApiEntity.getDescription());
        api.setGroups(newApiEntity.getGroups());
        api.setTags(newApiEntity.getTags());
        api.getApiDefinitionHttpV4().setListeners(newApiEntity.getListeners());
        api.getApiDefinitionHttpV4().setEndpointGroups(newApiEntity.getEndpointGroups());
        api.getApiDefinitionHttpV4().setAnalytics(newApiEntity.getAnalytics());
        api.getApiDefinitionHttpV4().setFlowExecution(newApiEntity.getFlowExecution());
        api.getApiDefinitionHttpV4().setFailover(newApiEntity.getFailover());
        api.getApiDefinitionHttpV4().setResources(this.apiValidationService.validateAndSanitize(api.getApiDefinitionHttpV4().getResources()));
        List<Flow> sanitizedFlows = this.flowValidationDomainService.validateAndSanitizeHttpV4(api.getType(), newApiEntity.getFlows());
        api.getApiDefinitionHttpV4().setFlows(sanitizedFlows);
        this.apiValidationService.validateDynamicProperties(api.getApiDefinitionHttpV4().getServices() != null ? api.getApiDefinitionHttpV4().getServices().getDynamicProperty() : null);
    }

    private void validateAndSanitizeNativeV4ForCreation(Api newApi, PrimaryOwnerEntity primaryOwner, String environmentId, String organizationId) {
        if (newApi.getType() != ApiType.NATIVE) {
            throw new ValidationDomainException("Api type not supported, should be NATIVE");
        }
        ExecutionContext executionContext = new ExecutionContext(organizationId, environmentId);
        newApi.setDescription(HtmlSanitizer.sanitize((String)newApi.getDescription()));
        newApi.setTags(this.tagsValidationService.validateAndSanitize(executionContext, null, newApi.getTags()));
        newApi.setGroups(this.groupValidationService.validateAndSanitize(Set.of(), newApi.getEnvironmentId(), primaryOwner));
        newApi.setApiDefinitionNativeV4(this.validateAndSanitizeNativeV4Definition(newApi.getApiDefinitionNativeV4(), executionContext));
    }

    private Api validateAndSanitizeNativeV4ForUpdate(Api existingApi, Api toBeUpdatedApi, PrimaryOwnerEntity primaryOwner, String environmentId, String organizationId) {
        ExecutionContext executionContext = new ExecutionContext(organizationId, environmentId);
        toBeUpdatedApi.setDescription(HtmlSanitizer.sanitize((String)toBeUpdatedApi.getDescription()));
        toBeUpdatedApi.setTags(this.tagsValidationService.validateAndSanitize(executionContext, null, toBeUpdatedApi.getTags()));
        toBeUpdatedApi.setGroups(this.groupValidationService.validateAndSanitize(toBeUpdatedApi.getGroups(), toBeUpdatedApi.getEnvironmentId(), primaryOwner));
        toBeUpdatedApi.setCategories(this.categoryDomainService.toCategoryId(toBeUpdatedApi, environmentId));
        toBeUpdatedApi.setApiLifecycleState(this.apiLifecycleStateDomainService.validateAndSanitizeForUpdate(toBeUpdatedApi.getId(), existingApi.getApiLifecycleState(), toBeUpdatedApi.getApiLifecycleState()));
        toBeUpdatedApi.setApiDefinitionNativeV4(this.validateAndSanitizeNativeV4Definition(toBeUpdatedApi.getApiDefinitionNativeV4(), executionContext));
        toBeUpdatedApi.getApiDefinitionNativeV4().setResources(this.resourcesValidationService.validateAndSanitize(toBeUpdatedApi.getApiDefinitionNativeV4().getResources()));
        return toBeUpdatedApi;
    }

    private NativeApi validateAndSanitizeNativeV4Definition(NativeApi apiDefinition, ExecutionContext executionContext) {
        apiDefinition.setListeners(this.listenerValidationService.validateAndSanitizeNativeV4(executionContext, apiDefinition.getId(), apiDefinition.getListeners(), apiDefinition.getEndpointGroups()));
        apiDefinition.setEndpointGroups(this.endpointGroupsValidationService.validateAndSanitizeNativeV4(apiDefinition.getEndpointGroups()));
        apiDefinition.setFlows(this.flowValidationDomainService.validateAndSanitizeNativeV4(apiDefinition.getFlows()));
        this.apiValidationService.validateDynamicProperties(apiDefinition.getServices() != null ? apiDefinition.getServices().getDynamicProperty() : null);
        return apiDefinition;
    }

    @Generated
    public ValidateApiDomainServiceLegacyWrapper(ApiValidationService apiValidationService, CategoryDomainService categoryDomainService, FlowValidationDomainService flowValidationDomainService, TagsValidationService tagsValidationService, GroupValidationService groupValidationService, ListenerValidationService listenerValidationService, EndpointGroupsValidationService endpointGroupsValidationService, ResourcesValidationService resourcesValidationService, ApiLifecycleStateDomainService apiLifecycleStateDomainService) {
        this.apiValidationService = apiValidationService;
        this.categoryDomainService = categoryDomainService;
        this.flowValidationDomainService = flowValidationDomainService;
        this.tagsValidationService = tagsValidationService;
        this.groupValidationService = groupValidationService;
        this.listenerValidationService = listenerValidationService;
        this.endpointGroupsValidationService = endpointGroupsValidationService;
        this.resourcesValidationService = resourcesValidationService;
        this.apiLifecycleStateDomainService = apiLifecycleStateDomainService;
    }
}

