/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateRoleEntity;
import io.gravitee.rest.api.model.permissions.EnvironmentPermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.DefaultRoleEntityDefinition;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class DefaultSharedPolicyGroupRolesUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSharedPolicyGroupRolesUpgrader.class);
    private final RoleService roleService;
    private final OrganizationRepository organizationRepository;

    @Autowired
    public DefaultSharedPolicyGroupRolesUpgrader(RoleService roleService, @Lazy OrganizationRepository organizationRepository) {
        this.roleService = roleService;
        this.organizationRepository = organizationRepository;
    }

    public boolean upgrade() {
        try {
            this.organizationRepository.findAll().forEach(organization -> {
                ExecutionContext executionContext = new ExecutionContext((Organization)organization);
                this.updateDefaultAPIPublisherRoles(executionContext, DefaultRoleEntityDefinition.ROLE_ENVIRONMENT_API_PUBLISHER.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
                this.updateDefaultAPIPublisherRoles(executionContext, DefaultRoleEntityDefinition.DEFAULT_ROLE_ENVIRONMENT_USER.getName(), new char[]{RolePermissionAction.READ.getId()});
            });
        }
        catch (Exception e) {
            log.error("failed to apply {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }

    private void updateDefaultAPIPublisherRoles(ExecutionContext executionContext, String roleName, char[] permissions) {
        Optional<RoleEntity> role = this.roleService.findByScopeAndName(RoleScope.ENVIRONMENT, roleName, executionContext.getOrganizationId());
        if (role.isEmpty()) {
            return;
        }
        UpdateRoleEntity roleToUpdate = this.convert(role.get());
        roleToUpdate.getPermissions().put(EnvironmentPermission.SHARED_POLICY_GROUP.getName(), permissions);
        log.info("Update default role {} for environment {}", (Object)roleName, (Object)executionContext.getOrganizationId());
        this.roleService.update(executionContext, roleToUpdate);
    }

    public int getOrder() {
        return 120;
    }

    private UpdateRoleEntity convert(RoleEntity roleEntity) {
        if (roleEntity == null) {
            return null;
        }
        UpdateRoleEntity role = new UpdateRoleEntity();
        role.setId(roleEntity.getId());
        role.setName(roleEntity.getName());
        role.setDescription(roleEntity.getDescription());
        role.setScope(roleEntity.getScope());
        role.setDefaultRole(roleEntity.isDefaultRole());
        role.setPermissions(roleEntity.getPermissions());
        return role;
    }
}

