/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.MembershipDuplicateService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class MembershipDuplicateServiceImpl
implements MembershipDuplicateService {
    private final RoleService roleService;
    private final MembershipService membershipService;

    public MembershipDuplicateServiceImpl(RoleService roleService, MembershipService membershipService) {
        this.roleService = roleService;
        this.membershipService = membershipService;
    }

    @Override
    public List<MemberEntity> duplicateMemberships(ExecutionContext executionContext, String sourceApiId, String duplicatedApiId, String userId) {
        RoleEntity primaryOwnerRole = this.roleService.findPrimaryOwnerRoleByOrganization(executionContext.getOrganizationId(), RoleScope.API);
        if (primaryOwnerRole == null) {
            return List.of();
        }
        List<RoleEntity> defaultRoles = this.roleService.findDefaultRoleByScopes(executionContext.getOrganizationId(), RoleScope.API);
        if (defaultRoles == null || defaultRoles.isEmpty()) {
            throw new IllegalStateException("No default role defined for API scope");
        }
        RoleEntity defaultRole = defaultRoles.get(0);
        return this.membershipService.getMembershipsByReference(MembershipReferenceType.API, sourceApiId).stream().filter(m -> !m.getMemberId().equals(userId)).map(m -> {
            String roleId = m.getRoleId();
            if (roleId.equals(primaryOwnerRole.getId())) {
                roleId = defaultRole.getId();
            }
            return this.membershipService.addRoleToMemberOnReference(executionContext, MembershipReferenceType.API, duplicatedApiId, m.getMemberType(), m.getMemberId(), roleId);
        }).toList();
    }
}

