/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.common.utils.IdGenerator;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.model.AccessControlReferenceType;
import io.gravitee.rest.api.model.BasePlanEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.ImportPageEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewGroupEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.DuplicateApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiIdsCalculatorService;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipDuplicateService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PageDuplicateService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.converter.CategoryMapper;
import io.gravitee.rest.api.service.converter.PlanConverter;
import io.gravitee.rest.api.service.exceptions.ApiDefinitionVersionNotSupportedException;
import io.gravitee.rest.api.service.exceptions.ApiImportException;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.imports.ImportApiJsonNode;
import io.gravitee.rest.api.service.imports.ImportJsonNode;
import io.gravitee.rest.api.service.imports.ImportJsonNodeWithIds;
import io.gravitee.rest.api.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.rest.api.service.spring.ImportConfiguration;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minidev.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiDuplicatorServiceImpl
extends AbstractService
implements ApiDuplicatorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiDuplicatorServiceImpl.class);
    public static final String API_DEFINITION_FIELD_GROUPS = "groups";
    public static final String API_DEFINITION_FIELD_PLANS = "plans";
    public static final String API_DEFINITION_FIELD_MEMBERS = "members";
    public static final String API_DEFINITION_FIELD_PAGES = "pages";
    private final HttpClientService httpClientService;
    private final ImportConfiguration importConfiguration;
    private final MediaService mediaService;
    private final ObjectMapper objectMapper;
    private final ApiMetadataService apiMetadataService;
    private final MembershipService membershipService;
    private final MembershipDuplicateService membershipDuplicateService;
    private final RoleService roleService;
    private final PageService pageService;
    private final PageDuplicateService pageDuplicateService;
    private final PlanService planService;
    private final GroupService groupService;
    private final UserService userService;
    private final ApiService apiService;
    private final ApiConverter apiConverter;
    private final PlanConverter planConverter;
    private final PermissionService permissionService;
    private final ApiIdsCalculatorService apiIdsCalculatorService;
    private final CategoryMapper categoryMapper;

    public ApiDuplicatorServiceImpl(HttpClientService httpClientService, ImportConfiguration importConfiguration, MediaService mediaService, ObjectMapper objectMapper, ApiMetadataService apiMetadataService, MembershipService membershipService, MembershipDuplicateService membershipDuplicateService, RoleService roleService, PageService pageService, PageDuplicateService pageDuplicateService, PlanService planService, GroupService groupService, UserService userService, @Lazy ApiService apiService, ApiConverter apiConverter, PlanConverter planConverter, PermissionService permissionService, ApiIdsCalculatorService apiIdsCalculatorService, CategoryMapper categoryMapper) {
        this.httpClientService = httpClientService;
        this.importConfiguration = importConfiguration;
        this.mediaService = mediaService;
        this.objectMapper = objectMapper;
        this.apiMetadataService = apiMetadataService;
        this.membershipService = membershipService;
        this.membershipDuplicateService = membershipDuplicateService;
        this.roleService = roleService;
        this.pageService = pageService;
        this.pageDuplicateService = pageDuplicateService;
        this.planService = planService;
        this.groupService = groupService;
        this.userService = userService;
        this.apiService = apiService;
        this.apiConverter = apiConverter;
        this.planConverter = planConverter;
        this.permissionService = permissionService;
        this.apiIdsCalculatorService = apiIdsCalculatorService;
        this.categoryMapper = categoryMapper;
    }

    @Override
    public ApiEntity createWithImportedDefinition(ExecutionContext executionContext, Object apiDefinitionOrURL) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            ImportApiJsonNode apiJsonNode = this.apiIdsCalculatorService.recalculateApiDefinitionIds(executionContext, new ImportApiJsonNode(this.objectMapper.readTree(apiDefinition)));
            this.checkApiJsonConsistency(apiJsonNode);
            UpdateApiEntity importedApi = this.convertToEntity(executionContext, apiJsonNode.toString(), apiJsonNode);
            ApiEntity createdApiEntity = this.apiService.createWithApiDefinition(executionContext, importedApi, this.getAuthenticatedUsername(), apiJsonNode.getJsonNode());
            this.createOrUpdateApiNestedEntities(executionContext, createdApiEntity, apiJsonNode);
            if (!createdApiEntity.getDefinitionContext().isOriginKubernetes()) {
                this.createPageAndMedia(executionContext, createdApiEntity, apiJsonNode);
            }
            return createdApiEntity;
        }
        catch (IOException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    @Override
    public ApiEntity updateWithImportedDefinition(ExecutionContext executionContext, String urlApiId, Object apiDefinitionOrURL) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            ImportApiJsonNode apiJsonNode = this.apiIdsCalculatorService.recalculateApiDefinitionIds(executionContext, new ImportApiJsonNode(this.objectMapper.readTree(apiDefinition)), urlApiId);
            UpdateApiEntity importedApi = this.convertToEntity(executionContext, apiJsonNode.toString(), apiJsonNode);
            if (DefinitionVersion.V1.equals((Object)DefinitionVersion.valueOfLabel((String)importedApi.getGraviteeDefinitionVersion()))) {
                throw new ApiDefinitionVersionNotSupportedException(importedApi.getGraviteeDefinitionVersion());
            }
            if (!this.isAuthenticated() || !this.isEnvironmentAdmin() && !this.permissionService.hasPermission(executionContext, RolePermission.API_DEFINITION, apiJsonNode.getId(), RolePermissionAction.UPDATE)) {
                throw new ForbiddenAccessException();
            }
            this.checkApiJsonConsistency(executionContext, apiJsonNode, urlApiId);
            ApiEntity updatedApiEntity = this.apiService.update(executionContext, apiJsonNode.getId(), importedApi);
            this.createOrUpdateApiNestedEntities(executionContext, updatedApiEntity, apiJsonNode);
            return updatedApiEntity;
        }
        catch (IOException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    @Override
    public ApiEntity duplicate(ExecutionContext executionContext, ApiEntity apiEntity, DuplicateApiEntity duplicateApiEntity) {
        Objects.requireNonNull(apiEntity, "Missing ApiEntity");
        String apiId = apiEntity.getId();
        LOGGER.debug("Duplicate API {}", (Object)apiId);
        UpdateApiEntity newApiEntity = this.apiConverter.toUpdateApiEntity(apiEntity, true);
        Proxy proxy = apiEntity.getProxy();
        proxy.setVirtualHosts(Collections.singletonList(new VirtualHost(duplicateApiEntity.getContextPath())));
        newApiEntity.setProxy(proxy);
        newApiEntity.setVersion(duplicateApiEntity.getVersion() == null ? apiEntity.getVersion() : duplicateApiEntity.getVersion());
        if (duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_GROUPS)) {
            newApiEntity.setGroups(null);
        } else {
            newApiEntity.setGroups(apiEntity.getGroups());
        }
        HashMap plansIdsMap = new HashMap();
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PLANS)) {
            newApiEntity.getPlans().forEach(plan -> {
                String newPlanId = UuidString.generateRandom();
                plansIdsMap.put(plan.getId(), newPlanId);
                plan.setId(newPlanId);
            });
        }
        ApiEntity duplicatedApi = this.apiService.createWithApiDefinition(executionContext, newApiEntity, this.getAuthenticatedUsername(), null);
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_MEMBERS)) {
            this.membershipDuplicateService.duplicateMemberships(executionContext, apiId, duplicatedApi.getId(), this.getAuthenticatedUsername());
        }
        HashMap<String, String> pagesIdsMap = new HashMap<String, String>();
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PAGES)) {
            pagesIdsMap.putAll(this.pageDuplicateService.duplicatePages(executionContext, apiId, duplicatedApi.getId(), this.getAuthenticatedUsername()));
        }
        if (!duplicateApiEntity.getFilteredFields().contains(API_DEFINITION_FIELD_PLANS)) {
            this.planService.findByApi(executionContext, apiId).forEach(plan -> {
                plan.setId((String)plansIdsMap.get(plan.getId()));
                plan.setApi(duplicatedApi.getId());
                if (plan.getGeneralConditions() != null) {
                    plan.setGeneralConditions((String)pagesIdsMap.get(plan.getGeneralConditions()));
                }
                this.planService.create(executionContext, this.planConverter.toNewPlanEntity((PlanEntity)plan, true));
            });
        }
        return duplicatedApi;
    }

    private UpdateApiEntity convertToEntity(ExecutionContext executionContext, String apiDefinition, ImportApiJsonNode apiJsonNode) throws IOException {
        Set<Object> categories;
        UpdateApiEntity importedApi = (UpdateApiEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(apiDefinition, UpdateApiEntity.class);
        if (Objects.equals(importedApi.getGraviteeDefinitionVersion(), DefinitionVersion.V1.getLabel()) && (importedApi.getPaths() == null || importedApi.getPaths().isEmpty())) {
            importedApi.setPaths(Collections.singletonMap("/", new ArrayList()));
        }
        if (importedApi.getGroups() != null) {
            HashSet groupNames = new HashSet(importedApi.getGroups());
            importedApi.getGroups().clear();
            for (String name : groupNames) {
                GroupEntity group;
                List<GroupEntity> groupEntities = this.groupService.findByName(executionContext.getEnvironmentId(), name);
                if (groupEntities.isEmpty()) {
                    NewGroupEntity newGroupEntity = new NewGroupEntity();
                    newGroupEntity.setName(name);
                    group = this.groupService.create(executionContext, newGroupEntity);
                } else {
                    group = groupEntities.get(0);
                }
                importedApi.getGroups().add(group.getId());
            }
        } else {
            importedApi.setGroups(new HashSet());
        }
        List<ImportJsonNode> viewsNodes = apiJsonNode.getViews();
        if (!viewsNodes.isEmpty()) {
            categories = viewsNodes.stream().map(ImportJsonNode::asText).collect(Collectors.toSet());
            importedApi.setCategories(categories);
        }
        if (apiJsonNode.isKubernetesOrigin()) {
            categories = this.cleanDefinitionCategories(executionContext.getEnvironmentId(), apiJsonNode);
            importedApi.setCategories(categories);
        }
        Map<String, PlanEntity> existingPlans = this.readApiPlansById(executionContext, apiJsonNode.getId());
        importedApi.setPlans(this.readPlansToImportFromDefinition(apiJsonNode, existingPlans));
        return importedApi;
    }

    protected Set<String> cleanDefinitionCategories(String environmentId, ImportApiJsonNode apiNode) {
        if (!apiNode.hasCategories() || apiNode.getCategoriesArray().isEmpty()) {
            return Set.of();
        }
        ArrayNode categoriesNode = apiNode.getCategoriesArray();
        HashSet<String> categories = new HashSet<String>();
        if (apiNode.isKubernetesOrigin()) {
            categoriesNode.forEach(category -> categories.add(IdGenerator.generate((String)category.asText())));
        } else {
            categoriesNode.forEach(category -> categories.add(category.asText()));
        }
        return this.categoryMapper.toCategoryId(environmentId, categories);
    }

    private void createPageAndMedia(ExecutionContext executionContext, ApiEntity createdApiEntity, ImportApiJsonNode apiJsonNode) throws JsonProcessingException {
        for (ImportJsonNode media : apiJsonNode.getMedia()) {
            this.mediaService.createWithDefinition(executionContext, createdApiEntity.getId(), media.toString());
        }
        List<PageEntity> search = this.pageService.search(executionContext.getEnvironmentId(), new PageQuery.Builder().api(createdApiEntity.getId()).name(SystemFolderType.ASIDE.folderName()).type(PageType.SYSTEM_FOLDER).build());
        if (search.isEmpty()) {
            this.pageService.createAsideFolder(executionContext, createdApiEntity.getId());
        }
    }

    private String fetchApiDefinitionContentFromURL(Object apiDefinitionOrURL) {
        String definitionOrURL = ApiDuplicatorServiceImpl.stringifyApiDefinitionFromJackson(apiDefinitionOrURL);
        if (definitionOrURL.toUpperCase().startsWith("HTTP")) {
            UrlSanitizerUtils.checkAllowed(definitionOrURL, this.importConfiguration.getImportWhitelist(), this.importConfiguration.isAllowImportFromPrivate());
            Buffer buffer = this.httpClientService.request(HttpMethod.GET, definitionOrURL, null, null, null);
            return buffer.toString();
        }
        return definitionOrURL;
    }

    private void createOrUpdateApiNestedEntities(ExecutionContext executionContext, ApiEntity apiEntity, ImportApiJsonNode apiJsonNode) throws IOException {
        this.createOrUpdateMembers(executionContext, apiEntity, apiJsonNode);
        this.createOrUpdatePages(executionContext, apiEntity, apiJsonNode);
        this.createOrUpdatePlans(executionContext, apiEntity, apiJsonNode);
        this.createOrUpdateMetadata(executionContext, apiEntity, apiJsonNode);
    }

    private void createOrUpdateMembers(ExecutionContext executionContext, ApiEntity apiEntity, ImportApiJsonNode apiJsonNode) throws JsonProcessingException {
        Set<MemberToImport> membersAlreadyPresent;
        if (apiJsonNode.hasMembers()) {
            Set<MemberToImport> membersAlreadyPresent2 = this.getAPICurrentMembers(executionContext, apiEntity.getId());
            RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(executionContext.getOrganizationId(), RoleScope.API);
            assert (poRole != null);
            String poRoleId = poRole.getId();
            MemberToImport currentPo = membersAlreadyPresent2.stream().filter(memberToImport -> memberToImport.getRoles().contains(poRoleId)).findFirst().orElse(new MemberToImport());
            List<String> roleUsedInTransfert = null;
            MemberToImport futurePo = null;
            Optional<RoleEntity> apiUserRoleOpt = this.roleService.findByScopeAndName(RoleScope.API, "USER", executionContext.getOrganizationId());
            for (ImportJsonNode memberNode : apiJsonNode.getMembers()) {
                MemberToImport memberToImport2 = (MemberToImport)this.objectMapper.readValue(memberNode.toString(), MemberToImport.class);
                memberToImport2.setRoles(this.getRoleIdsToImport(executionContext, memberToImport2));
                boolean presentWithSameRole = this.isPresentWithSameRole(membersAlreadyPresent2, memberToImport2);
                List<String> roleIdsToImport = memberToImport2.getRoles().stream().filter(roleId -> {
                    boolean isValidRole;
                    Optional<RoleEntity> role = this.roleService.findByIdAndOrganizationId((String)roleId, executionContext.getOrganizationId());
                    boolean bl = isValidRole = role.isPresent() && RoleScope.API.equals((Object)role.get().getScope());
                    if (!isValidRole) {
                        LOGGER.warn("Role {} does not exist in organization {} or is not an API role", roleId, (Object)executionContext.getOrganizationId());
                    }
                    return isValidRole;
                }).collect(Collectors.toList());
                if (roleIdsToImport.isEmpty() && apiUserRoleOpt.isPresent()) {
                    roleIdsToImport.add(apiUserRoleOpt.get().getId());
                }
                this.addOrUpdateMembers(executionContext, apiEntity.getId(), poRoleId, currentPo, memberToImport2, roleIdsToImport, presentWithSameRole);
                if (memberToImport2.getSourceId().equals(currentPo.getSourceId()) && memberToImport2.getSource().equals(currentPo.getSource()) && !roleIdsToImport.contains(poRoleId)) {
                    roleUsedInTransfert = roleIdsToImport;
                }
                if (roleIdsToImport.contains(poRoleId)) {
                    futurePo = memberToImport2;
                }
                if (!apiJsonNode.isKubernetesOrigin()) continue;
                this.removePreviousRoleIfExist(executionContext, apiEntity.getId(), memberToImport2, roleIdsToImport);
                membersAlreadyPresent2.remove(memberToImport2);
            }
            if (apiJsonNode.isKubernetesOrigin()) {
                for (MemberToImport memberToDelete : membersAlreadyPresent2) {
                    if (memberToDelete.getRoles().contains(poRoleId)) continue;
                    this.deleteMembers(executionContext, apiEntity.getId(), memberToDelete);
                }
            }
            this.transferOwnership(executionContext, apiEntity.getId(), currentPo, roleUsedInTransfert, futurePo);
        } else if (!apiJsonNode.hasMembers() && apiJsonNode.isKubernetesOrigin() && !(membersAlreadyPresent = this.getAPICurrentMembers(executionContext, apiEntity.getId())).isEmpty()) {
            RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(executionContext.getOrganizationId(), RoleScope.API);
            assert (poRole != null);
            String poRoleId = poRole.getId();
            for (MemberToImport memberToDelete : membersAlreadyPresent) {
                if (memberToDelete.getRoles().contains(poRoleId)) continue;
                this.deleteMembers(executionContext, apiEntity.getId(), memberToDelete);
            }
        }
    }

    @NotNull
    protected Set<MemberToImport> getAPICurrentMembers(ExecutionContext executionContext, String apiId) {
        return this.membershipService.getMembersByReference(executionContext, MembershipReferenceType.API, apiId).stream().filter(member -> member.getType() == MembershipMemberType.USER).map(member -> {
            UserEntity userEntity = this.userService.findById(executionContext, member.getId());
            return new MemberToImport(userEntity.getSource(), userEntity.getSourceId(), member.getRoles().stream().map(RoleEntity::getId).collect(Collectors.toList()), null);
        }).collect(Collectors.toSet());
    }

    protected boolean isPresentWithSameRole(Set<MemberToImport> membersAlreadyPresent, MemberToImport memberToImport) {
        return memberToImport.getRoles() != null && !memberToImport.getRoles().isEmpty() && membersAlreadyPresent.stream().anyMatch(m -> {
            m.getRoles().sort(Comparator.naturalOrder());
            return m.getRoles().equals(memberToImport.getRoles()) && m.getSourceId().equals(memberToImport.getSourceId()) && m.getSource().equals(memberToImport.getSource());
        });
    }

    protected List<String> getRoleIdsToImport(ExecutionContext executionContext, MemberToImport memberToImport) {
        List<String> roleIdsToImport = memberToImport.getRoles();
        roleIdsToImport = roleIdsToImport == null ? new ArrayList<String>() : new ArrayList<String>(roleIdsToImport);
        String roleIdOrName = memberToImport.getRole();
        if (roleIdOrName != null && !roleIdOrName.isEmpty()) {
            try {
                UUID.fromString(roleIdOrName);
                roleIdsToImport.add(roleIdOrName);
            }
            catch (IllegalArgumentException e) {
                Optional<RoleEntity> optRoleToAddEntity = this.roleService.findByScopeAndName(RoleScope.API, roleIdOrName, executionContext.getOrganizationId());
                if (optRoleToAddEntity.isPresent()) {
                    roleIdsToImport.add(optRoleToAddEntity.get().getId());
                }
                LOGGER.warn("Role {} does not exist", (Object)roleIdOrName);
                roleIdsToImport.add(roleIdOrName);
            }
        }
        roleIdsToImport.sort(Comparator.naturalOrder());
        return roleIdsToImport;
    }

    protected void addOrUpdateMembers(ExecutionContext executionContext, String apiId, String poRoleId, MemberToImport currentPo, MemberToImport memberToImport, List<String> rolesToImport, boolean presentWithSameRole) {
        if (!(presentWithSameRole || memberToImport.getRoles() == null || memberToImport.getRoles().isEmpty() || memberToImport.getRoles().contains(poRoleId) || memberToImport.getSourceId().equals(currentPo.getSourceId()) && memberToImport.getSource().equals(currentPo.getSource()))) {
            try {
                UserEntity userEntity = this.userService.findBySource(executionContext.getOrganizationId(), memberToImport.getSource(), memberToImport.getSourceId(), false);
                rolesToImport.forEach(role -> {
                    try {
                        this.membershipService.addRoleToMemberOnReference(executionContext, MembershipReferenceType.API, apiId, MembershipMemberType.USER, userEntity.getId(), (String)role);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to add role '{}' to member '{}' on API '{}' due to : {}", new Object[]{role, userEntity.getId(), apiId, e.getMessage()});
                    }
                });
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
    }

    private void removePreviousRoleIfExist(ExecutionContext executionContext, String apiId, MemberToImport memberToImport, List<String> roleIdsToImport) {
        UserEntity userEntity = this.userService.findBySource(executionContext.getOrganizationId(), memberToImport.getSource(), memberToImport.getSourceId(), false);
        ArrayList<String> existingRoles = new ArrayList<String>(this.membershipService.getRoles(MembershipReferenceType.API, apiId, MembershipMemberType.USER, userEntity.getId()).stream().map(RoleEntity::getId).toList());
        roleIdsToImport.forEach(existingRoles::remove);
        existingRoles.forEach(roleId -> this.membershipService.removeRole(MembershipReferenceType.API, apiId, MembershipMemberType.USER, userEntity.getId(), (String)roleId));
    }

    protected void deleteMembers(ExecutionContext executionContext, String apiId, MemberToImport memberToImport) {
        try {
            UserEntity userEntity = this.userService.findBySource(executionContext.getOrganizationId(), memberToImport.getSource(), memberToImport.getSourceId(), false);
            this.membershipService.deleteMemberForApi(executionContext, apiId, userEntity.getId());
        }
        catch (UserNotFoundException userEntity) {
        }
        catch (Exception e) {
            LOGGER.warn("Unable to delete membership from API '{}' due to : {}", (Object)apiId, (Object)e.getMessage());
        }
    }

    private void transferOwnership(ExecutionContext executionContext, String apiId, MemberToImport currentPo, List<String> roleUsedInTransfert, MemberToImport futurePo) {
        if (!(futurePo == null || futurePo.getSource().equals(currentPo.getSource()) && futurePo.getSourceId().equals(currentPo.getSourceId()))) {
            try {
                UserEntity userEntity = this.userService.findBySource(executionContext.getOrganizationId(), futurePo.getSource(), futurePo.getSourceId(), false);
                List<RoleEntity> roleEntity = null;
                if (roleUsedInTransfert != null && !roleUsedInTransfert.isEmpty()) {
                    roleEntity = roleUsedInTransfert.stream().map(this.roleService::findById).toList();
                }
                this.membershipService.transferApiOwnership(executionContext, apiId, new MembershipService.MembershipMember(userEntity.getId(), null, MembershipMemberType.USER), roleEntity);
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
    }

    protected void createOrUpdateMetadata(ExecutionContext executionContext, ApiEntity apiEntity, ImportApiJsonNode apiJsonNode) {
        try {
            for (ImportJsonNode metadataNode : apiJsonNode.getMetadata()) {
                UpdateApiMetadataEntity updateApiMetadataEntity = (UpdateApiMetadataEntity)this.objectMapper.readValue(metadataNode.toString(), UpdateApiMetadataEntity.class);
                updateApiMetadataEntity.setApiId(apiEntity.getId());
                this.apiMetadataService.update(executionContext, updateApiMetadataEntity);
            }
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while creating API metadata", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while creating API Metadata", ex);
        }
    }

    protected void createOrUpdatePlans(ExecutionContext executionContext, ApiEntity apiEntity, ImportApiJsonNode apiJsonNode) throws IOException {
        if (apiJsonNode.hasPlans()) {
            Map<String, PlanEntity> existingPlans = this.readApiPlansById(executionContext, apiEntity.getId());
            Set<PlanEntity> plansToImport = this.readPlansToImportFromDefinition(apiJsonNode, existingPlans);
            this.findRemovedPlans(existingPlans.values(), plansToImport).forEach(plan -> {
                this.planService.delete(executionContext, plan.getId());
                apiEntity.getPlans().remove(plan);
            });
            plansToImport.forEach(planEntity -> {
                planEntity.setApi(apiEntity.getId());
                this.replacePlanGroupNameById(executionContext, apiEntity, (PlanEntity)planEntity);
                this.planService.createOrUpdatePlan(executionContext, (PlanEntity)planEntity);
                apiEntity.getPlans().add(planEntity);
            });
        }
    }

    private void replacePlanGroupNameById(ExecutionContext executionContext, ApiEntity apiEntity, PlanEntity planEntity) {
        if (apiEntity.getGroups() != null && planEntity.getExcludedGroups() != null) {
            HashSet groupNames = new HashSet(planEntity.getExcludedGroups());
            planEntity.getExcludedGroups().clear();
            for (String name : groupNames) {
                List<GroupEntity> groupEntities = this.groupService.findByName(executionContext.getEnvironmentId(), name);
                if (!groupEntities.isEmpty()) {
                    GroupEntity group = groupEntities.get(0);
                    planEntity.getExcludedGroups().add(group.getId());
                    continue;
                }
                LOGGER.warn("Group with name {} does not exist and can't be added to plan \"{}\" [{}]", new Object[]{name, planEntity.getName(), planEntity.getId()});
            }
        }
    }

    private Map<String, PlanEntity> readApiPlansById(ExecutionContext executionContext, String apiId) {
        return this.planService.findByApi(executionContext, apiId).stream().collect(Collectors.toMap(BasePlanEntity::getId, Function.identity()));
    }

    protected void createOrUpdatePages(ExecutionContext executionContext, ApiEntity apiEntity, ImportApiJsonNode apiJsonNode) throws JsonProcessingException {
        if (apiJsonNode.hasPages() && !apiJsonNode.getPages().isEmpty()) {
            List pagesList = (List)this.objectMapper.readValue(apiJsonNode.getPages().toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, PageEntity.class));
            this.replacePagesGroupNameById(executionContext, pagesList);
            if (apiJsonNode.isKubernetesOrigin()) {
                this.importKubernetesPages(executionContext, apiEntity.getId(), pagesList);
            } else {
                this.pageService.createOrUpdatePages(executionContext, pagesList, apiEntity.getId());
            }
        } else if (apiJsonNode.isKubernetesOrigin()) {
            this.pageService.deleteAllByApi(executionContext, apiEntity.getId());
        }
    }

    private void importKubernetesPages(ExecutionContext executionContext, String apiId, List<PageEntity> pages) {
        this.deleteRemovedPages(executionContext, apiId, pages);
        List<PageEntity> rootPages = pages.stream().filter(PageEntity::isRoot).toList();
        this.importKubernetesRootPages(executionContext, apiId, rootPages);
        pages.removeAll(rootPages);
        this.pageService.createOrUpdatePages(executionContext, pages, apiId);
    }

    private void importKubernetesRootPages(ExecutionContext executionContext, String apiId, List<PageEntity> rootPages) {
        for (PageEntity rootPage : rootPages) {
            this.overrideAccessControls(executionContext, apiId, rootPage, this.pageService.importFiles(executionContext, apiId, ImportPageEntity.builder().type(PageType.ROOT).visibility(rootPage.getVisibility()).published(rootPage.isPublished()).source(rootPage.getSource()).build()));
        }
    }

    private void overrideAccessControls(ExecutionContext executionContext, String apiId, PageEntity rootPage, List<PageEntity> importedPages) {
        this.pageService.createOrUpdatePages(executionContext, importedPages.stream().map(page -> page.toBuilder().visibility(rootPage.getVisibility()).accessControls(rootPage.getAccessControls()).excludedGroups(rootPage.getExcludedGroups()).excludedAccessControls(rootPage.isExcludedAccessControls()).build()).toList(), apiId);
    }

    private void deleteRemovedPages(ExecutionContext executionContext, String apiId, List<PageEntity> givenPages) {
        Set givenPageIds = givenPages.stream().map(PageEntity::getId).collect(Collectors.toSet());
        List<PageEntity> existingPages = this.pageService.findByApi(executionContext.getEnvironmentId(), apiId);
        if (existingPages.size() > 1) {
            existingPages.sort((p0, p1) -> {
                Integer r1;
                Integer r0 = PageType.valueOf((String)p0.getType()).getRemoveOrder();
                if (r0.equals(r1 = PageType.valueOf((String)p1.getType()).getRemoveOrder())) {
                    return Integer.compare(p1.getOrder(), p0.getOrder());
                }
                return r0.compareTo(r1);
            });
        }
        List existingPageIds = existingPages.stream().map(PageEntity::getId).collect(Collectors.toList());
        existingPageIds.removeIf(givenPageIds::contains);
        try {
            for (String id : existingPageIds) {
                this.pageService.delete(executionContext, id);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("An error as occurred while trying to remove a page with kubernetes origin");
        }
    }

    private void replacePagesGroupNameById(ExecutionContext executionContext, List<PageEntity> pagesList) {
        HashMap pageGroupEntities = new HashMap();
        pagesList.forEach(pageEntity -> {
            if (pageEntity.getAccessControls() != null) {
                pageEntity.setAccessControls(pageEntity.getAccessControls().stream().filter(accessControlEntity -> accessControlEntity.getReferenceType().equals(AccessControlReferenceType.GROUP.name())).peek(accessControlEntity -> {
                    String groupId = pageGroupEntities.computeIfAbsent(accessControlEntity.getReferenceId(), key -> {
                        List<GroupEntity> groupEntities = this.groupService.findByName(executionContext.getEnvironmentId(), (String)key);
                        if (!groupEntities.isEmpty()) {
                            return groupEntities.get(0).getId();
                        }
                        LOGGER.warn("Group with name {} does not exist and can't be added to access control list of page \"{}\" [{}]", new Object[]{accessControlEntity.getReferenceId(), pageEntity.getName(), pageEntity.getId()});
                        return null;
                    });
                    if (groupId != null) {
                        accessControlEntity.setReferenceId(groupId);
                    }
                }).collect(Collectors.toSet()));
            }
        });
    }

    private Stream<PlanEntity> findRemovedPlans(Collection<PlanEntity> existingPlans, Collection<PlanEntity> importedPlans) {
        return existingPlans.stream().filter(existingPlan -> !importedPlans.contains(existingPlan));
    }

    private Set<PlanEntity> readPlansToImportFromDefinition(ImportApiJsonNode apiJsonNode, Map<String, PlanEntity> existingPlans) throws IOException {
        HashSet<PlanEntity> plansToImport = new HashSet<PlanEntity>();
        for (ImportJsonNodeWithIds importJsonNodeWithIds : apiJsonNode.getPlans()) {
            PlanEntity existingPlan;
            PlanEntity planEntity = existingPlan = importJsonNodeWithIds.hasId() ? existingPlans.get(importJsonNodeWithIds.getId()) : null;
            if (existingPlan != null) {
                plansToImport.add((PlanEntity)this.objectMapper.readerForUpdating((Object)existingPlan).readValue(importJsonNodeWithIds.getJsonNode()));
                continue;
            }
            plansToImport.add((PlanEntity)this.objectMapper.readValue(importJsonNodeWithIds.toString(), PlanEntity.class));
        }
        return plansToImport;
    }

    private void checkApiJsonConsistency(ExecutionContext executionContext, ImportApiJsonNode apiJsonNode, String urlApiId) {
        if (urlApiId != null && !urlApiId.equals(apiJsonNode.getId())) {
            throw new ApiImportException(String.format("Can't update API [%s] cause crossId [%s] already belongs to another API in environment [%s]", urlApiId, apiJsonNode.getCrossId(), executionContext.getEnvironmentId()));
        }
        this.checkApiJsonConsistency(apiJsonNode);
    }

    private void checkApiJsonConsistency(ImportApiJsonNode apiJsonNode) {
        this.checkPagesConsistency(apiJsonNode);
        this.checkPlansConsistency(apiJsonNode);
    }

    private void checkPlansConsistency(ImportApiJsonNode apiJsonNode) {
        List<String> planIds;
        if (apiJsonNode.hasPlans() && this.planService.anyPlanMismatchWithApi(planIds = apiJsonNode.getPlans().stream().map(ImportJsonNodeWithIds::getId).collect(Collectors.toList()), apiJsonNode.getId())) {
            throw new ApiImportException("Some inconsistencies were found in the API plans definition");
        }
    }

    private void checkPagesConsistency(ImportApiJsonNode apiJsonNode) {
        long systemFoldersCount;
        if (apiJsonNode.hasPages() && (systemFoldersCount = apiJsonNode.getPagesArray().findValuesAsText("type").stream().filter(type -> PageType.SYSTEM_FOLDER.name().equals(type)).count()) > 1L) {
            throw new ApiImportException("Only one system folder is allowed in the API pages definition");
        }
    }

    private static String stringifyApiDefinitionFromJackson(Object apiDefinitionOrUrl) {
        return apiDefinitionOrUrl instanceof Map ? new JSONObject((Map)apiDefinitionOrUrl).toString() : apiDefinitionOrUrl.toString();
    }

    protected static class MemberToImport {
        private String source;
        private String sourceId;
        private List<String> roles;
        private String role;

        public MemberToImport() {
        }

        public MemberToImport(String source, String sourceId, List<String> roles, String role) {
            this.source = source;
            this.sourceId = sourceId;
            this.roles = roles;
            this.role = role;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberToImport that = (MemberToImport)o;
            return this.source.equals(that.source) && this.sourceId.equals(that.sourceId);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.sourceId.hashCode();
            return result;
        }
    }
}

