/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.subscription.model.SubscriptionConfiguration;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.apim.infra.adapter.SubscriptionAdapter;
import io.gravitee.repository.management.model.Subscription;
import io.gravitee.rest.api.model.SubscriptionConfigurationEntity;
import io.gravitee.rest.api.model.SubscriptionConsumerStatus;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionAdapterImpl
extends SubscriptionAdapter {
    @Override
    public SubscriptionEntity toEntity(Subscription subscription) {
        if (subscription == null) {
            return null;
        }
        SubscriptionEntity.SubscriptionEntityBuilder subscriptionEntity = SubscriptionEntity.builder();
        subscriptionEntity.apiId(subscription.getApi());
        subscriptionEntity.planId(subscription.getPlan());
        subscriptionEntity.applicationId(subscription.getApplication());
        subscriptionEntity.requestMessage(subscription.getRequest());
        subscriptionEntity.reasonMessage(subscription.getReason());
        subscriptionEntity.id(subscription.getId());
        subscriptionEntity.environmentId(subscription.getEnvironmentId());
        subscriptionEntity.clientId(subscription.getClientId());
        subscriptionEntity.clientCertificate(subscription.getClientCertificate());
        if (subscription.getProcessedAt() != null) {
            subscriptionEntity.processedAt(ZonedDateTime.ofInstant(subscription.getProcessedAt().toInstant(), ZoneId.systemDefault()));
        }
        subscriptionEntity.status(this.statusToStatus(subscription.getStatus()));
        subscriptionEntity.consumerStatus(this.consumerStatusToConsumerStatus(subscription.getConsumerStatus()));
        subscriptionEntity.processedBy(subscription.getProcessedBy());
        subscriptionEntity.subscribedBy(subscription.getSubscribedBy());
        if (subscription.getStartingAt() != null) {
            subscriptionEntity.startingAt(ZonedDateTime.ofInstant(subscription.getStartingAt().toInstant(), ZoneId.systemDefault()));
        }
        if (subscription.getEndingAt() != null) {
            subscriptionEntity.endingAt(ZonedDateTime.ofInstant(subscription.getEndingAt().toInstant(), ZoneId.systemDefault()));
        }
        if (subscription.getCreatedAt() != null) {
            subscriptionEntity.createdAt(ZonedDateTime.ofInstant(subscription.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (subscription.getUpdatedAt() != null) {
            subscriptionEntity.updatedAt(ZonedDateTime.ofInstant(subscription.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (subscription.getClosedAt() != null) {
            subscriptionEntity.closedAt(ZonedDateTime.ofInstant(subscription.getClosedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (subscription.getPausedAt() != null) {
            subscriptionEntity.pausedAt(ZonedDateTime.ofInstant(subscription.getPausedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (subscription.getConsumerPausedAt() != null) {
            subscriptionEntity.consumerPausedAt(ZonedDateTime.ofInstant(subscription.getConsumerPausedAt().toInstant(), ZoneId.systemDefault()));
        }
        subscriptionEntity.generalConditionsContentRevision(subscription.getGeneralConditionsContentRevision());
        subscriptionEntity.generalConditionsContentPageId(subscription.getGeneralConditionsContentPageId());
        subscriptionEntity.generalConditionsAccepted(subscription.getGeneralConditionsAccepted());
        subscriptionEntity.daysToExpirationOnLastNotification(subscription.getDaysToExpirationOnLastNotification());
        Map map = subscription.getMetadata();
        if (map != null) {
            subscriptionEntity.metadata(new LinkedHashMap<String, String>(map));
        }
        subscriptionEntity.type(this.typeToType(subscription.getType()));
        subscriptionEntity.failureCause(subscription.getFailureCause());
        subscriptionEntity.configuration(this.deserializeConfiguration(subscription.getConfiguration()));
        return subscriptionEntity.build();
    }

    @Override
    public Subscription fromEntity(SubscriptionEntity subscription) {
        if (subscription == null) {
            return null;
        }
        Subscription.SubscriptionBuilder subscription1 = Subscription.builder();
        subscription1.api(subscription.getApiId());
        subscription1.plan(subscription.getPlanId());
        subscription1.application(subscription.getApplicationId());
        subscription1.request(subscription.getRequestMessage());
        subscription1.reason(subscription.getReasonMessage());
        subscription1.id(subscription.getId());
        subscription1.environmentId(subscription.getEnvironmentId());
        subscription1.clientId(subscription.getClientId());
        subscription1.clientCertificate(subscription.getClientCertificate());
        if (subscription.getProcessedAt() != null) {
            subscription1.processedAt(Date.from(subscription.getProcessedAt().toInstant()));
        }
        subscription1.status(this.statusToStatus1(subscription.getStatus()));
        subscription1.consumerStatus(this.consumerStatusToConsumerStatus1(subscription.getConsumerStatus()));
        subscription1.processedBy(subscription.getProcessedBy());
        subscription1.subscribedBy(subscription.getSubscribedBy());
        if (subscription.getStartingAt() != null) {
            subscription1.startingAt(Date.from(subscription.getStartingAt().toInstant()));
        }
        if (subscription.getEndingAt() != null) {
            subscription1.endingAt(Date.from(subscription.getEndingAt().toInstant()));
        }
        if (subscription.getCreatedAt() != null) {
            subscription1.createdAt(Date.from(subscription.getCreatedAt().toInstant()));
        }
        if (subscription.getUpdatedAt() != null) {
            subscription1.updatedAt(Date.from(subscription.getUpdatedAt().toInstant()));
        }
        if (subscription.getClosedAt() != null) {
            subscription1.closedAt(Date.from(subscription.getClosedAt().toInstant()));
        }
        if (subscription.getPausedAt() != null) {
            subscription1.pausedAt(Date.from(subscription.getPausedAt().toInstant()));
        }
        if (subscription.getConsumerPausedAt() != null) {
            subscription1.consumerPausedAt(Date.from(subscription.getConsumerPausedAt().toInstant()));
        }
        subscription1.generalConditionsContentRevision(subscription.getGeneralConditionsContentRevision());
        subscription1.generalConditionsContentPageId(subscription.getGeneralConditionsContentPageId());
        subscription1.generalConditionsAccepted(subscription.getGeneralConditionsAccepted());
        subscription1.daysToExpirationOnLastNotification(subscription.getDaysToExpirationOnLastNotification());
        Map<String, String> map = subscription.getMetadata();
        if (map != null) {
            subscription1.metadata(new LinkedHashMap<String, String>(map));
        }
        subscription1.type(this.typeToType1(subscription.getType()));
        subscription1.failureCause(subscription.getFailureCause());
        subscription1.configuration(this.serializeConfiguration(subscription.getConfiguration()));
        return subscription1.build();
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity map(SubscriptionEntity subscription) {
        if (subscription == null) {
            return null;
        }
        SubscriptionEntity.SubscriptionEntityBuilder subscriptionEntity = io.gravitee.rest.api.model.SubscriptionEntity.builder();
        subscriptionEntity.api(subscription.getApiId());
        subscriptionEntity.plan(subscription.getPlanId());
        subscriptionEntity.application(subscription.getApplicationId());
        subscriptionEntity.request(subscription.getRequestMessage());
        subscriptionEntity.reason(subscription.getReasonMessage());
        subscriptionEntity.id(subscription.getId());
        subscriptionEntity.environmentId(subscription.getEnvironmentId());
        subscriptionEntity.status(this.statusToSubscriptionStatus(subscription.getStatus()));
        subscriptionEntity.consumerStatus(this.consumerStatusToSubscriptionConsumerStatus(subscription.getConsumerStatus()));
        if (subscription.getProcessedAt() != null) {
            subscriptionEntity.processedAt(Date.from(subscription.getProcessedAt().toInstant()));
        }
        subscriptionEntity.processedBy(subscription.getProcessedBy());
        subscriptionEntity.subscribedBy(subscription.getSubscribedBy());
        if (subscription.getStartingAt() != null) {
            subscriptionEntity.startingAt(Date.from(subscription.getStartingAt().toInstant()));
        }
        if (subscription.getEndingAt() != null) {
            subscriptionEntity.endingAt(Date.from(subscription.getEndingAt().toInstant()));
        }
        if (subscription.getCreatedAt() != null) {
            subscriptionEntity.createdAt(Date.from(subscription.getCreatedAt().toInstant()));
        }
        if (subscription.getUpdatedAt() != null) {
            subscriptionEntity.updatedAt(Date.from(subscription.getUpdatedAt().toInstant()));
        }
        if (subscription.getClosedAt() != null) {
            subscriptionEntity.closedAt(Date.from(subscription.getClosedAt().toInstant()));
        }
        if (subscription.getPausedAt() != null) {
            subscriptionEntity.pausedAt(Date.from(subscription.getPausedAt().toInstant()));
        }
        if (subscription.getConsumerPausedAt() != null) {
            subscriptionEntity.consumerPausedAt(Date.from(subscription.getConsumerPausedAt().toInstant()));
        }
        subscriptionEntity.clientId(subscription.getClientId());
        subscriptionEntity.clientCertificate(subscription.getClientCertificate());
        subscriptionEntity.daysToExpirationOnLastNotification(subscription.getDaysToExpirationOnLastNotification());
        subscriptionEntity.configuration(this.subscriptionConfigurationToSubscriptionConfigurationEntity(subscription.getConfiguration()));
        Map<String, String> map = subscription.getMetadata();
        if (map != null) {
            subscriptionEntity.metadata(new LinkedHashMap<String, String>(map));
        }
        subscriptionEntity.failureCause(subscription.getFailureCause());
        return subscriptionEntity.build();
    }

    protected SubscriptionEntity.Status statusToStatus(Subscription.Status status) {
        if (status == null) {
            return null;
        }
        return switch (status) {
            case Subscription.Status.PENDING -> SubscriptionEntity.Status.PENDING;
            case Subscription.Status.REJECTED -> SubscriptionEntity.Status.REJECTED;
            case Subscription.Status.ACCEPTED -> SubscriptionEntity.Status.ACCEPTED;
            case Subscription.Status.CLOSED -> SubscriptionEntity.Status.CLOSED;
            case Subscription.Status.PAUSED -> SubscriptionEntity.Status.PAUSED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + status);
        };
    }

    protected SubscriptionEntity.ConsumerStatus consumerStatusToConsumerStatus(Subscription.ConsumerStatus consumerStatus) {
        if (consumerStatus == null) {
            return null;
        }
        return switch (consumerStatus) {
            case Subscription.ConsumerStatus.STARTED -> SubscriptionEntity.ConsumerStatus.STARTED;
            case Subscription.ConsumerStatus.STOPPED -> SubscriptionEntity.ConsumerStatus.STOPPED;
            case Subscription.ConsumerStatus.FAILURE -> SubscriptionEntity.ConsumerStatus.FAILURE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + consumerStatus);
        };
    }

    protected SubscriptionEntity.Type typeToType(Subscription.Type type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            case Subscription.Type.STANDARD -> SubscriptionEntity.Type.STANDARD;
            case Subscription.Type.PUSH -> SubscriptionEntity.Type.PUSH;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + type);
        };
    }

    protected Subscription.Status statusToStatus1(SubscriptionEntity.Status status) {
        if (status == null) {
            return null;
        }
        return switch (status) {
            case SubscriptionEntity.Status.PENDING -> Subscription.Status.PENDING;
            case SubscriptionEntity.Status.REJECTED -> Subscription.Status.REJECTED;
            case SubscriptionEntity.Status.ACCEPTED -> Subscription.Status.ACCEPTED;
            case SubscriptionEntity.Status.CLOSED -> Subscription.Status.CLOSED;
            case SubscriptionEntity.Status.PAUSED -> Subscription.Status.PAUSED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + status);
        };
    }

    protected Subscription.ConsumerStatus consumerStatusToConsumerStatus1(SubscriptionEntity.ConsumerStatus consumerStatus) {
        if (consumerStatus == null) {
            return null;
        }
        return switch (consumerStatus) {
            case SubscriptionEntity.ConsumerStatus.STARTED -> Subscription.ConsumerStatus.STARTED;
            case SubscriptionEntity.ConsumerStatus.STOPPED -> Subscription.ConsumerStatus.STOPPED;
            case SubscriptionEntity.ConsumerStatus.FAILURE -> Subscription.ConsumerStatus.FAILURE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + consumerStatus);
        };
    }

    protected Subscription.Type typeToType1(SubscriptionEntity.Type type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            case SubscriptionEntity.Type.STANDARD -> Subscription.Type.STANDARD;
            case SubscriptionEntity.Type.PUSH -> Subscription.Type.PUSH;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + type);
        };
    }

    protected SubscriptionStatus statusToSubscriptionStatus(SubscriptionEntity.Status status) {
        if (status == null) {
            return null;
        }
        return switch (status) {
            case SubscriptionEntity.Status.PENDING -> SubscriptionStatus.PENDING;
            case SubscriptionEntity.Status.REJECTED -> SubscriptionStatus.REJECTED;
            case SubscriptionEntity.Status.ACCEPTED -> SubscriptionStatus.ACCEPTED;
            case SubscriptionEntity.Status.CLOSED -> SubscriptionStatus.CLOSED;
            case SubscriptionEntity.Status.PAUSED -> SubscriptionStatus.PAUSED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + status);
        };
    }

    protected SubscriptionConsumerStatus consumerStatusToSubscriptionConsumerStatus(SubscriptionEntity.ConsumerStatus consumerStatus) {
        if (consumerStatus == null) {
            return null;
        }
        return switch (consumerStatus) {
            case SubscriptionEntity.ConsumerStatus.STARTED -> SubscriptionConsumerStatus.STARTED;
            case SubscriptionEntity.ConsumerStatus.STOPPED -> SubscriptionConsumerStatus.STOPPED;
            case SubscriptionEntity.ConsumerStatus.FAILURE -> SubscriptionConsumerStatus.FAILURE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + consumerStatus);
        };
    }

    protected SubscriptionConfigurationEntity subscriptionConfigurationToSubscriptionConfigurationEntity(SubscriptionConfiguration subscriptionConfiguration) {
        if (subscriptionConfiguration == null) {
            return null;
        }
        SubscriptionConfigurationEntity.SubscriptionConfigurationEntityBuilder subscriptionConfigurationEntity = SubscriptionConfigurationEntity.builder();
        subscriptionConfigurationEntity.entrypointId(subscriptionConfiguration.getEntrypointId());
        subscriptionConfigurationEntity.channel(subscriptionConfiguration.getChannel());
        subscriptionConfigurationEntity.entrypointConfiguration(subscriptionConfiguration.getEntrypointConfiguration());
        return subscriptionConfigurationEntity.build();
    }
}

