/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.apim.core.membership.domain_service.IntegrationPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.domain_service.IntegrationPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.UuidString;
import java.time.ZonedDateTime;
import lombok.Generated;

@UseCase
public class CreateIntegrationUseCase {
    private final IntegrationCrudService integrationCrudService;
    private final LicenseDomainService licenseDomainService;
    private final IntegrationPrimaryOwnerFactory integrationPrimaryOwnerFactory;
    private final IntegrationPrimaryOwnerDomainService integrationPrimaryOwnerDomainService;

    public Output execute(Input input) {
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.auditInfo.organizationId())) {
            throw NotAllowedDomainException.noLicenseForFederation();
        }
        ZonedDateTime now = TimeProvider.now();
        Object integrationToCreate = ((Integration.IntegrationBuilder)((Integration.IntegrationBuilder)((Integration.IntegrationBuilder)((Integration.IntegrationBuilder)((Integration.IntegrationBuilder)((Integration.IntegrationBuilder)((Integration.IntegrationBuilder)Integration.builder().id(UuidString.generateRandom())).name(input.integration.getName())).description(input.integration.getDescription())).provider(input.integration.getProvider())).environmentId(input.integration.getEnvironmentId())).createdAt(now)).updatedAt(now)).build();
        Integration integrationCreated = this.integrationCrudService.create((Integration)integrationToCreate);
        PrimaryOwnerEntity primaryOwner = this.integrationPrimaryOwnerFactory.createForNewIntegration(input.auditInfo.organizationId(), input.auditInfo.environmentId(), input.auditInfo.actor().userId());
        this.integrationPrimaryOwnerDomainService.createIntegrationPrimaryOwnerMembership(integrationCreated.getId(), primaryOwner, input.auditInfo);
        return new Output(integrationCreated);
    }

    @Generated
    public CreateIntegrationUseCase(IntegrationCrudService integrationCrudService, LicenseDomainService licenseDomainService, IntegrationPrimaryOwnerFactory integrationPrimaryOwnerFactory, IntegrationPrimaryOwnerDomainService integrationPrimaryOwnerDomainService) {
        this.integrationCrudService = integrationCrudService;
        this.licenseDomainService = licenseDomainService;
        this.integrationPrimaryOwnerFactory = integrationPrimaryOwnerFactory;
        this.integrationPrimaryOwnerDomainService = integrationPrimaryOwnerDomainService;
    }

    public record Input(Integration integration, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private Integration integration;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder integration(Integration integration) {
                this.integration = integration;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.integration, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "CreateIntegrationUseCase.Input.InputBuilder(integration=" + this.integration + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(Integration createdIntegration) {
    }
}

