/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.model.ApiKeyMode;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.Subscription;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApplicationApiKeyModeUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationApiKeyModeUpgrader.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationApiKeyModeUpgrader.class);
    @Lazy
    @Autowired
    private PlanRepository planRepository;
    @Lazy
    @Autowired
    private ApplicationRepository applicationRepository;
    @Lazy
    @Autowired
    private SubscriptionRepository subscriptionRepository;

    public int getOrder() {
        return 500;
    }

    public boolean upgrade() {
        try {
            List<String> apiKeyPlansIds = this.findAllApiKeyPlansId();
            Map<String, Long> apiKeySubscriptionsCountByApplication = this.countApiKeySubscriptionsByApplication(apiKeyPlansIds);
            this.applicationRepository.findAll().forEach(application -> {
                if (application.getApiKeyMode() == null || application.getApiKeyMode() == ApiKeyMode.UNSPECIFIED) {
                    Long apiKeysSubscriptionCount = apiKeySubscriptionsCountByApplication.getOrDefault(application.getId(), 0L);
                    this.updateApplicationApiKeyMode((Application)application, apiKeysSubscriptionCount > 1L ? ApiKeyMode.EXCLUSIVE : ApiKeyMode.UNSPECIFIED);
                }
            });
        }
        catch (Exception e) {
            log.error("failed to apply {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }

    private List<String> findAllApiKeyPlansId() throws TechnicalException {
        return this.planRepository.findAll().stream().filter(p -> p.getSecurity() == Plan.PlanSecurityType.API_KEY).map(Plan::getId).collect(Collectors.toList());
    }

    private Map<String, Long> countApiKeySubscriptionsByApplication(List<String> apiKeyPlansIds) throws TechnicalException {
        return this.subscriptionRepository.findAll().stream().filter(s -> apiKeyPlansIds.contains(s.getPlan())).collect(Collectors.groupingBy(Subscription::getApplication, Collectors.counting()));
    }

    private void updateApplicationApiKeyMode(Application application, ApiKeyMode apiKeyMode) {
        application.setApiKeyMode(apiKeyMode);
        try {
            this.applicationRepository.update((Object)application);
        }
        catch (TechnicalException e) {
            LOGGER.error("Failed to set EXCLUSIVE ApiKeyMode to application {}", (Object)application, (Object)e);
        }
    }
}

