/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.scoring;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.scoring.model.ScoreRequest;
import io.gravitee.apim.core.scoring.model.ScoringAssetType;
import io.gravitee.apim.core.scoring.service_provider.ScoringProvider;
import io.gravitee.cockpit.api.CockpitConnector;
import io.gravitee.cockpit.api.command.v1.scoring.request.ScoringRequestCommand;
import io.gravitee.cockpit.api.command.v1.scoring.request.ScoringRequestCommandPayload;
import io.gravitee.cockpit.api.command.v1.scoring.request.ScoringRequestReply;
import io.gravitee.exchange.api.command.Command;
import io.gravitee.exchange.api.command.CommandStatus;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.scoring.api.model.ScoringRequest;
import io.gravitee.scoring.api.model.asset.AssetToAnalyze;
import io.gravitee.scoring.api.model.asset.AssetType;
import io.gravitee.scoring.api.model.asset.ContentType;
import io.reactivex.rxjava3.core.Completable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ScoringProviderImpl
implements ScoringProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScoringProviderImpl.class);
    private final CockpitConnector cockpitConnector;
    private final InstallationService installationService;

    public ScoringProviderImpl(@Lazy CockpitConnector cockpitConnector, InstallationService installationService) {
        this.cockpitConnector = cockpitConnector;
        this.installationService = installationService;
    }

    @Override
    public Completable requestScore(ScoreRequest request) {
        ScoringRequestCommand command = new ScoringRequestCommand(new ScoringRequestCommandPayload(request.jobId(), request.organizationId(), request.environmentId(), (String)this.installationService.get().getAdditionalInformation().get("COCKPIT_INSTALLATION_ID"), new ScoringRequest(request.assets().stream().map(a -> {
            String string = a.assetId();
            return new AssetToAnalyze(string, switch (a.assetType()) {
                default -> throw new IncompatibleClassChangeError();
                case ScoringAssetType.SWAGGER -> AssetType.OPEN_API;
                case ScoringAssetType.ASYNCAPI -> AssetType.ASYNC_API;
                case ScoringAssetType.GRAVITEE_DEFINITION -> AssetType.GRAVITEE_API;
            }, a.assetName(), a.content(), this.detectContentType(a.content()));
        }).toList(), request.customRulesets())));
        return this.cockpitConnector.sendCommand((Command)command).onErrorReturn(error -> new ScoringRequestReply(command.getId(), error.getMessage() != null ? error.getMessage() : error.toString())).cast(ScoringRequestReply.class).flatMapCompletable(reply -> {
            if (reply.getCommandStatus() == CommandStatus.ERROR) {
                return Completable.error((Throwable)new TechnicalDomainException(reply.getErrorDetails()));
            }
            return Completable.complete();
        });
    }

    private ContentType detectContentType(String content) {
        if (content.startsWith("{")) {
            return ContentType.JSON;
        }
        return ContentType.YAML;
    }
}

