/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.audit;

import io.gravitee.apim.core.api.model.ApiAuditQueryFilters;
import io.gravitee.apim.core.audit.query_service.AuditQueryService;
import io.gravitee.apim.infra.adapter.AuditAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.management.api.AuditRepository;
import io.gravitee.repository.management.api.search.AuditCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.rest.api.model.common.Pageable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AuditQueryServiceImpl
implements AuditQueryService {
    private final AuditRepository auditRepository;

    public AuditQueryServiceImpl(@Lazy AuditRepository auditRepository) {
        this.auditRepository = auditRepository;
    }

    @Override
    public AuditQueryService.SearchResponse searchApiAudit(ApiAuditQueryFilters query, Pageable pageable) {
        AuditCriteria.Builder criteria = new AuditCriteria.Builder().organizationId(query.organizationId()).environmentIds(List.of(query.environmentId())).references(Audit.AuditReferenceType.API, List.of(query.apiId())).events((List)(query.events() != null ? new ArrayList<String>(query.events()) : null));
        query.from().ifPresent(arg_0 -> ((AuditCriteria.Builder)criteria).from(arg_0));
        query.to().ifPresent(arg_0 -> ((AuditCriteria.Builder)criteria).to(arg_0));
        Page result = this.auditRepository.search(criteria.build(), new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build());
        return new AuditQueryService.SearchResponse(result.getTotalElements(), result.getContent().stream().map(AuditAdapter.INSTANCE::toEntity).toList());
    }
}

