/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.searcher;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.ReferenceContext;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.impl.search.lucene.searcher.AbstractDocumentSearcher;
import io.gravitee.rest.api.service.search.query.Query;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.springframework.stereotype.Component;

@Component
public class UserDocumentSearcher
extends AbstractDocumentSearcher {
    protected static final String FIELD_TYPE_VALUE = "user";

    public UserDocumentSearcher(IndexWriter indexWriter) {
        super(indexWriter);
    }

    public SearchResult search(ExecutionContext executionContext, Query query) throws TechnicalException {
        MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"displayname", "displayname_reverted", "email", "reference", "custom", "custom_split"}, this.analyzer);
        parser.setFuzzyMinSim(0.6f);
        parser.setAllowLeadingWildcard(true);
        BooleanQuery.Builder userQuery = new BooleanQuery.Builder();
        BooleanQuery.Builder userFieldsQuery = new BooleanQuery.Builder();
        try {
            String normalizedQuery = StringUtils.stripAccents((String)query.getQuery().toLowerCase());
            if (this.isUserIdFormat(query)) {
                userFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("id", normalizedQuery)), BooleanClause.Occur.MUST);
            } else {
                String[] tokens;
                for (String token : tokens = normalizedQuery.split(" ")) {
                    userFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("displayname", "*" + token + "*")), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new WildcardQuery(new Term("displayname_reverted", "*" + token + "*")), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new WildcardQuery(new Term("email", "*" + token + "*")), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new WildcardQuery(new Term("reference", "*" + token + "*")), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new WildcardQuery(new Term("custom", "*" + token + "*")), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)new WildcardQuery(new Term("custom_split", token)), BooleanClause.Occur.SHOULD);
                }
            }
            userQuery.add((org.apache.lucene.search.Query)userFieldsQuery.build(), BooleanClause.Occur.MUST);
            userQuery.add(parser.parse(QueryParserBase.escape((String)query.getQuery())), BooleanClause.Occur.SHOULD);
            userQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term("type", FIELD_TYPE_VALUE)), BooleanClause.Occur.MUST);
            BooleanQuery.Builder orgCriteria = new BooleanQuery.Builder();
            orgCriteria.add((org.apache.lucene.search.Query)new TermQuery(new Term("reference_type", ReferenceContext.Type.ORGANIZATION.name())), BooleanClause.Occur.MUST);
            orgCriteria.add((org.apache.lucene.search.Query)new TermQuery(new Term("reference_id", executionContext.getOrganizationId())), BooleanClause.Occur.MUST);
            userQuery.add((org.apache.lucene.search.Query)orgCriteria.build(), BooleanClause.Occur.FILTER);
            return this.search((org.apache.lucene.search.Query)userQuery.build(), null, query.getPage());
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for user documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for user documents", (Throwable)pe);
        }
    }

    private boolean isUserIdFormat(Query query) {
        try {
            UUID.fromString(query.getQuery());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return source.isAssignableFrom(UserEntity.class);
    }
}

