/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.scoring;

import io.gravitee.apim.core.scoring.crud_service.ScoringReportCrudService;
import io.gravitee.apim.infra.adapter.ScoringReportAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ScoringReportRepository;
import io.gravitee.repository.management.model.ScoringReport;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ScoringReportCrudServiceImpl
extends AbstractService
implements ScoringReportCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScoringReportCrudServiceImpl.class);
    private final ScoringReportRepository scoringReportRepository;

    public ScoringReportCrudServiceImpl(@Lazy ScoringReportRepository scoringReportRepository) {
        this.scoringReportRepository = scoringReportRepository;
    }

    @Override
    public io.gravitee.apim.core.scoring.model.ScoringReport create(io.gravitee.apim.core.scoring.model.ScoringReport scoringReport) {
        try {
            ScoringReport created = this.scoringReportRepository.create(ScoringReportAdapter.INSTANCE.toRepository(scoringReport));
            return ScoringReportAdapter.INSTANCE.toEntity(created);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when creating Scoring Report for API: " + scoringReport.apiId(), e);
        }
    }

    @Override
    public void deleteByApi(String apiId) {
        try {
            this.scoringReportRepository.deleteByApi(apiId);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when deleting Scoring Report for API: " + apiId, e);
        }
    }
}

