/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.shared_policy_group;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.query_service.SharedPolicyGroupQueryService;
import io.gravitee.apim.infra.adapter.SharedPolicyGroupAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.SharedPolicyGroupRepository;
import io.gravitee.repository.management.api.search.SharedPolicyGroupCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SharedPolicyGroupQueryServiceImpl
implements SharedPolicyGroupQueryService {
    private final SharedPolicyGroupRepository sharedPolicyGroupRepository;
    private final SharedPolicyGroupAdapter sharedPolicyGroupAdapter;
    private static final Logger logger = LoggerFactory.getLogger(SharedPolicyGroupQueryServiceImpl.class);

    public SharedPolicyGroupQueryServiceImpl(@Lazy SharedPolicyGroupRepository sharedPolicyGroupRepository, SharedPolicyGroupAdapter sharedPolicyGroupAdapter) {
        this.sharedPolicyGroupRepository = sharedPolicyGroupRepository;
        this.sharedPolicyGroupAdapter = sharedPolicyGroupAdapter;
    }

    @Override
    public Page<SharedPolicyGroup> searchByEnvironmentId(String environmentId, String q, Pageable pageable, Sortable sortable) {
        try {
            SharedPolicyGroupCriteria criteria = SharedPolicyGroupCriteria.builder().query(q).environmentId(environmentId).build();
            Page result = this.sharedPolicyGroupRepository.search(criteria, new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build(), new SortableBuilder().field(sortable.getField()).setAsc(sortable.isAscOrder()).build());
            return result.map(this.sharedPolicyGroupAdapter::toEntity);
        }
        catch (TechnicalException e) {
            logger.error("An error occurred while searching shared policy groups by environment ID {}", (Object)environmentId, (Object)e);
            throw new TechnicalDomainException("An error occurred while trying to search shared policy groups by environment ID: " + environmentId, e);
        }
    }
}

