/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_menu_link.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_menu_link.crud_service.PortalMenuLinkCrudService;
import io.gravitee.apim.core.portal_menu_link.model.CreatePortalMenuLink;
import io.gravitee.apim.core.portal_menu_link.model.PortalMenuLink;
import io.gravitee.apim.core.portal_menu_link.query_service.PortalMenuLinkQueryService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import lombok.Generated;

@UseCase
public class CreatePortalMenuLinkUseCase {
    private final PortalMenuLinkCrudService portalMenuLinkCrudService;
    private final PortalMenuLinkQueryService portalMenuLinkQueryService;

    public Output execute(Input input) {
        int newOrder = this.portalMenuLinkQueryService.findByEnvironmentIdSortByOrder(input.environmentId()).size() + 1;
        PortalMenuLink portalMenuLinkToCreate = PortalMenuLink.builder().id(UuidString.generateRandom()).environmentId(input.environmentId()).type(input.portalMenuLinkToCreate().getType()).name(input.portalMenuLinkToCreate().getName()).target(input.portalMenuLinkToCreate().getTarget()).visibility(input.portalMenuLinkToCreate().getVisibility()).order(newOrder).build();
        this.validatePortalMenuLinkToCreate(portalMenuLinkToCreate);
        return new Output(this.portalMenuLinkCrudService.create(portalMenuLinkToCreate));
    }

    private void validatePortalMenuLinkToCreate(PortalMenuLink portalMenuLinkToCreate) {
        if (portalMenuLinkToCreate.getName() == null || portalMenuLinkToCreate.getName().isEmpty()) {
            throw new InvalidDataException("Name is required.");
        }
    }

    @Generated
    public CreatePortalMenuLinkUseCase(PortalMenuLinkCrudService portalMenuLinkCrudService, PortalMenuLinkQueryService portalMenuLinkQueryService) {
        this.portalMenuLinkCrudService = portalMenuLinkCrudService;
        this.portalMenuLinkQueryService = portalMenuLinkQueryService;
    }

    public record Input(String environmentId, CreatePortalMenuLink portalMenuLinkToCreate) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String environmentId;
            @Generated
            private CreatePortalMenuLink portalMenuLinkToCreate;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder environmentId(String environmentId) {
                this.environmentId = environmentId;
                return this;
            }

            @Generated
            public InputBuilder portalMenuLinkToCreate(CreatePortalMenuLink portalMenuLinkToCreate) {
                this.portalMenuLinkToCreate = portalMenuLinkToCreate;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.environmentId, this.portalMenuLinkToCreate);
            }

            @Generated
            public String toString() {
                return "CreatePortalMenuLinkUseCase.Input.InputBuilder(environmentId=" + this.environmentId + ", portalMenuLinkToCreate=" + this.portalMenuLinkToCreate + ")";
            }
        }
    }

    public record Output(PortalMenuLink portalMenuLink) {
    }
}

