/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.use_case;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.query_service.SharedPolicyGroupHistoryQueryService;
import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import java.util.Set;
import lombok.Generated;

@DomainService
public class SearchSharedPolicyGroupHistoryUseCase {
    private final SharedPolicyGroupHistoryQueryService sharedPolicyGroupHistoryQueryService;
    private static final Set<String> allowedSortableFields = Set.of("version", "-version", "updatedAt", "-updatedAt", "deployedAt", "-deployedAt");

    public Output execute(Input input) {
        SearchSharedPolicyGroupHistoryUseCase.validateInput(input);
        Pageable pageable = input.pageable != null ? input.pageable : new PageableImpl(1, 10);
        Sortable sortable = SearchSharedPolicyGroupHistoryUseCase.toSortable(input.sortBy());
        return new Output(this.sharedPolicyGroupHistoryQueryService.search(input.environmentId, input.sharedPolicyGroupId, pageable, sortable));
    }

    private static void validateInput(Input input) {
        if (input.sharedPolicyGroupId == null) {
            throw new IllegalArgumentException("SharedPolicyGroupId is required");
        }
    }

    private static Sortable toSortable(String sortBy) {
        SearchSharedPolicyGroupHistoryUseCase.validateSortBy(sortBy);
        if (sortBy == null) {
            return new SortableImpl("updatedAt", false);
        }
        boolean isAscending = !sortBy.startsWith("-");
        String field = isAscending ? sortBy : sortBy.substring(1);
        return new SortableImpl(field, isAscending);
    }

    private static void validateSortBy(String sortBy) {
        if (sortBy != null && !allowedSortableFields.contains(sortBy)) {
            throw new IllegalArgumentException("Invalid sort by field: " + sortBy);
        }
    }

    @Generated
    public SearchSharedPolicyGroupHistoryUseCase(SharedPolicyGroupHistoryQueryService sharedPolicyGroupHistoryQueryService) {
        this.sharedPolicyGroupHistoryQueryService = sharedPolicyGroupHistoryQueryService;
    }

    public record Input(String environmentId, String sharedPolicyGroupId, Pageable pageable, String sortBy) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String environmentId;
            @Generated
            private String sharedPolicyGroupId;
            @Generated
            private Pageable pageable;
            @Generated
            private String sortBy;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder environmentId(String environmentId) {
                this.environmentId = environmentId;
                return this;
            }

            @Generated
            public InputBuilder sharedPolicyGroupId(String sharedPolicyGroupId) {
                this.sharedPolicyGroupId = sharedPolicyGroupId;
                return this;
            }

            @Generated
            public InputBuilder pageable(Pageable pageable) {
                this.pageable = pageable;
                return this;
            }

            @Generated
            public InputBuilder sortBy(String sortBy) {
                this.sortBy = sortBy;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.environmentId, this.sharedPolicyGroupId, this.pageable, this.sortBy);
            }

            @Generated
            public String toString() {
                return "SearchSharedPolicyGroupHistoryUseCase.Input.InputBuilder(environmentId=" + this.environmentId + ", sharedPolicyGroupId=" + this.sharedPolicyGroupId + ", pageable=" + this.pageable + ", sortBy=" + this.sortBy + ")";
            }
        }
    }

    public record Output(Page<SharedPolicyGroup> result) {
    }
}

