/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.ImportDefinitionCreateDomainService;
import io.gravitee.apim.core.api.domain_service.OAIDomainService;
import io.gravitee.apim.core.api.exception.InvalidImportWithOASValidationPolicyException;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.api.model.import_definition.ImportDefinition;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.plugin.crud_service.PolicyPluginCrudService;
import io.gravitee.apim.core.plugin.domain_service.EndpointConnectorPluginDomainService;
import io.gravitee.apim.core.plugin.model.PolicyPlugin;
import io.gravitee.apim.core.tag.model.Tag;
import io.gravitee.apim.core.tag.query_service.TagQueryService;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.selector.HttpSelector;
import io.gravitee.definition.model.v4.flow.step.Step;
import io.gravitee.definition.model.v4.resource.Resource;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

@UseCase
public class OAIToImportApiUseCase {
    protected static final String DEFAULT_IMPORT_PAGE_NAME = "Swagger";
    private final OAIDomainService oaiDomainService;
    private final GroupQueryService groupQueryService;
    private final TagQueryService tagsQueryService;
    private final EndpointConnectorPluginDomainService endpointConnectorPluginService;
    private final ImportDefinitionCreateDomainService importDefinitionCreateDomainService;
    private final PolicyPluginCrudService policyPluginCrudService;

    public OAIToImportApiUseCase(OAIDomainService oaiDomainService, GroupQueryService groupQueryService, TagQueryService tagsQueryService, EndpointConnectorPluginDomainService endpointConnectorPluginService, ImportDefinitionCreateDomainService importDefinitionCreateDomainService, PolicyPluginCrudService policyPluginCrudService) {
        this.oaiDomainService = oaiDomainService;
        this.groupQueryService = groupQueryService;
        this.tagsQueryService = tagsQueryService;
        this.endpointConnectorPluginService = endpointConnectorPluginService;
        this.importDefinitionCreateDomainService = importDefinitionCreateDomainService;
        this.policyPluginCrudService = policyPluginCrudService;
    }

    public Output execute(Input input) {
        String environmentId;
        String organizationId = input.auditInfo.organizationId();
        ImportDefinition importDefinition = this.oaiDomainService.convert(organizationId, environmentId = input.auditInfo.environmentId(), input.importSwaggerDescriptor);
        if (importDefinition != null) {
            ImportDefinition importWithEndpointGroupsSharedConfiguration = this.addEndpointGroupSharedConfiguration(importDefinition);
            ImportDefinition importWithGroups = this.replaceGroupNamesWithIds(environmentId, importWithEndpointGroupsSharedConfiguration);
            ImportDefinition importWithTags = this.replaceTagsNamesWithIds(organizationId, importWithGroups);
            ImportDefinition importWithDocumentation = this.addOAIDocumentation(input.withDocumentation(), input.importSwaggerDescriptor.getPayload(), importWithTags);
            ImportDefinition importWithOASValidationPolicy = this.addOASValidationPolicy(input.withOASValidationPolicy(), input.importSwaggerDescriptor.getPayload(), importWithDocumentation);
            ApiWithFlows apiWithFlows = this.importDefinitionCreateDomainService.create(input.auditInfo, importWithOASValidationPolicy);
            return new Output(apiWithFlows);
        }
        return null;
    }

    private ImportDefinition addEndpointGroupSharedConfiguration(ImportDefinition importDefinition) {
        String sharedConfiguration = this.endpointConnectorPluginService.getSharedConfigurationSchema("http-proxy");
        List<EndpointGroup> endpointGroups = importDefinition.getApiExport().getEndpointGroups();
        if (endpointGroups == null || endpointGroups.isEmpty()) {
            return importDefinition;
        }
        return importDefinition.toBuilder().apiExport(importDefinition.getApiExport().toBuilder().endpointGroups(endpointGroups.stream().map(endpointGroup -> endpointGroup.toBuilder().sharedConfiguration(sharedConfiguration).build()).toList()).build()).build();
    }

    private ImportDefinition replaceGroupNamesWithIds(String environmentId, ImportDefinition importDefinition) {
        Set<String> groups = importDefinition.getApiExport().getGroups();
        if (groups == null || groups.isEmpty()) {
            return importDefinition;
        }
        return importDefinition.toBuilder().apiExport(importDefinition.getApiExport().toBuilder().groups(groups.stream().flatMap(group -> this.groupQueryService.findByNames(environmentId, Set.of(group)).stream()).map(Group::getId).collect(Collectors.toSet())).build()).build();
    }

    private ImportDefinition replaceTagsNamesWithIds(String organizationId, ImportDefinition importDefinition) {
        if (importDefinition.getApiExport() == null || importDefinition.getApiExport().getTags() == null || importDefinition.getApiExport().getTags().isEmpty()) {
            return importDefinition;
        }
        return importDefinition.toBuilder().apiExport(importDefinition.getApiExport().toBuilder().tags(importDefinition.getApiExport().getTags().stream().flatMap(group -> this.tagsQueryService.findByName(organizationId, (String)group).stream()).map(Tag::getId).collect(Collectors.toSet())).build()).build();
    }

    private ImportDefinition addOAIDocumentation(boolean withDocumentation, String payload, ImportDefinition importWithTags) {
        if (!withDocumentation) {
            return importWithTags;
        }
        Page page = Page.builder().name(DEFAULT_IMPORT_PAGE_NAME).type(Page.Type.SWAGGER).homepage(false).content(payload).referenceType(Page.ReferenceType.API).published(true).visibility(Page.Visibility.PUBLIC).build();
        return importWithTags.toBuilder().pages(List.of(page)).build();
    }

    private ImportDefinition addOASValidationPolicy(boolean withOASValidationPolicy, String payload, ImportDefinition importDefinition) {
        if (!withOASValidationPolicy) {
            return importDefinition;
        }
        PolicyPlugin oasValidationPolicy = this.policyPluginCrudService.get("oas-validation").orElseThrow(() -> new InvalidImportWithOASValidationPolicyException("Policy not found"));
        try {
            Resource resource = Resource.builder().name("OpenAPI Specification").type("content-provider-inline-resource").configuration(new ObjectMapper().writeValueAsString(new LinkedHashMap<String, String>(Map.of("content", payload)))).build();
            importDefinition.getApiExport().setResources(List.of(resource));
            Step step = Step.builder().policy(oasValidationPolicy.getId()).name(oasValidationPolicy.getName()).configuration((Object)new ObjectMapper().writeValueAsString(new LinkedHashMap<String, String>(Map.of("resourceName", "OpenAPI Specification")))).build();
            HttpSelector httpSelector = HttpSelector.builder().path("/").pathOperator(Operator.STARTS_WITH).build();
            Flow flow = Flow.builder().name("OpenAPI Specification Validation").selectors(List.of(httpSelector)).request(List.of(step)).response(List.of(step)).build();
            importDefinition.getApiExport().getFlows().add(0, flow);
            return importDefinition;
        }
        catch (JsonProcessingException e) {
            throw new TechnicalManagementException("Error while serializing OpenAPI Specification", e);
        }
    }

    public record Input(ImportSwaggerDescriptorEntity importSwaggerDescriptor, boolean withDocumentation, boolean withOASValidationPolicy, AuditInfo auditInfo) {
        Input(ImportSwaggerDescriptorEntity importSwaggerDescriptor, AuditInfo auditInfo) {
            this(importSwaggerDescriptor, false, false, auditInfo);
        }

        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private ImportSwaggerDescriptorEntity importSwaggerDescriptor;
            @Generated
            private boolean withDocumentation;
            @Generated
            private boolean withOASValidationPolicy;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder importSwaggerDescriptor(ImportSwaggerDescriptorEntity importSwaggerDescriptor) {
                this.importSwaggerDescriptor = importSwaggerDescriptor;
                return this;
            }

            @Generated
            public InputBuilder withDocumentation(boolean withDocumentation) {
                this.withDocumentation = withDocumentation;
                return this;
            }

            @Generated
            public InputBuilder withOASValidationPolicy(boolean withOASValidationPolicy) {
                this.withOASValidationPolicy = withOASValidationPolicy;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.importSwaggerDescriptor, this.withDocumentation, this.withOASValidationPolicy, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "OAIToImportApiUseCase.Input.InputBuilder(importSwaggerDescriptor=" + this.importSwaggerDescriptor + ", withDocumentation=" + this.withDocumentation + ", withOASValidationPolicy=" + this.withOASValidationPolicy + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(ApiWithFlows apiWithFlows) {
    }
}

