/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.resource;

import io.gravitee.apim.core.resource.domain_service.ValidateResourceDomainService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.definition.model.v4.resource.Resource;
import io.gravitee.rest.api.service.v4.validation.ResourcesValidationService;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ValidateResourceDomainServiceLegacyWrapper
implements ValidateResourceDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateResourceDomainServiceLegacyWrapper.class);
    private final ResourcesValidationService resourcesValidationService;

    @Override
    public Validator.Result<ValidateResourceDomainService.Input> validateAndSanitize(ValidateResourceDomainService.Input input) {
        if (CollectionUtils.isEmpty(input.resources())) {
            log.debug("no resource to resolve");
            return Validator.Result.ofValue(input);
        }
        log.debug("validating resources");
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        for (Resource resource : input.resources()) {
            try {
                this.resourcesValidationService.validateAndSanitize(List.of(resource));
            }
            catch (Exception e) {
                errors.add(Validator.Error.severe("Resource [%s] configuration is not valid", resource.getName()));
            }
        }
        return Validator.Result.ofBoth(input.sanitized(input.resources()), errors);
    }

    @Generated
    public ValidateResourceDomainServiceLegacyWrapper(ResourcesValidationService resourcesValidationService) {
        this.resourcesValidationService = resourcesValidationService;
    }
}

