/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.model.AccessControl;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.validation.Validator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class ValidatePageAccessControlsDomainService
implements Validator<Input> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidatePageAccessControlsDomainService.class);
    private final GroupQueryService groupQueryService;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        if (input.accessControls == null) {
            log.debug("returning an empty validation result as there are no access controls to sanitize");
            return Validator.Result.empty();
        }
        HashSet<AccessControl> sanitized = new HashSet<AccessControl>(this.sanitizeGroupIds(input.auditInfo.environmentId(), input.accessControls));
        return Validator.Result.ofValue(input.sanitized(sanitized));
    }

    private Set<AccessControl> sanitizeGroupIds(String environmentId, Set<AccessControl> accessControls) {
        HashSet<AccessControl> acl = new HashSet<AccessControl>(accessControls.stream().filter(AccessControl::isGroup).toList());
        Map<String, String> groupIdToReference = this.mapGroupIdToReference(environmentId, acl);
        Iterator<AccessControl> it = acl.iterator();
        while (it.hasNext()) {
            AccessControl ac = it.next();
            String id = groupIdToReference.get(ac.getReferenceId());
            if (id != null) {
                ac.setReferenceId(id);
                continue;
            }
            log.debug("removing access control {} as it does not match a valid reference", (Object)ac);
            it.remove();
        }
        return acl;
    }

    private Map<String, String> mapGroupIdToReference(String environmentId, Set<AccessControl> accessControls) {
        Set<String> references = accessControls.stream().map(AccessControl::getReferenceId).collect(Collectors.toSet());
        Map<String, String> byIds = this.groupQueryService.findByIds(references).stream().collect(Collectors.toMap(Group::getId, Group::getId));
        Map<String, String> byNames = this.groupQueryService.findByNames(environmentId, references).stream().collect(Collectors.toMap(Group::getName, Group::getId));
        HashMap<String, String> mapping = new HashMap<String, String>(byIds);
        mapping.putAll(byNames);
        return mapping;
    }

    @Generated
    public ValidatePageAccessControlsDomainService(GroupQueryService groupQueryService) {
        this.groupQueryService = groupQueryService;
    }

    public record Input(AuditInfo auditInfo, Set<AccessControl> accessControls) implements Validator.Input
    {
        Input sanitized(Set<AccessControl> accessControls) {
            return new Input(this.auditInfo, accessControls);
        }
    }
}

