/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.documentation.model.AccessControl;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.model.PageMedia;
import io.gravitee.apim.core.documentation.model.PageRevision;
import io.gravitee.apim.core.documentation.model.PageSource;
import io.gravitee.apim.infra.adapter.PageAdapter;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.PageReferenceType;
import io.gravitee.repository.management.model.PageRevision;
import io.gravitee.repository.management.model.PageSource;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PageAdapterImpl
implements PageAdapter {
    @Override
    public Page toEntity(io.gravitee.repository.management.model.Page page) {
        Map map1;
        if (page == null) {
            return null;
        }
        Page.PageBuilder page1 = Page.builder();
        if (page.getVisibility() != null) {
            page1.visibility(Enum.valueOf(Page.Visibility.class, page.getVisibility()));
        }
        page1.id(page.getId());
        page1.crossId(page.getCrossId());
        page1.referenceId(page.getReferenceId());
        page1.referenceType(this.pageReferenceTypeToReferenceType(page.getReferenceType()));
        page1.name(page.getName());
        if (page.getType() != null) {
            page1.type(Enum.valueOf(Page.Type.class, page.getType()));
        }
        page1.lastContributor(page.getLastContributor());
        page1.order(page.getOrder());
        page1.published(page.isPublished());
        page1.createdAt(page.getCreatedAt());
        page1.updatedAt(page.getUpdatedAt());
        page1.parentId(page.getParentId());
        page1.excludedAccessControls(page.isExcludedAccessControls());
        page1.accessControls(this.accessControlSetToAccessControlSet(page.getAccessControls()));
        page1.content(page.getContent());
        page1.homepage(page.isHomepage());
        page1.source(this.pageSourceToPageSource(page.getSource()));
        Map map = page.getConfiguration();
        if (map != null) {
            page1.configuration(new LinkedHashMap<String, String>(map));
        }
        if ((map1 = page.getMetadata()) != null) {
            page1.metadata(new LinkedHashMap<String, String>(map1));
        }
        page1.useAutoFetch(page.getUseAutoFetch());
        page1.attachedMedia(this.pageMediaListToPageMediaList(page.getAttachedMedia()));
        return page1.build();
    }

    @Override
    public io.gravitee.repository.management.model.Page toRepository(Page page) {
        if (page == null) {
            return null;
        }
        Page.PageBuilder page1 = io.gravitee.repository.management.model.Page.builder();
        page1.id(page.getId());
        page1.crossId(page.getCrossId());
        page1.referenceId(page.getReferenceId());
        page1.referenceType(this.referenceTypeToPageReferenceType(page.getReferenceType()));
        page1.name(page.getName());
        if (page.getType() != null) {
            page1.type(page.getType().name());
        }
        page1.content(page.getContent());
        page1.lastContributor(page.getLastContributor());
        page1.order(page.getOrder());
        page1.published(page.isPublished());
        if (page.getVisibility() != null) {
            page1.visibility(page.getVisibility().name());
        }
        page1.source(this.pageSourceToPageSource1(page.getSource()));
        Map<String, String> map = page.getConfiguration();
        if (map != null) {
            page1.configuration(new LinkedHashMap<String, String>(map));
        }
        page1.homepage(page.isHomepage());
        page1.createdAt(page.getCreatedAt());
        page1.updatedAt(page.getUpdatedAt());
        page1.parentId(page.getParentId());
        page1.excludedAccessControls(page.isExcludedAccessControls());
        page1.accessControls(this.accessControlSetToAccessControlSet1(page.getAccessControls()));
        Map<String, String> map1 = page.getMetadata();
        if (map1 != null) {
            page1.metadata(new LinkedHashMap<String, String>(map1));
        }
        page1.useAutoFetch(page.getUseAutoFetch());
        page1.attachedMedia(this.pageMediaListToPageMediaList1(page.getAttachedMedia()));
        return page1.build();
    }

    @Override
    public PageRevision toPageRevisionRepository(io.gravitee.apim.core.documentation.model.PageRevision page) {
        if (page == null) {
            return null;
        }
        PageRevision.PageRevisionBuilder pageRevision = PageRevision.builder();
        pageRevision.createdAt(page.getModificationDate());
        pageRevision.pageId(page.getPageId());
        pageRevision.revision(page.getRevision());
        pageRevision.name(page.getName());
        pageRevision.hash(page.getHash());
        pageRevision.content(page.getContent());
        pageRevision.contributor(page.getContributor());
        return pageRevision.build();
    }

    @Override
    public io.gravitee.apim.core.documentation.model.PageRevision toPageRevision(Page page) {
        if (page == null) {
            return null;
        }
        PageRevision.PageRevisionBuilder pageRevision = io.gravitee.apim.core.documentation.model.PageRevision.builder();
        pageRevision.pageId(page.getId());
        pageRevision.modificationDate(page.getUpdatedAt());
        pageRevision.contributor(page.getLastContributor());
        pageRevision.name(page.getName());
        pageRevision.content(page.getContent());
        return pageRevision.build();
    }

    @Override
    public List<Page> toEntityList(List<io.gravitee.repository.management.model.Page> pages) {
        if (pages == null) {
            return null;
        }
        ArrayList<Page> list = new ArrayList<Page>(pages.size());
        for (io.gravitee.repository.management.model.Page page : pages) {
            list.add(this.toEntity(page));
        }
        return list;
    }

    @Override
    public io.gravitee.apim.core.documentation.model.PageRevision toEntity(PageRevision pageRevision) {
        if (pageRevision == null) {
            return null;
        }
        PageRevision.PageRevisionBuilder pageRevision1 = io.gravitee.apim.core.documentation.model.PageRevision.builder();
        pageRevision1.modificationDate(pageRevision.getCreatedAt());
        pageRevision1.pageId(pageRevision.getPageId());
        pageRevision1.revision(pageRevision.getRevision());
        pageRevision1.name(pageRevision.getName());
        pageRevision1.hash(pageRevision.getHash());
        pageRevision1.content(pageRevision.getContent());
        pageRevision1.contributor(pageRevision.getContributor());
        return pageRevision1.build();
    }

    protected Page.ReferenceType pageReferenceTypeToReferenceType(PageReferenceType pageReferenceType) {
        if (pageReferenceType == null) {
            return null;
        }
        return switch (pageReferenceType) {
            case PageReferenceType.ENVIRONMENT -> Page.ReferenceType.ENVIRONMENT;
            case PageReferenceType.API -> Page.ReferenceType.API;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + pageReferenceType);
        };
    }

    protected AccessControl accessControlToAccessControl(io.gravitee.repository.management.model.AccessControl accessControl) {
        if (accessControl == null) {
            return null;
        }
        AccessControl.AccessControlBuilder accessControl1 = AccessControl.builder();
        accessControl1.referenceId(accessControl.getReferenceId());
        accessControl1.referenceType(accessControl.getReferenceType());
        return accessControl1.build();
    }

    protected Set<AccessControl> accessControlSetToAccessControlSet(Set<io.gravitee.repository.management.model.AccessControl> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<AccessControl> set1 = new LinkedHashSet<AccessControl>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (io.gravitee.repository.management.model.AccessControl accessControl : set) {
            set1.add(this.accessControlToAccessControl(accessControl));
        }
        return set1;
    }

    protected io.gravitee.apim.core.documentation.model.PageSource pageSourceToPageSource(PageSource pageSource) {
        if (pageSource == null) {
            return null;
        }
        PageSource.PageSourceBuilder pageSource1 = io.gravitee.apim.core.documentation.model.PageSource.builder();
        pageSource1.type(pageSource.getType());
        pageSource1.configuration(pageSource.getConfiguration());
        return pageSource1.build();
    }

    protected PageMedia pageMediaToPageMedia(io.gravitee.repository.management.model.PageMedia pageMedia) {
        if (pageMedia == null) {
            return null;
        }
        PageMedia.PageMediaBuilder pageMedia1 = PageMedia.builder();
        pageMedia1.mediaHash(pageMedia.getMediaHash());
        pageMedia1.mediaName(pageMedia.getMediaName());
        pageMedia1.attachedAt(pageMedia.getAttachedAt());
        return pageMedia1.build();
    }

    protected List<PageMedia> pageMediaListToPageMediaList(List<io.gravitee.repository.management.model.PageMedia> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PageMedia> list1 = new ArrayList<PageMedia>(list.size());
        for (io.gravitee.repository.management.model.PageMedia pageMedia : list) {
            list1.add(this.pageMediaToPageMedia(pageMedia));
        }
        return list1;
    }

    protected PageReferenceType referenceTypeToPageReferenceType(Page.ReferenceType referenceType) {
        if (referenceType == null) {
            return null;
        }
        return switch (referenceType) {
            case Page.ReferenceType.ENVIRONMENT -> PageReferenceType.ENVIRONMENT;
            case Page.ReferenceType.API -> PageReferenceType.API;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + referenceType);
        };
    }

    protected PageSource pageSourceToPageSource1(io.gravitee.apim.core.documentation.model.PageSource pageSource) {
        if (pageSource == null) {
            return null;
        }
        PageSource pageSource1 = new PageSource();
        pageSource1.setType(pageSource.getType());
        pageSource1.setConfiguration(pageSource.getConfiguration());
        return pageSource1;
    }

    protected io.gravitee.repository.management.model.AccessControl accessControlToAccessControl1(AccessControl accessControl) {
        if (accessControl == null) {
            return null;
        }
        io.gravitee.repository.management.model.AccessControl accessControl1 = new io.gravitee.repository.management.model.AccessControl();
        accessControl1.setReferenceType(accessControl.getReferenceType());
        accessControl1.setReferenceId(accessControl.getReferenceId());
        return accessControl1;
    }

    protected Set<io.gravitee.repository.management.model.AccessControl> accessControlSetToAccessControlSet1(Set<AccessControl> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<io.gravitee.repository.management.model.AccessControl> set1 = new LinkedHashSet<io.gravitee.repository.management.model.AccessControl>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (AccessControl accessControl : set) {
            set1.add(this.accessControlToAccessControl1(accessControl));
        }
        return set1;
    }

    protected io.gravitee.repository.management.model.PageMedia pageMediaToPageMedia1(PageMedia pageMedia) {
        if (pageMedia == null) {
            return null;
        }
        io.gravitee.repository.management.model.PageMedia pageMedia1 = new io.gravitee.repository.management.model.PageMedia();
        pageMedia1.setMediaHash(pageMedia.getMediaHash());
        pageMedia1.setMediaName(pageMedia.getMediaName());
        pageMedia1.setAttachedAt(pageMedia.getAttachedAt());
        return pageMedia1;
    }

    protected List<io.gravitee.repository.management.model.PageMedia> pageMediaListToPageMediaList1(List<PageMedia> list) {
        if (list == null) {
            return null;
        }
        ArrayList<io.gravitee.repository.management.model.PageMedia> list1 = new ArrayList<io.gravitee.repository.management.model.PageMedia>(list.size());
        for (PageMedia pageMedia : list) {
            list1.add(this.pageMediaToPageMedia1(pageMedia));
        }
        return list1;
    }
}

