/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.common;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class UuidString {
    private static final Function<String, String> DEFAULT_GENERATOR = seed -> {
        if (seed == null) {
            return io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random());
        }
        return io.gravitee.common.utils.UUID.toString((UUID)UUID.nameUUIDFromBytes(seed.getBytes()));
    };
    private static Function<String, String> uuidGenerator = DEFAULT_GENERATOR;

    private UuidString() {
    }

    public static String generateRandom() {
        return uuidGenerator.apply(null);
    }

    public static String generateForEnvironment(String environmentId, String ... fields) {
        if (Stream.of(fields).anyMatch(Objects::isNull)) {
            return UuidString.generateRandom();
        }
        StringBuilder b = new StringBuilder();
        b.append(environmentId);
        for (String f : fields) {
            b.append(f);
        }
        return uuidGenerator.apply(b.toString());
    }

    public static void overrideGenerator(Function<String, String> newGenerator) {
        uuidGenerator = newGenerator;
    }

    public static void overrideGenerator(Supplier<String> newGenerator) {
        uuidGenerator = seed -> (String)newGenerator.get();
    }

    public static void reset() {
        uuidGenerator = DEFAULT_GENERATOR;
    }
}

