/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.application.registration;

import io.gravitee.rest.api.model.NewApplicationEntity;
import io.gravitee.rest.api.model.UpdateApplicationEntity;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.gravitee.rest.api.model.application.OAuthClientSettings;
import io.gravitee.rest.api.service.impl.configuration.application.registration.ClientRegistrationMapper;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.register.ClientRegistrationRequest;
import java.util.ArrayList;
import java.util.List;

public class ClientRegistrationMapperImpl
implements ClientRegistrationMapper {
    @Override
    public ClientRegistrationRequest toClientRegistrationRequest(ClientRegistrationRequest target, NewApplicationEntity application) {
        String clientUri;
        String applicationType;
        if (application == null) {
            return target;
        }
        if (application.getName() != null) {
            target.setClientName(application.getName());
        }
        if ((applicationType = this.applicationSettingsOauthApplicationType(application)) != null) {
            target.setApplicationType(applicationType);
        }
        if ((clientUri = this.applicationSettingsOauthClientUri(application)) != null) {
            target.setClientUri(clientUri);
        }
        List<String> grantTypes = this.applicationSettingsOauthGrantTypes(application);
        if (target.getGrantTypes() != null) {
            list = grantTypes;
            if (list != null) {
                target.getGrantTypes().clear();
                target.getGrantTypes().addAll(list);
            }
        } else {
            list = grantTypes;
            if (list != null) {
                target.setGrantTypes(new ArrayList<String>(list));
            }
        }
        String logoUri = this.applicationSettingsOauthLogoUri(application);
        if (logoUri != null) {
            target.setLogoUri(logoUri);
        }
        List<String> redirectUris = this.applicationSettingsOauthRedirectUris(application);
        if (target.getRedirectUris() != null) {
            list1 = redirectUris;
            if (list1 != null) {
                target.getRedirectUris().clear();
                target.getRedirectUris().addAll(list1);
            }
        } else {
            list1 = redirectUris;
            if (list1 != null) {
                target.setRedirectUris(new ArrayList<String>(list1));
            }
        }
        List<String> responseTypes = this.applicationSettingsOauthResponseTypes(application);
        if (target.getResponseTypes() != null) {
            List<String> list2 = responseTypes;
            if (list2 != null) {
                target.getResponseTypes().clear();
                target.getResponseTypes().addAll(list2);
            }
        } else {
            List<String> list2 = responseTypes;
            if (list2 != null) {
                target.setResponseTypes(new ArrayList<String>(list2));
            }
        }
        return target;
    }

    @Override
    public void toClientRegistrationRequest(ClientRegistrationRequest target, UpdateApplicationEntity application) {
        String clientUri;
        String applicationType;
        if (application == null) {
            return;
        }
        if (application.getName() != null) {
            target.setClientName(application.getName());
        }
        if ((applicationType = this.applicationSettingsOauthApplicationType1(application)) != null) {
            target.setApplicationType(applicationType);
        }
        if ((clientUri = this.applicationSettingsOauthClientUri1(application)) != null) {
            target.setClientUri(clientUri);
        }
        List<String> grantTypes = this.applicationSettingsOauthGrantTypes1(application);
        if (target.getGrantTypes() != null) {
            list = grantTypes;
            if (list != null) {
                target.getGrantTypes().clear();
                target.getGrantTypes().addAll(list);
            }
        } else {
            list = grantTypes;
            if (list != null) {
                target.setGrantTypes(new ArrayList<String>(list));
            }
        }
        String logoUri = this.applicationSettingsOauthLogoUri1(application);
        if (logoUri != null) {
            target.setLogoUri(logoUri);
        }
        List<String> redirectUris = this.applicationSettingsOauthRedirectUris1(application);
        if (target.getRedirectUris() != null) {
            list1 = redirectUris;
            if (list1 != null) {
                target.getRedirectUris().clear();
                target.getRedirectUris().addAll(list1);
            }
        } else {
            list1 = redirectUris;
            if (list1 != null) {
                target.setRedirectUris(new ArrayList<String>(list1));
            }
        }
        List<String> responseTypes = this.applicationSettingsOauthResponseTypes1(application);
        if (target.getResponseTypes() != null) {
            List<String> list2 = responseTypes;
            if (list2 != null) {
                target.getResponseTypes().clear();
                target.getResponseTypes().addAll(list2);
            }
        } else {
            List<String> list2 = responseTypes;
            if (list2 != null) {
                target.setResponseTypes(new ArrayList<String>(list2));
            }
        }
    }

    @Override
    public void mergeClientRegistrationRequest(ClientRegistrationRequest target, ClientRegistrationRequest source) {
        if (source == null) {
            return;
        }
        if (target.getRedirectUris() != null) {
            list = source.getRedirectUris();
            if (list != null) {
                target.getRedirectUris().clear();
                target.getRedirectUris().addAll(list);
            }
        } else {
            list = source.getRedirectUris();
            if (list != null) {
                target.setRedirectUris(new ArrayList<String>(list));
            }
        }
        if (target.getResponseTypes() != null) {
            list1 = source.getResponseTypes();
            if (list1 != null) {
                target.getResponseTypes().clear();
                target.getResponseTypes().addAll(list1);
            }
        } else {
            list1 = source.getResponseTypes();
            if (list1 != null) {
                target.setResponseTypes(new ArrayList<String>(list1));
            }
        }
        if (target.getGrantTypes() != null) {
            list2 = source.getGrantTypes();
            if (list2 != null) {
                target.getGrantTypes().clear();
                target.getGrantTypes().addAll(list2);
            }
        } else {
            list2 = source.getGrantTypes();
            if (list2 != null) {
                target.setGrantTypes(new ArrayList<String>(list2));
            }
        }
        if (source.getApplicationType() != null) {
            target.setApplicationType(source.getApplicationType());
        }
        if (target.getContacts() != null) {
            list3 = source.getContacts();
            if (list3 != null) {
                target.getContacts().clear();
                target.getContacts().addAll(list3);
            }
        } else {
            list3 = source.getContacts();
            if (list3 != null) {
                target.setContacts(new ArrayList<String>(list3));
            }
        }
        if (source.getClientName() != null) {
            target.setClientName(source.getClientName());
        }
        if (source.getLogoUri() != null) {
            target.setLogoUri(source.getLogoUri());
        }
        if (source.getClientUri() != null) {
            target.setClientUri(source.getClientUri());
        }
        if (source.getPolicyUri() != null) {
            target.setPolicyUri(source.getPolicyUri());
        }
        if (source.getTosUri() != null) {
            target.setTosUri(source.getTosUri());
        }
        if (source.getJwksUri() != null) {
            target.setJwksUri(source.getJwksUri());
        }
        if (source.getSectorIdentifierUri() != null) {
            target.setSectorIdentifierUri(source.getSectorIdentifierUri());
        }
        if (source.getSubjectType() != null) {
            target.setSubjectType(source.getSubjectType());
        }
        if (source.getIdTokenSignedResponseAlg() != null) {
            target.setIdTokenSignedResponseAlg(source.getIdTokenSignedResponseAlg());
        }
        if (source.getIdTokenEncryptedResponseAlg() != null) {
            target.setIdTokenEncryptedResponseAlg(source.getIdTokenEncryptedResponseAlg());
        }
        if (source.getIdTokenEncryptedResponseEnc() != null) {
            target.setIdTokenEncryptedResponseEnc(source.getIdTokenEncryptedResponseEnc());
        }
        if (source.getUserinfoSignedResponseAlg() != null) {
            target.setUserinfoSignedResponseAlg(source.getUserinfoSignedResponseAlg());
        }
        if (source.getUserinfoEncryptedResponseAlg() != null) {
            target.setUserinfoEncryptedResponseAlg(source.getUserinfoEncryptedResponseAlg());
        }
        if (source.getUserinfoEncryptedResponseEnc() != null) {
            target.setUserinfoEncryptedResponseEnc(source.getUserinfoEncryptedResponseEnc());
        }
        if (source.getRequestObjectSigningAlg() != null) {
            target.setRequestObjectSigningAlg(source.getRequestObjectSigningAlg());
        }
        if (source.getRequestObjectEncryptionAlg() != null) {
            target.setRequestObjectEncryptionAlg(source.getRequestObjectEncryptionAlg());
        }
        if (source.getRequestObjectEncryptionEnc() != null) {
            target.setRequestObjectEncryptionEnc(source.getRequestObjectEncryptionEnc());
        }
        if (source.getTokenEndpointAuthMethod() != null) {
            target.setTokenEndpointAuthMethod(source.getTokenEndpointAuthMethod());
        }
        if (source.getTokenEndpointAuthSigningAlg() != null) {
            target.setTokenEndpointAuthSigningAlg(source.getTokenEndpointAuthSigningAlg());
        }
        if (source.getDefaultMaxAge() != null) {
            target.setDefaultMaxAge(source.getDefaultMaxAge());
        }
        if (source.getRequireAuthTime() != null) {
            target.setRequireAuthTime(source.getRequireAuthTime());
        }
        if (target.getDefaultACRvalues() != null) {
            list4 = source.getDefaultACRvalues();
            if (list4 != null) {
                target.getDefaultACRvalues().clear();
                target.getDefaultACRvalues().addAll(list4);
            }
        } else {
            list4 = source.getDefaultACRvalues();
            if (list4 != null) {
                target.setDefaultACRvalues(new ArrayList<String>(list4));
            }
        }
        if (source.getInitiateLoginUri() != null) {
            target.setInitiateLoginUri(source.getInitiateLoginUri());
        }
        if (target.getRequestUris() != null) {
            list5 = source.getRequestUris();
            if (list5 != null) {
                target.getRequestUris().clear();
                target.getRequestUris().addAll(list5);
            }
        } else {
            list5 = source.getRequestUris();
            if (list5 != null) {
                target.setRequestUris(new ArrayList<String>(list5));
            }
        }
        if (source.getScope() != null) {
            target.setScope(this.map(source.getScope()));
        }
        if (source.getSoftwareId() != null) {
            target.setSoftwareId(source.getSoftwareId());
        }
        if (source.getSoftwareVersion() != null) {
            target.setSoftwareVersion(source.getSoftwareVersion());
        }
        if (source.getSoftwareStatement() != null) {
            target.setSoftwareStatement(source.getSoftwareStatement());
        }
    }

    private String applicationSettingsOauthApplicationType(NewApplicationEntity newApplicationEntity) {
        ApplicationSettings settings = newApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getApplicationType();
    }

    private String applicationSettingsOauthClientUri(NewApplicationEntity newApplicationEntity) {
        ApplicationSettings settings = newApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getClientUri();
    }

    private List<String> applicationSettingsOauthGrantTypes(NewApplicationEntity newApplicationEntity) {
        ApplicationSettings settings = newApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getGrantTypes();
    }

    private String applicationSettingsOauthLogoUri(NewApplicationEntity newApplicationEntity) {
        ApplicationSettings settings = newApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getLogoUri();
    }

    private List<String> applicationSettingsOauthRedirectUris(NewApplicationEntity newApplicationEntity) {
        ApplicationSettings settings = newApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getRedirectUris();
    }

    private List<String> applicationSettingsOauthResponseTypes(NewApplicationEntity newApplicationEntity) {
        ApplicationSettings settings = newApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getResponseTypes();
    }

    private String applicationSettingsOauthApplicationType1(UpdateApplicationEntity updateApplicationEntity) {
        ApplicationSettings settings = updateApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getApplicationType();
    }

    private String applicationSettingsOauthClientUri1(UpdateApplicationEntity updateApplicationEntity) {
        ApplicationSettings settings = updateApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getClientUri();
    }

    private List<String> applicationSettingsOauthGrantTypes1(UpdateApplicationEntity updateApplicationEntity) {
        ApplicationSettings settings = updateApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getGrantTypes();
    }

    private String applicationSettingsOauthLogoUri1(UpdateApplicationEntity updateApplicationEntity) {
        ApplicationSettings settings = updateApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getLogoUri();
    }

    private List<String> applicationSettingsOauthRedirectUris1(UpdateApplicationEntity updateApplicationEntity) {
        ApplicationSettings settings = updateApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getRedirectUris();
    }

    private List<String> applicationSettingsOauthResponseTypes1(UpdateApplicationEntity updateApplicationEntity) {
        ApplicationSettings settings = updateApplicationEntity.getSettings();
        if (settings == null) {
            return null;
        }
        OAuthClientSettings oauth = settings.getOauth();
        if (oauth == null) {
            return null;
        }
        return oauth.getResponseTypes();
    }
}

