/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.api;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.query_service.ApiCategoryQueryService;
import io.gravitee.apim.core.category.model.Category;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.CategoryRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ApiCategoryQueryServiceImpl
implements ApiCategoryQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiCategoryQueryServiceImpl.class);
    private final CategoryRepository categoryRepository;

    public ApiCategoryQueryServiceImpl(@Lazy CategoryRepository categoryRepository) {
        this.categoryRepository = categoryRepository;
    }

    @Override
    public Collection<String> findApiCategoryKeys(Api api) {
        try {
            Set<String> categoriesIds = api.getCategories();
            if (categoriesIds == null || categoriesIds.isEmpty()) {
                return Collections.emptySet();
            }
            return this.categoryRepository.findAllByEnvironment(api.getEnvironmentId()).stream().filter(category -> categoriesIds.contains(category.getId()) || categoriesIds.contains(category.getKey())).map(io.gravitee.repository.management.model.Category::getKey).collect(Collectors.toSet());
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to find Categories for the api: " + api.getId(), e);
        }
    }

    @Override
    public Collection<Category> findByEnvironmentId(String environmentId) {
        try {
            return this.categoryRepository.findAllByEnvironment(environmentId).stream().map(category -> Category.builder().key(category.getKey()).name(category.getName()).id(category.getId()).build()).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("Cannot find categories for environment " + environmentId, e);
        }
    }
}

