/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.portal_menu_link;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.portal_menu_link.crud_service.PortalMenuLinkCrudService;
import io.gravitee.apim.core.portal_menu_link.exception.PortalMenuLinkNotFoundException;
import io.gravitee.apim.infra.adapter.PortalMenuLinkAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalMenuLinkRepository;
import io.gravitee.repository.management.model.PortalMenuLink;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PortalMenuLinkCrudServiceImpl
implements PortalMenuLinkCrudService {
    private final PortalMenuLinkRepository portalMenuLinkRepository;
    private final PortalMenuLinkAdapter portalMenuLinkAdapter = PortalMenuLinkAdapter.INSTANCE;

    public PortalMenuLinkCrudServiceImpl(@Lazy PortalMenuLinkRepository portalMenuLinkRepository) {
        this.portalMenuLinkRepository = portalMenuLinkRepository;
    }

    @Override
    public io.gravitee.apim.core.portal_menu_link.model.PortalMenuLink create(io.gravitee.apim.core.portal_menu_link.model.PortalMenuLink portalMenuLink) {
        try {
            PortalMenuLink result = (PortalMenuLink)this.portalMenuLinkRepository.create((Object)this.portalMenuLinkAdapter.toRepository(portalMenuLink));
            return this.portalMenuLinkAdapter.toEntity(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurred while trying to create a PortalMenuLink with id: %s", portalMenuLink.getId()), e);
        }
    }

    @Override
    public io.gravitee.apim.core.portal_menu_link.model.PortalMenuLink update(io.gravitee.apim.core.portal_menu_link.model.PortalMenuLink portalMenuLink) {
        try {
            PortalMenuLink result = (PortalMenuLink)this.portalMenuLinkRepository.update((Object)this.portalMenuLinkAdapter.toRepository(portalMenuLink));
            return this.portalMenuLinkAdapter.toEntity(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurred while trying to update a PortalMenuLink with id: %s", portalMenuLink.getId()), e);
        }
    }

    @Override
    public io.gravitee.apim.core.portal_menu_link.model.PortalMenuLink getByIdAndEnvironmentId(String portalMenuLinkId, String environmentId) {
        try {
            return this.portalMenuLinkRepository.findByIdAndEnvironmentId(portalMenuLinkId, environmentId).map(this.portalMenuLinkAdapter::toEntity).orElseThrow(() -> new PortalMenuLinkNotFoundException(portalMenuLinkId));
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurred while trying to find a PortalMenuLink with id (%s) in environment (%s)", portalMenuLinkId, environmentId), e);
        }
    }

    @Override
    public void delete(String portalMenuLinkId) {
        try {
            this.portalMenuLinkRepository.delete((Object)portalMenuLinkId);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurred while trying to delete the PortalMenuLink with id: %s", portalMenuLinkId), e);
        }
    }
}

