/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.apim.core.access_point.query_service.AccessPointQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.listener.tcp.TcpListener;
import io.gravitee.rest.api.model.EntrypointEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.EntrypointService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.EntrypointNotFoundException;
import io.gravitee.rest.api.service.v4.ApiEntrypointService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiEntrypointServiceImpl
implements ApiEntrypointService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiEntrypointServiceImpl.class);
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("(?<!(http:|https:))[//]+");
    private static final String URI_PATH_SEPARATOR = "/";
    private final ParameterService parameterService;
    private final EntrypointService entrypointService;
    private final AccessPointQueryService accessPointQueryService;

    public ApiEntrypointServiceImpl(ParameterService parameterService, EntrypointService entrypointService, AccessPointQueryService accessPointQueryService) {
        this.parameterService = parameterService;
        this.entrypointService = entrypointService;
        this.accessPointQueryService = accessPointQueryService;
    }

    @Override
    public List<ApiEntrypointEntity> getApiEntrypoints(ExecutionContext executionContext, GenericApiEntity genericApiEntity) {
        ArrayList<ApiEntrypointEntity> apiEntrypoints = new ArrayList<ApiEntrypointEntity>();
        String defaultTcpPort = this.parameterService.find(executionContext, Key.PORTAL_TCP_PORT, executionContext.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT);
        if (genericApiEntity.getTags() != null && !genericApiEntity.getTags().isEmpty()) {
            List<EntrypointEntity> organizationEntrypoints = this.entrypointService.findAll(executionContext);
            organizationEntrypoints.forEach(entrypoint -> {
                String entrypointScheme = this.getScheme(entrypoint.getValue());
                String entrypointValue = entrypoint.getValue();
                HashSet<String> tagEntrypoints = new HashSet<String>(Arrays.asList(entrypoint.getTags()));
                tagEntrypoints.retainAll(genericApiEntity.getTags());
                if (tagEntrypoints.size() == entrypoint.getTags().length) {
                    apiEntrypoints.addAll(this.getEntrypoints(genericApiEntity, entrypointScheme, entrypointValue, defaultTcpPort, tagEntrypoints, executionContext.getEnvironmentId()));
                }
            });
        }
        if (apiEntrypoints.isEmpty()) {
            String defaultEntrypoint = this.parameterService.find(executionContext, Key.PORTAL_ENTRYPOINT, executionContext.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT);
            String defaultScheme = this.getScheme(defaultEntrypoint);
            apiEntrypoints.addAll(this.getEntrypoints(genericApiEntity, defaultScheme, defaultEntrypoint, defaultTcpPort, null, executionContext.getEnvironmentId()));
        }
        return apiEntrypoints;
    }

    private List<ApiEntrypointEntity> getEntrypoints(GenericApiEntity genericApiEntity, String entrypointScheme, String entrypointHost, String tcpPort, Set<String> tagEntrypoints, String environmentId) {
        if (genericApiEntity.getDefinitionVersion() == DefinitionVersion.FEDERATED) {
            return Collections.emptyList();
        }
        if (genericApiEntity.getDefinitionVersion() != DefinitionVersion.V4) {
            ApiEntity api = (ApiEntity)genericApiEntity;
            return api.getProxy().getVirtualHosts().stream().flatMap(virtualHost -> this.getHttpApiEntrypointEntity(entrypointScheme, entrypointHost, virtualHost.getHost(), virtualHost.getPath(), virtualHost.isOverrideEntrypoint(), tagEntrypoints, environmentId).stream()).toList();
        }
        io.gravitee.rest.api.model.v4.api.ApiEntity api = (io.gravitee.rest.api.model.v4.api.ApiEntity)genericApiEntity;
        return api.getListeners().stream().flatMap(listener -> {
            if (listener instanceof HttpListener) {
                HttpListener httpListener = (HttpListener)listener;
                return httpListener.getPaths().stream().flatMap(path -> this.getHttpApiEntrypointEntity(entrypointScheme, entrypointHost, path.getHost(), path.getPath(), path.isOverrideAccess(), tagEntrypoints, environmentId).stream());
            }
            if (listener instanceof TcpListener) {
                TcpListener tcpListener = (TcpListener)listener;
                return tcpListener.getHosts().stream().map(tcpHost -> this.getTcpApiEntrypointEntity((String)tcpHost, tcpPort, entrypointHost, tagEntrypoints));
            }
            return Stream.empty();
        }).toList();
    }

    private List<ApiEntrypointEntity> getHttpApiEntrypointEntity(String defaultScheme, String entrypointValue, String host, String path, boolean isOverride, Set<String> tags, String environmentId) {
        ArrayList<ApiEntrypointEntity> entrypoints = new ArrayList<ApiEntrypointEntity>();
        if (host == null || !isOverride) {
            List<AccessPoint> accessPoints = this.accessPointQueryService.getGatewayAccessPoints(environmentId);
            if (accessPoints.isEmpty() || tags != null && !tags.isEmpty()) {
                entrypoints.add(this.createApiEntrypointEntity(defaultScheme, entrypointValue, path, tags, host));
            } else {
                for (AccessPoint accessPoint : accessPoints) {
                    String targetHost = accessPoint.getHost();
                    String scheme = accessPoint.isSecured() ? "https" : "http";
                    entrypoints.add(this.createApiEntrypointEntity(scheme, targetHost, path, tags, targetHost));
                }
            }
        } else {
            entrypoints.add(this.createApiEntrypointEntity(defaultScheme, host, path, tags, host));
        }
        return entrypoints;
    }

    private ApiEntrypointEntity createApiEntrypointEntity(String defaultScheme, String host, String path, Set<String> tags, String originalHost) {
        if (!((String)host).toLowerCase().startsWith("http")) {
            host = defaultScheme + "://" + (String)host;
        }
        String url = DUPLICATE_SLASH_REMOVER.matcher((String)host + URI_PATH_SEPARATOR + path).replaceAll(URI_PATH_SEPARATOR);
        return new ApiEntrypointEntity(tags, url, originalHost);
    }

    private ApiEntrypointEntity getTcpApiEntrypointEntity(String tcpHost, String tcpPort, String host, Set<String> tags) {
        String target = String.join((CharSequence)":", tcpHost, tcpPort);
        return new ApiEntrypointEntity(tags, target, host);
    }

    private String getScheme(String entrypointValue) {
        String scheme = "https";
        if (entrypointValue != null) {
            try {
                scheme = new URL(entrypointValue).getProtocol();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return scheme;
    }

    @Override
    public String getApiEntrypointsListenerType(GenericApiEntity genericApiEntity) {
        if (genericApiEntity.getDefinitionVersion() == DefinitionVersion.V1 || genericApiEntity.getDefinitionVersion() == DefinitionVersion.V2) {
            return "HTTP";
        }
        io.gravitee.rest.api.model.v4.api.ApiEntity api = (io.gravitee.rest.api.model.v4.api.ApiEntity)genericApiEntity;
        return api.getListeners().stream().findFirst().map(listener -> listener.getType().toString()).orElseThrow(() -> new EntrypointNotFoundException(api.getId()));
    }
}

